/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.FrameSplitter;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.Airlines;
import org.apache.spark.examples.h2o.AirlinesParse$;
import org.apache.spark.examples.h2o.AirlinesWithWeatherDemo2$;
import org.apache.spark.examples.h2o.TestUtils$;
import org.apache.spark.examples.h2o.Weather;
import org.apache.spark.examples.h2o.WeatherParse$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import water.H2O;
import water.Key;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.fvec.Vec;
import water.support.H2OFrameSupport$;
import water.support.SparkContextSupport;
import water.support.SparkSessionSupport;

public final class AirlinesWithWeatherDemo2$
implements SparkContextSupport,
SparkSessionSupport {
    public static final AirlinesWithWeatherDemo2$ MODULE$;
    private final transient SparkSession spark;
    private final transient SQLContext sqlContext;
    private volatile transient byte bitmap$trans$0;
    private static Symbol symbol$1;
    private static Symbol symbol$2;

    static {
        symbol$1 = Symbol$.MODULE$.apply("ArrDelay");
        symbol$2 = Symbol$.MODULE$.apply("predict");
        new AirlinesWithWeatherDemo2$();
    }

    private SparkSession spark$lzycompute() {
        AirlinesWithWeatherDemo2$ airlinesWithWeatherDemo2$ = this;
        synchronized (airlinesWithWeatherDemo2$) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.spark = SparkSessionSupport.class.spark((SparkSessionSupport)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.spark;
        }
    }

    public SparkSession spark() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sqlContext$lzycompute() {
        AirlinesWithWeatherDemo2$ airlinesWithWeatherDemo2$ = this;
        synchronized (airlinesWithWeatherDemo2$) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.sqlContext = SparkSessionSupport.class.sqlContext((SparkSessionSupport)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.sqlContext;
        }
    }

    public SQLContext sqlContext() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.sqlContext$lzycompute() : this.sqlContext;
    }

    public SparkConf configure(String appName, String defaultMaster) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName, (String)defaultMaster);
    }

    public SparkContext sparkContext(SparkConf conf) {
        return SparkContextSupport.class.sparkContext((SparkContextSupport)this, (SparkConf)conf);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public void addFiles(SparkSession spark, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkSession)spark, files);
    }

    public String enforceLocalSparkFile(String file) {
        return SparkContextSupport.class.enforceLocalSparkFile((SparkContextSupport)this, (String)file);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String configure$default$2() {
        return SparkContextSupport.class.configure$default$2((SparkContextSupport)this);
    }

    public String residualPlotRCode(Frame prediction, String predCol, Frame actual, String actCol, H2OContext h2oContext) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (h2oContext == null) {
            tuple32 = new Tuple3((Object)"127.0.0.1", (Object)"54321", (Object)"");
        } else {
            String[] s = h2oContext.h2oLocalClient().split(":");
            tuple32 = tuple3 = new Tuple3((Object)s[0], (Object)s[1], (Object)s[2]);
        }
        if (tuple3 != null) {
            Tuple2 tuple2;
            String ip = (String)tuple3._1();
            String port = (String)tuple3._2();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)ip, (Object)port);
            String ip2 = (String)tuple22._1();
            String port2 = (String)tuple22._2();
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# R script for residual plot\n       |library(h2o)\n       |h = h2o.init(ip=\"", "\", port=", ")\n       |\n        |pred = h2o.getFrame(\"", "\")\n       |act = h2o.getFrame (\"", "\")\n       |\n        |predDelay = pred$", "\n       |actDelay = act$", "\n       |\n        |nrow(actDelay) == nrow(predDelay)\n       |\n        |residuals = predDelay - actDelay\n       |\n        |compare = cbind (as.data.frame(actDelay$ArrDelay), as.data.frame(residuals$predict))\n       |nrow(compare)\n       |plot( compare[,1:2] )\n       |\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ip2, port2, prediction._key, actual._key, predCol, actCol})))).stripMargin();
        }
        throw new MatchError((Object)tuple3);
    }

    public H2OContext residualPlotRCode$default$5() {
        return null;
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water Meetup: Use Airlines and Weather Data for delay prediction", this.configure$default$2());
        SparkContext sc = this.sparkContext(conf);
        H2OContext h2oContext = H2OContext$.MODULE$.getOrCreate(sc);
        this.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TestUtils$.MODULE$.locate("smalldata/chicago/Chicago_Ohare_International_Airport.csv")}));
        RDD wrawdata = sc.textFile(this.enforceLocalSparkFile("Chicago_Ohare_International_Airport.csv"), 3).cache();
        RDD weatherTable = wrawdata.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$2) {
                return x$2.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Weather apply(String[] row) {
                return WeatherParse$.MODULE$.apply(row);
            }
        }, ClassTag$.MODULE$.apply(Weather.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Weather x$3) {
                return !x$3.isWrongRow();
            }
        });
        H2OFrame airlinesData = new H2OFrame(new File(TestUtils$.MODULE$.locate("smalldata/airlines/year2005.csv.gz")));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.h2o.Airlines").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator4$1() {
            }
        }
        Dataset airlinesTable = h2oContext.asDataFrame((Frame)airlinesData, h2oContext.asDataFrame$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Airlines apply(Row row) {
                return AirlinesParse$.MODULE$.apply(row);
            }
        }, this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator4$1())));
        Dataset flightsToORD = airlinesTable.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Airlines f) {
                Option<String> option = f.Dest();
                Some some = new Some((Object)"ORD");
                return !(option != null ? !option.equals((Object)some) : some != null);
            }
        });
        flightsToORD.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nFlights to ORD: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)flightsToORD.count())})));
        flightsToORD.toDF().createOrReplaceTempView("FlightsToORD");
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.h2o.Weather").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator9$1() {
            }
        }
        this.spark().implicits().rddToDatasetHolder(weatherTable, this.spark().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator9$1()))).toDF().createOrReplaceTempView("WeatherORD");
        Dataset joinedTable = this.sqlContext().sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |f.Year,f.Month,f.DayofMonth,\n        |f.CRSDepTime,f.CRSArrTime,f.CRSElapsedTime,\n        |f.UniqueCarrier,f.FlightNum,f.TailNum,\n        |f.Origin,f.Distance,\n        |w.TmaxF,w.TminF,w.TmeanF,w.PrcpIn,w.SnowIn,w.CDD,w.HDD,w.GDD,\n        |f.ArrDelay\n        |FROM FlightsToORD f\n        |JOIN WeatherORD w\n        |ON f.Year=w.Year AND f.Month=w.Month AND f.DayofMonth=w.Day")).stripMargin());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nResult of query: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)joinedTable.count())})));
        H2OFrame joinedH2OFrame = h2oContext.implicits().asH2OFrameFromDataFrame(joinedTable);
        H2OFrameSupport$.MODULE$.withLockAndUpdate((Frame)joinedH2OFrame, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(H2OFrame fr) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1)new Serializable(this, fr){
                    public static final long serialVersionUID = 0L;
                    private final H2OFrame fr$1;

                    public final Vec apply(int i) {
                        return this.fr$1.replace(i, this.fr$1.vec(i).toCategoricalVec());
                    }
                    {
                        this.fr$1 = fr$1;
                    }
                });
            }
        });
        FrameSplitter sf = new FrameSplitter((Frame)joinedH2OFrame, new double[]{0.7, 0.2}, (Key[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"train", "valid", "test"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Key<Frame> apply(String x$4) {
                return Key.make((String)x$4);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Key.class))), null);
        H2O.submitTask((H2O.H2OCountedCompleter)sf);
        Frame[] splits = sf.getResult();
        Frame trainTable = splits[0];
        Frame validTable = splits[1];
        Frame testTable = splits[2];
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.implicits().toH2OFrameKeyFromFrame(trainTable);
        dlParams._response_column = h2oContext.implicits().symbolToString(symbol$1);
        dlParams._valid = h2oContext.implicits().toH2OFrameKeyFromFrame(validTable);
        dlParams._epochs = 5.0;
        dlParams._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        dlParams._hidden = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 100}), ClassTag$.MODULE$.Int());
        dlParams._reproducible = true;
        dlParams._force_load_balance = false;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        H2OFrame dlPredictTable = h2oContext.implicits().asH2OFrameFromFrame(dlModel.score(testTable)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$2}));
        Object[] predictionsFromDlModel = (Object[])Predef$.MODULE$.refArrayOps((Object[])h2oContext.asDataFrame((Frame)dlPredictTable, h2oContext.asDataFrame$default$2()).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                return row.isNullAt(0) ? BoxesRunTime.boxToDouble((double)Double.NaN) : row.apply(0);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)predictionsFromDlModel.length));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.genericArrayOps((Object)predictionsFromDlModel).mkString("\n===> Model predictions: ", ", ", ", ...\n"));
        Predef$.MODULE$.printf(this.residualPlotRCode((Frame)dlPredictTable, h2oContext.implicits().symbolToString(symbol$2), testTable, h2oContext.implicits().symbolToString(symbol$1), this.residualPlotRCode$default$5()), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.implicits().toH2OFrameKeyFromFrame(trainTable);
        gbmParams._response_column = h2oContext.implicits().symbolToString(symbol$1);
        gbmParams._valid = h2oContext.implicits().toH2OFrameKeyFromFrame(validTable);
        gbmParams._ntrees = 100;
        GBM gbm = new GBM(gbmParams);
        GBMModel gbmModel = (GBMModel)gbm.trainModel().get();
        H2OFrame gbmPredictTable = h2oContext.implicits().asH2OFrameFromFrame(gbmModel.score(testTable)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$2}));
        Predef$.MODULE$.printf(this.residualPlotRCode((Frame)gbmPredictTable, h2oContext.implicits().symbolToString(symbol$2), testTable, h2oContext.implicits().symbolToString(symbol$1), this.residualPlotRCode$default$5()), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        h2oContext.stop(true);
    }

    private AirlinesWithWeatherDemo2$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
        SparkSessionSupport.class.$init$((SparkSessionSupport)this);
    }
}

