/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.genmodel.MojoModel;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.CraigslistJobTitlesApp;
import org.apache.spark.examples.h2o.CraigslistJobTitlesApp$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import water.support.ModelSerializationSupport;
import water.support.SparkContextSupport;

public final class CraigslistJobTitlesStreamingOnlyApp$
implements SparkContextSupport,
ModelSerializationSupport {
    public static final CraigslistJobTitlesStreamingOnlyApp$ MODULE$;

    static {
        new CraigslistJobTitlesStreamingOnlyApp$();
    }

    public URI exportH2OModel(Model<?, ? extends Model.Parameters, ? extends Model.Output> model, URI destination, boolean force) {
        return ModelSerializationSupport.class.exportH2OModel((ModelSerializationSupport)this, model, (URI)destination, (boolean)force);
    }

    public String exportH2OModel(Model<?, ? extends Model.Parameters, ? extends Model.Output> model, String destination, boolean force) {
        return ModelSerializationSupport.class.exportH2OModel((ModelSerializationSupport)this, model, (String)destination, (boolean)force);
    }

    public <M extends Model<?, ? extends Model.Parameters, ? extends Model.Output>> M loadH2OModel(URI source) {
        return (M)ModelSerializationSupport.class.loadH2OModel((ModelSerializationSupport)this, (URI)source);
    }

    public <M extends Model<?, ? extends Model.Parameters, ? extends Model.Output>> M loadH2OModel(String source) {
        return (M)ModelSerializationSupport.class.loadH2OModel((ModelSerializationSupport)this, (String)source);
    }

    public URI exportPOJOModel(Model<?, ? extends Model.Parameters, ? extends Model.Output> model, URI destination, boolean force) {
        return ModelSerializationSupport.class.exportPOJOModel((ModelSerializationSupport)this, model, (URI)destination, (boolean)force);
    }

    public String exportPOJOModel(Model<?, ? extends Model.Parameters, ? extends Model.Output> model, String destination, boolean force) {
        return ModelSerializationSupport.class.exportPOJOModel((ModelSerializationSupport)this, model, (String)destination, (boolean)force);
    }

    public URI exportMOJOModel(Model<?, ? extends Model.Parameters, ? extends Model.Output> model, URI destination, boolean force) {
        return ModelSerializationSupport.class.exportMOJOModel((ModelSerializationSupport)this, model, (URI)destination, (boolean)force);
    }

    public String exportMOJOModel(Model<?, ? extends Model.Parameters, ? extends Model.Output> model, String destination, boolean force) {
        return ModelSerializationSupport.class.exportMOJOModel((ModelSerializationSupport)this, model, (String)destination, (boolean)force);
    }

    public MojoModel loadMOJOModel(URI source) {
        return ModelSerializationSupport.class.loadMOJOModel((ModelSerializationSupport)this, (URI)source);
    }

    public boolean exportH2OModel$default$3() {
        return ModelSerializationSupport.class.exportH2OModel$default$3((ModelSerializationSupport)this);
    }

    public boolean exportPOJOModel$default$3() {
        return ModelSerializationSupport.class.exportPOJOModel$default$3((ModelSerializationSupport)this);
    }

    public boolean exportMOJOModel$default$3() {
        return ModelSerializationSupport.class.exportMOJOModel$default$3((ModelSerializationSupport)this);
    }

    public SparkConf configure(String appName, String defaultMaster) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName, (String)defaultMaster);
    }

    public SparkContext sparkContext(SparkConf conf) {
        return SparkContextSupport.class.sparkContext((SparkContextSupport)this, (SparkConf)conf);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public void addFiles(SparkSession spark, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkSession)spark, files);
    }

    public String enforceLocalSparkFile(String file) {
        return SparkContextSupport.class.enforceLocalSparkFile((SparkContextSupport)this, (String)file);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String configure$default$2() {
        return SparkContextSupport.class.configure$default$2((SparkContextSupport)this);
    }

    public void main(String[] args) {
        SparkContext sc = new SparkContext(this.configure("CraigslistJobTitlesStreamingOnlyApp", this.configure$default$2()));
        StreamingContext ssc = new StreamingContext(sc, Seconds$.MODULE$.apply(10L));
        SQLContext sqlContext = SparkSession$.MODULE$.builder().getOrCreate().sqlContext();
        H2OContext h2oContext = H2OContext$.MODULE$.getOrCreate(sc);
        CraigslistJobTitlesApp staticApp = new CraigslistJobTitlesApp(CraigslistJobTitlesApp$.MODULE$.$lessinit$greater$default$1(), sc, sqlContext, h2oContext);
        try {
            try {
                Object h2oModel = this.loadH2OModel(URI.create("file:///tmp/h2omodel"));
                String modelId = ((Model)h2oModel)._key.toString();
                String[] classNames = ((Model)h2oModel)._output.classNames();
                Word2VecModel sparkModel = (Word2VecModel)this.loadSparkModel(URI.create("file:///tmp/sparkmodel"));
                ReceiverInputDStream jobTitlesStream = ssc.socketTextStream("localhost", 9999, ssc.socketTextStream$default$3());
                jobTitlesStream.filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        return !x$1.isEmpty();
                    }
                }).map((Function1)new Serializable(staticApp, modelId, sparkModel){
                    public static final long serialVersionUID = 0L;
                    private final CraigslistJobTitlesApp staticApp$1;
                    private final String modelId$1;
                    private final Word2VecModel sparkModel$1;

                    public final Tuple2<String, Tuple2<String, double[]>> apply(String jobTitle) {
                        return new Tuple2((Object)jobTitle, this.staticApp$1.classify(jobTitle, this.modelId$1, this.sparkModel$1));
                    }
                    {
                        this.staticApp$1 = staticApp$1;
                        this.modelId$1 = modelId$1;
                        this.sparkModel$1 = sparkModel$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(classNames){
                    public static final long serialVersionUID = 0L;
                    private final String[] classNames$1;

                    public final String apply(Tuple2<String, Tuple2<String, double[]>> pred) {
                        return new StringBuilder().append((Object)"\"").append(pred._1()).append((Object)"\" = ").append((Object)CraigslistJobTitlesApp$.MODULE$.show((Tuple2<String, double[]>)((Tuple2)pred._2()), this.classNames$1)).toString();
                    }
                    {
                        this.classNames$1 = classNames$1;
                    }
                }, ClassTag$.MODULE$.apply(String.class)).print();
                Predef$.MODULE$.println((Object)"Please start the event producer at port 9999, for example: nc -lk 9999");
                ssc.start();
                ssc.awaitTermination();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        finally {
            ssc.stop(ssc.stop$default$1());
            staticApp.shutdown();
        }
    }

    private CraigslistJobTitlesStreamingOnlyApp$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
        ModelSerializationSupport.class.$init$((ModelSerializationSupport)this);
    }
}

