/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.examples.CitiBikeSharingDemo$;
import ai.h2o.sparkling.examples.GTimer;
import ai.h2o.sparkling.examples.NYWeather;
import ai.h2o.sparkling.examples.NYWeatherParse$;
import ai.h2o.sparkling.examples.TimeSplit;
import ai.h2o.sparkling.examples.TimeTransform;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import water.Key;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.support.SparkContextSupport;

public final class CitiBikeSharingDemo$
implements SparkContextSupport {
    public static final CitiBikeSharingDemo$ MODULE$;
    private final String DIR_PREFIX;
    private final int TREES;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;

    static {
        symbol$1 = Symbol$.MODULE$.apply("starttime");
        symbol$2 = Symbol$.MODULE$.apply("Days");
        symbol$3 = Symbol$.MODULE$.apply("bikes");
        new CitiBikeSharingDemo$();
    }

    public SparkConf configure(String appName, String defaultMaster) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName, (String)defaultMaster);
    }

    public SparkContext sparkContext(SparkConf conf) {
        return SparkContextSupport.class.sparkContext((SparkContextSupport)this, (SparkConf)conf);
    }

    public boolean isFileDistributed(SparkContext sc, String filePath) {
        return SparkContextSupport.class.isFileDistributed((SparkContextSupport)this, (SparkContext)sc, (String)filePath);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public void addFiles(SparkSession spark, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkSession)spark, files);
    }

    public String enforceLocalSparkFile(String file) {
        return SparkContextSupport.class.enforceLocalSparkFile((SparkContextSupport)this, (String)file);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String configure$default$2() {
        return SparkContextSupport.class.configure$default$2((SparkContextSupport)this);
    }

    public String DIR_PREFIX() {
        return this.DIR_PREFIX;
    }

    public int TREES() {
        return this.TREES;
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water Meetup: Predict occupation of citi bike station in NYC", this.configure$default$2());
        SparkContext sc = new SparkContext(conf);
        H2OContext h2oContext = H2OContext$.MODULE$.getOrCreate();
        SQLContext sqlContext = SparkSession$.MODULE$.builder().getOrCreate().sqlContext();
        GTimer gTimer = new GTimer();
        gTimer.start();
        URI[] dataFiles = (URI[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"2013-07.csv", "2013-08.csv", "2013-09.csv", "2013-10.csv", "2013-11.csv", "2013-12.csv", "2014-01.csv", "2014-02.csv", "2014-03.csv", "2014-04.csv", "2014-05.csv", "2014-06.csv", "2014-07.csv", "2014-08.csv"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String f) {
                return new File(CitiBikeSharingDemo$.MODULE$.DIR_PREFIX(), f).toURI();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URI.class)));
        H2OFrame dataf = new H2OFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])dataFiles));
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])dataf.names()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.replace(' ', '_');
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        dataf._names = colNames;
        dataf.update();
        gTimer.stop("H2O: parse");
        gTimer.start();
        H2OFrame startTimeF = dataf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$1}));
        dataf.add((Frame)new TimeSplit().doIt(startTimeF));
        dataf.update();
        Predef$.MODULE$.println((Object)dataf);
        gTimer.stop("H2O: split start time column");
        Dataset brdd = h2oContext.asDataFrame((Frame)dataf, h2oContext.asDataFrame$default$2());
        brdd.createOrReplaceTempView("brdd");
        Dataset bph = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT Days, start_station_id, count(*) bikes\n        |FROM brdd\n        |GROUP BY Days, start_station_id ")).stripMargin());
        Predef$.MODULE$.println((Object)Predef$.MODULE$.refArrayOps((Object[])bph.take(10)).mkString("\n"));
        gTimer.start();
        H2OFrame bphf = h2oContext.implicits().asH2OFrameFromDataFrame(bph);
        gTimer.stop("Spark: do SQL query").start();
        H2OFrame daysVec = bphf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$2}));
        Frame finalTable = bphf.add((Frame)new TimeTransform().doIt(daysVec));
        gTimer.stop("H2O: time transformation");
        Predef$.MODULE$.println((Object)finalTable);
        this.buildModel(h2oContext.implicits().asH2OFrameFromFrame(finalTable), gTimer, h2oContext);
        RDD weatherData = sc.textFile(new StringBuilder().append((Object)this.DIR_PREFIX()).append((Object)"31081_New_York_City__Hourly_2013.csv").toString(), sc.textFile$default$2());
        RDD weatherRdd = weatherData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final NYWeather apply(String[] row) {
                return NYWeatherParse$.MODULE$.apply(row);
            }
        }, ClassTag$.MODULE$.apply(NYWeather.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(NYWeather x$2) {
                return !x$2.isWrongRow();
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(NYWeather x$3) {
                Option<Object> option = x$3.HourLocal();
                Some some = new Some((Object)BoxesRunTime.boxToInteger((int)12));
                return !(option != null ? !option.equals((Object)some) : some != null);
            }
        });
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_CitiBikeSharingDemo$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.h2o.sparkling.examples.NYWeather").asType().toTypeConstructor();
            }

            public Ai_h2o_sparkling_examples_CitiBikeSharingDemo$$typecreator5$1() {
            }
        }
        sqlContext.implicits().rddToDatasetHolder(weatherRdd, sqlContext.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_CitiBikeSharingDemo$$typecreator5$1()))).toDF().createOrReplaceTempView("weatherRdd");
        h2oContext.asDataFrame(finalTable, h2oContext.asDataFrame$default$2()).createOrReplaceTempView("bikesRdd");
        Dataset bikesWeatherRdd = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT b.Days, b.start_station_id, b.bikes, b.Month, b.DayOfWeek,\n        |w.DewPoint, w.HumidityFraction, w.Prcp1Hour, w.Temperature, w.WeatherCode1\n        | FROM bikesRdd b\n        | JOIN weatherRdd w\n        | ON b.Days = w.Days\n        |\n      ")).stripMargin());
        this.buildModel(h2oContext.implicits().asH2OFrameFromDataFrame(bikesWeatherRdd), gTimer, h2oContext);
        Predef$.MODULE$.println((Object)gTimer);
        sc.stop();
    }

    public double r2(GBMModel model, Frame fr) {
        return ((ModelMetricsSupervised)ModelMetrics.getFromDKV((Model)model, (Frame)fr)).r2();
    }

    public GBMModel buildModel(H2OFrame df, GTimer gTimer, H2OContext h2oContext) {
        gTimer.start();
        Key[] keys = (Key[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"train.hex", "test.hex", "hold.hex"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Key<Frame> apply(String x$4) {
                return Key.make((String)x$4);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Key.class)));
        double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.6, 0.3, 0.1}), ClassTag$.MODULE$.Double());
        Frame[] frs = ShuffleSplitFrame.shuffleSplitFrame((Frame)df, (Key[])keys, (double[])ratios, (long)1234567689L);
        Frame train = frs[0];
        Frame test = frs[1];
        Frame hold = frs[2];
        gTimer.stop("H2O: split frame");
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.implicits().toH2OFrameKeyFromFrame(train);
        gbmParams._valid = h2oContext.implicits().toH2OFrameKeyFromFrame(test);
        gbmParams._response_column = h2oContext.implicits().symbolToString(symbol$3);
        gbmParams._ntrees = this.TREES();
        gbmParams._max_depth = 6;
        gTimer.start();
        GBM gbm = new GBM(gbmParams);
        GBMModel gbmModel = (GBMModel)gbm.trainModel().get();
        gTimer.stop("H2O: gbm model training");
        gbmModel.score(train).remove();
        gbmModel.score(test).remove();
        gbmModel.score(hold).remove();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |r2 on train: ", "\n         |r2 on test:  ", "\n         |r2 on hold:  ", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.r2(gbmModel, train)), BoxesRunTime.boxToDouble((double)this.r2(gbmModel, test)), BoxesRunTime.boxToDouble((double)this.r2(gbmModel, hold))})))).stripMargin());
        train.delete();
        test.delete();
        hold.delete();
        return gbmModel;
    }

    public void basicStats(Dataset<Row> brdd, SQLContext sqlContext) {
        brdd.first();
        brdd.count();
        brdd.createOrReplaceTempView("brdd");
        Dataset tGBduration = sqlContext.sql("SELECT bikeid, SUM(tripduration) FROM brdd GROUP BY bikeid");
        Row[] bottom10 = (Row[])tGBduration.rdd().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row r) {
                return r.getLong(1);
            }
        }, tGBduration.rdd().sortBy$default$2(), tGBduration.rdd().sortBy$default$3(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long()).take(10);
        Row minDurationBikeId = (Row)tGBduration.rdd().min(package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row r) {
                return r.getLong(1);
            }
        }, (Ordering)Ordering.Long$.MODULE$));
        Row row = bottom10[0];
        Row row2 = minDurationBikeId;
        Predef$.MODULE$.assert(!(row != null ? !row.equals(row2) : row2 != null));
        Row maxDurationBikeId = (Row)tGBduration.rdd().min(package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row r) {
                return -r.getLong(1);
            }
        }, (Ordering)Ordering.Long$.MODULE$));
    }

    public void withTimer(GTimer timer, String round, Function0<BoxedUnit> b) {
        timer.start();
        try {
            b.apply$mcV$sp();
            return;
        }
        finally {
            timer.stop(round);
        }
    }

    private CitiBikeSharingDemo$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
        this.DIR_PREFIX = "/Users/michal/Devel/projects/h2o/repos/h2o2/bigdata/laptop/citibike-nyc/";
        this.TREES = 1;
    }
}

