/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.examples.ChicagoCrimeApp;
import ai.h2o.sparkling.examples.ChicagoCrimeApp$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.algos.H2OGBM;
import ai.h2o.sparkling.ml.models.H2OMOJOModel;
import ai.h2o.sparkling.ml.params.H2OAlgoSharedTreeParams;
import ai.h2o.sparkling.ml.params.H2OCommonSupervisedParams;
import ai.h2o.sparkling.ml.params.H2ODeepLearningParams;
import java.io.File;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class ChicagoCrimeApp$ {
    public static final ChicagoCrimeApp$ MODULE$;
    private final UserDefinedFunction seasonUdf;
    private final UserDefinedFunction weekendUdf;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;
    private static Symbol symbol$6;

    static {
        symbol$1 = Symbol$.MODULE$.apply("Domestic");
        symbol$2 = Symbol$.MODULE$.apply("Community_Area");
        symbol$3 = Symbol$.MODULE$.apply("Community_Area_Number");
        symbol$4 = Symbol$.MODULE$.apply("Date");
        symbol$5 = Symbol$.MODULE$.apply("Month");
        symbol$6 = Symbol$.MODULE$.apply("WeekDay");
        new ChicagoCrimeApp$();
    }

    private UserDefinedFunction seasonUdf() {
        return this.seasonUdf;
    }

    private UserDefinedFunction weekendUdf() {
        return this.weekendUdf;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Chicago Crime App").getOrCreate();
        String weatherDataPath = "./examples/smalldata/chicago/chicagoAllWeather.csv";
        String weatherDataFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(weatherDataPath).getAbsolutePath()}));
        Dataset<Row> weatherTable = this.createWeatherTable(spark, weatherDataFile);
        weatherTable.createOrReplaceTempView("chicagoWeather");
        String censusDataPath = "./examples/smalldata/chicago/chicagoCensus.csv";
        String censusDataFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(censusDataPath).getAbsolutePath()}));
        Dataset<Row> censusTable = this.createCensusTable(spark, censusDataFile);
        censusTable.createOrReplaceTempView("chicagoCensus");
        String crimesDataPath = "./examples/smalldata/chicago/chicagoCrimes10k.csv";
        String crimesDataFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(crimesDataPath).getAbsolutePath()}));
        Dataset<Row> crimesTable = this.createCrimeTable(spark, crimesDataFile);
        crimesTable.createOrReplaceTempView("chicagoCrime");
        Dataset crimeWeather = spark.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |a.Year, a.Month, a.Day, a.WeekNum, a.HourOfDay, a.Weekend, a.Season, a.WeekDay,\n        |a.IUCR, a.Primary_Type, a.Location_Description, a.Community_Area, a.District,\n        |a.Arrest, a.Domestic, a.Beat, a.Ward, a.FBI_Code,\n        |b.minTemp, b.maxTemp, b.meanTemp,\n        |c.PERCENT_AGED_UNDER_18_OR_OVER_64, c.PER_CAPITA_INCOME, c.HARDSHIP_INDEX,\n        |c.PERCENT_OF_HOUSING_CROWDED, c.PERCENT_HOUSEHOLDS_BELOW_POVERTY,\n        |c.PERCENT_AGED_16__UNEMPLOYED, c.PERCENT_AGED_25__WITHOUT_HIGH_SCHOOL_DIPLOMA\n        |FROM chicagoCrime a\n        |JOIN chicagoWeather b\n        |ON a.Year = b.year AND a.Month = b.month AND a.Day = b.day\n        |JOIN chicagoCensus c\n        |ON a.Community_Area = c.Community_Area_Number")).stripMargin());
        H2OMOJOModel gbmModel = this.trainGBM((Dataset<Row>)crimeWeather);
        H2OMOJOModel dlModel = this.trainDeepLearning((Dataset<Row>)crimeWeather);
        Seq crimes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChicagoCrimeApp.Crime[]{new ChicagoCrimeApp.Crime("02/08/2015 11:43:58 PM", 1811, "NARCOTICS", "STREET", false, 422, 4, 7, 46, 18), new ChicagoCrimeApp.Crime("02/08/2015 11:00:39 PM", 1150, "DECEPTIVE PRACTICE", "RESIDENCE", false, 923, 9, 14, 63, 11)}));
        this.score(spark, (Seq<ChicagoCrimeApp.Crime>)crimes, gbmModel, dlModel, censusTable);
    }

    public H2OMOJOModel trainGBM(Dataset<Row> train) {
        H2OContext$.MODULE$.getOrCreate();
        H2OGBM gbm = (H2OGBM)((H2OAlgoSharedTreeParams)((H2OCommonSupervisedParams)new H2OGBM().setSplitRatio(0.8)).setLabelCol("Arrest").setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setNtrees(10).setMaxDepth(6).setDistribution("bernoulli");
        return gbm.fit(train);
    }

    public H2OMOJOModel trainDeepLearning(Dataset<Row> train) {
        H2OContext$.MODULE$.getOrCreate();
        H2ODeepLearning dl = (H2ODeepLearning)((H2ODeepLearningParams)((H2OCommonSupervisedParams)new H2ODeepLearning().setSplitRatio(0.8)).setLabelCol("Arrest").setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setEpochs(10.0).setL1(1.0E-4).setL2(1.0E-4).setActivation("RectifierWithDropout").setHidden(new int[]{200, 200});
        return dl.fit(train);
    }

    public void score(SparkSession spark, Seq<ChicagoCrimeApp.Crime> crimes, H2OMOJOModel gbmModel, H2OMOJOModel dlModel, Dataset<Row> censusTable) {
        crimes.foreach((Function1)new Serializable(spark, gbmModel, dlModel, censusTable){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final H2OMOJOModel gbmModel$1;
            private final H2OMOJOModel dlModel$1;
            private final Dataset censusTable$1;

            public final void apply(ChicagoCrimeApp.Crime crime) {
                boolean arrestGBM = ChicagoCrimeApp$.MODULE$.scoreEvent(this.spark$1, crime, this.gbmModel$1, (Dataset<Row>)this.censusTable$1);
                boolean arrestDL = ChicagoCrimeApp$.MODULE$.scoreEvent(this.spark$1, crime, this.dlModel$1, (Dataset<Row>)this.censusTable$1);
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Crime: ", "\n           |  Will be arrested based on DeepLearning: ", "\n           |  Will be arrested based on GBM: ", "\n           |\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{crime, BoxesRunTime.boxToBoolean((boolean)arrestDL), BoxesRunTime.boxToBoolean((boolean)arrestGBM)})))).stripMargin());
            }
            {
                this.spark$1 = spark$1;
                this.gbmModel$1 = gbmModel$1;
                this.dlModel$1 = dlModel$1;
                this.censusTable$1 = censusTable$1;
            }
        });
    }

    public boolean scoreEvent(SparkSession spark, ChicagoCrimeApp.Crime crime, H2OMOJOModel model, Dataset<Row> censusTable) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.h2o.sparkling.examples.ChicagoCrimeApp.Crime").asType().toTypeConstructor();
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator4$1() {
            }
        }
        Dataset df = this.addAdditionalDateColumns(spark, (Dataset<Row>)spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChicagoCrimeApp.Crime[]{crime})), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(ChicagoCrimeApp.Crime.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator4$1()))).toDF()).withColumn("Domestic", spark.implicits().symbolToColumn(symbol$1).cast((DataType)DoubleType$.MODULE$));
        Dataset row = censusTable.join(df).where(spark.implicits().symbolToColumn(symbol$2).$eq$eq$eq((Object)symbol$3));
        Dataset predictTable = model.transform(row);
        String string = ((Row)predictTable.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String string2 = "1";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Dataset<Row> createWeatherTable(SparkSession spark, String datafile) {
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        return df.drop(df.columns()[0]);
    }

    public Dataset<Row> createCensusTable(SparkSession spark, String datafile) {
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        Column[] renamedColumns = (Column[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Column apply(String col) {
                String name = col.trim().replace(' ', '_').replace('+', '_');
                return this.df$1.apply(col).as(name);
            }
            {
                this.df$1 = df$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns));
    }

    public Dataset<Row> createCrimeTable(SparkSession spark, String datafile) {
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        Column[] renamedColumns = (Column[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$2;

            public final Column apply(String col) {
                String name = col.trim().replace(' ', '_').replace('+', '_');
                return this.df$2.apply(col).as(name);
            }
            {
                this.df$2 = df$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return this.addAdditionalDateColumns(spark, (Dataset<Row>)df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns)));
    }

    public Dataset<Row> addAdditionalDateColumns(SparkSession spark, Dataset<Row> df) {
        return df.withColumn("Date", functions$.MODULE$.from_unixtime(functions$.MODULE$.unix_timestamp((Column)spark.implicits().symbolToColumn(symbol$4), "MM/dd/yyyy hh:mm:ss a"))).withColumn("Year", functions$.MODULE$.year((Column)spark.implicits().symbolToColumn(symbol$4))).withColumn("Month", functions$.MODULE$.month((Column)spark.implicits().symbolToColumn(symbol$4))).withColumn("Day", functions$.MODULE$.dayofmonth((Column)spark.implicits().symbolToColumn(symbol$4))).withColumn("WeekNum", functions$.MODULE$.weekofyear((Column)spark.implicits().symbolToColumn(symbol$4))).withColumn("HourOfDay", functions$.MODULE$.hour((Column)spark.implicits().symbolToColumn(symbol$4))).withColumn("Season", this.seasonUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$5)}))).withColumn("WeekDay", functions$.MODULE$.date_format((Column)spark.implicits().symbolToColumn(symbol$4), "u")).withColumn("Weekend", this.weekendUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$6)}))).drop((Column)spark.implicits().symbolToColumn(symbol$4));
    }

    public String ai$h2o$sparkling$examples$ChicagoCrimeApp$$getSeason(int month) {
        int seasonNum = month >= 3 && month <= 5 ? 0 : (month >= 6 && month <= 8 ? 1 : (month >= 9 && month <= 10 ? 2 : 3));
        return this.SEASONS()[seasonNum];
    }

    private String[] SEASONS() {
        return (String[])((Object[])new String[]{"Spring", "Summer", "Autumn", "Winter"});
    }

    public int ai$h2o$sparkling$examples$ChicagoCrimeApp$$isWeekend(int dayOfWeek) {
        return dayOfWeek == 7 || dayOfWeek == 6 ? 1 : 0;
    }

    private ChicagoCrimeApp$() {
        MODULE$ = this;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1() {
            }
        }
        this.seasonUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int month) {
                return ChicagoCrimeApp$.MODULE$.ai$h2o$sparkling$examples$ChicagoCrimeApp$$getSeason(month);
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        this.weekendUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int dayOfWeek) {
                return this.apply$mcII$sp(dayOfWeek);
            }

            public int apply$mcII$sp(int dayOfWeek) {
                return ChicagoCrimeApp$.MODULE$.ai$h2o$sparkling$examples$ChicagoCrimeApp$$isWeekend(dayOfWeek);
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
    }
}

