/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.examples.CityBikeSharingDemo$;
import ai.h2o.sparkling.ml.algos.H2OGBM;
import ai.h2o.sparkling.ml.models.H2OMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import java.io.File;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class CityBikeSharingDemo$ {
    public static final CityBikeSharingDemo$ MODULE$;
    private final UserDefinedFunction daysToTimestampUdf;
    private final UserDefinedFunction numberOfDaysSinceEpochUdf;
    private final UserDefinedFunction dayOfWeekUdf;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;
    private static Symbol symbol$6;
    private static Symbol symbol$7;
    private static Symbol symbol$8;

    static {
        symbol$1 = Symbol$.MODULE$.apply("starttime");
        symbol$2 = Symbol$.MODULE$.apply("Days");
        symbol$3 = Symbol$.MODULE$.apply("date");
        symbol$4 = Symbol$.MODULE$.apply("HourLocal");
        symbol$5 = Symbol$.MODULE$.apply("DayLocal");
        symbol$6 = Symbol$.MODULE$.apply("MonthLocal");
        symbol$7 = Symbol$.MODULE$.apply("YearLocal");
        symbol$8 = Symbol$.MODULE$.apply("Date");
        new CityBikeSharingDemo$();
    }

    public UserDefinedFunction daysToTimestampUdf() {
        return this.daysToTimestampUdf;
    }

    public UserDefinedFunction numberOfDaysSinceEpochUdf() {
        return this.numberOfDaysSinceEpochUdf;
    }

    private UserDefinedFunction dayOfWeekUdf() {
        return this.dayOfWeekUdf;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("City Bike Sharing Demo").getOrCreate();
        Dataset<Row> bikesPerDayTable = this.loadBikesData(spark);
        H2OMOJOModel bikesPerDayModel = this.buildModel(bikesPerDayTable);
        this.printPredictions(bikesPerDayModel, bikesPerDayTable);
        Dataset<Row> bikesWeatherTable = this.loadBikesWeatherData(spark, bikesPerDayTable);
        H2OMOJOModel bikesWeatherModel = this.buildModel(bikesWeatherTable);
        this.printPredictions(bikesWeatherModel, bikesWeatherTable);
    }

    public Dataset<Row> loadBikesData(SparkSession spark) {
        String bikesDataPath = "./examples/smalldata/citybike-nyc/citybike_2013.csv";
        String bikesDataFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(bikesDataPath).getAbsolutePath()}));
        Dataset bikesTable = spark.read().option("header", "true").option("inferSchema", "true").csv(bikesDataFile);
        return this.removeSpacesFromColumnNames((Dataset<Row>)bikesTable).withColumn("Days", this.numberOfDaysSinceEpochUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.unix_timestamp((Column)spark.implicits().symbolToColumn(symbol$1))}))).groupBy("Days", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start_station_id"})).count().withColumnRenamed("count", "bikes").withColumn("date", functions$.MODULE$.from_unixtime(this.daysToTimestampUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$2)})))).withColumn("Month", functions$.MODULE$.month((Column)spark.implicits().symbolToColumn(symbol$3))).withColumn("DayOfweek", this.dayOfWeekUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_format((Column)spark.implicits().symbolToColumn(symbol$3), "E")}))).drop((Column)spark.implicits().symbolToColumn(symbol$3));
    }

    public Dataset<Row> removeSpacesFromColumnNames(Dataset<Row> input) {
        Column[] renamedColumns = (Column[])Predef$.MODULE$.refArrayOps((Object[])input.columns()).map((Function1)new Serializable(input){
            public static final long serialVersionUID = 0L;
            private final Dataset input$1;

            public final Column apply(String col) {
                String name = col.trim().replaceAll("\\s", "_");
                return this.input$1.apply(col).as(name);
            }
            {
                this.input$1 = input$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return input.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns));
    }

    public Dataset<Row> loadBikesWeatherData(SparkSession spark, Dataset<Row> bikesPerDay) {
        String weatherDataPath = "./examples/smalldata/citybike-nyc/New_York_City_Hourly_Weather_2013.csv";
        String weatherDataFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(weatherDataPath).getAbsolutePath()}));
        Dataset weatherTable = spark.read().option("header", "true").option("inferSchema", "true").csv(weatherDataFile).select("Hour Local", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Year Local", "Month Local", "Day Local", "Dew Point (C)", "Humidity Fraction", "Precipitation One Hour (mm)", "Weather Code 1", "Temperature (C)"})).withColumnRenamed("Hour Local", "HourLocal").withColumnRenamed("Year Local", "YearLocal").withColumnRenamed("Day Local", "DayLocal").withColumnRenamed("Month Local", "MonthLocal").withColumnRenamed("Dew Point (C)", "DewPoint").withColumnRenamed("Humidity Fraction", "HumidityFraction").withColumnRenamed("Precipitation One Hour (mm)", "Prcp1Hour").withColumnRenamed("Weather Code 1", "WeatherCode1").withColumnRenamed("Temperature (C)", "Temperature").withColumn("HourLocal", functions$.MODULE$.format_string("%02d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$4).cast((DataType)IntegerType$.MODULE$)}))).withColumn("DayLocal", functions$.MODULE$.format_string("%02d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$5).cast((DataType)IntegerType$.MODULE$)}))).withColumn("MonthLocal", functions$.MODULE$.format_string("%02d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$6).cast((DataType)IntegerType$.MODULE$)}))).withColumn("YearLocal", functions$.MODULE$.format_string("%04d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$7).cast((DataType)IntegerType$.MODULE$)}))).filter(spark.implicits().symbolToColumn(symbol$4).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)12))).withColumn("Date", functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$7), spark.implicits().symbolToColumn(symbol$6), spark.implicits().symbolToColumn(symbol$5), spark.implicits().symbolToColumn(symbol$4)}))).withColumn("Days", this.numberOfDaysSinceEpochUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.unix_timestamp((Column)spark.implicits().symbolToColumn(symbol$8), "yyyyMMddHH")})));
        return bikesPerDay.join(weatherTable, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Days"})));
    }

    public H2OMOJOModel buildModel(Dataset<Row> train) {
        H2OContext$.MODULE$.getOrCreate();
        H2OGBM gbm = (H2OGBM)((H2OCommonParams)new H2OGBM().setNtrees(100).setMaxDepth(6).setLabelCol("bikes")).setSplitRatio(0.8);
        return gbm.fit(train);
    }

    public void printPredictions(H2OMOJOModel model, Dataset<Row> input) {
        Row[] predictions = (Row[])model.transform(input).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        Predef$.MODULE$.println((Object)Predef$.MODULE$.refArrayOps((Object[])predictions).mkString("\n===> Model predictions from GBM: ", ", ", ", ...\n"));
    }

    public int ai$h2o$sparkling$examples$CityBikeSharingDemo$$dayOfWeek(String day) {
        block9: {
            int n;
            block3: {
                String string;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        string = day;
                                        if (!"Mon".equals(string)) break block2;
                                        n = 1;
                                        break block3;
                                    }
                                    if (!"Tue".equals(string)) break block4;
                                    n = 2;
                                    break block3;
                                }
                                if (!"Wed".equals(string)) break block5;
                                n = 3;
                                break block3;
                            }
                            if (!"Thu".equals(string)) break block6;
                            n = 4;
                            break block3;
                        }
                        if (!"Fri".equals(string)) break block7;
                        n = 5;
                        break block3;
                    }
                    if (!"Sat".equals(string)) break block8;
                    n = 6;
                    break block3;
                }
                if (!"Sun".equals(string)) break block9;
                n = 7;
            }
            return n;
        }
        throw new RuntimeException("Invalid day!");
    }

    public String daysToTimestamp(int days) {
        return ((Object)BoxesRunTime.boxToInteger((int)(days * 86400))).toString();
    }

    public long numberOfDaysSinceEpoch(long timestamp) {
        return timestamp / 86400L;
    }

    private CityBikeSharingDemo$() {
        MODULE$ = this;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_CityBikeSharingDemo$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_CityBikeSharingDemo$$typecreator2$1() {
            }
        }
        this.daysToTimestampUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int days) {
                return CityBikeSharingDemo$.MODULE$.daysToTimestamp(days);
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_CityBikeSharingDemo$$typecreator2$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        this.numberOfDaysSinceEpochUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long timestamp) {
                return this.apply$mcJJ$sp(timestamp);
            }

            public long apply$mcJJ$sp(long timestamp) {
                return CityBikeSharingDemo$.MODULE$.numberOfDaysSinceEpoch(timestamp);
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_CityBikeSharingDemo$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_CityBikeSharingDemo$$typecreator1$1() {
            }
        }
        this.dayOfWeekUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String day) {
                return CityBikeSharingDemo$.MODULE$.ai$h2o$sparkling$examples$CityBikeSharingDemo$$dayOfWeek(day);
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_h2o_sparkling_examples_CityBikeSharingDemo$$typecreator1$1()));
    }
}

