/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.examples.ChicagoCrimeApp;
import ai.h2o.sparkling.examples.ChicagoCrimeApp$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.algos.H2OGBM;
import ai.h2o.sparkling.ml.models.H2OMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import ai.h2o.sparkling.ml.params.H2ODeepLearningParams;
import ai.h2o.sparkling.ml.params.H2OGBMParams;
import java.io.File;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class ChicagoCrimeApp$ {
    public static final ChicagoCrimeApp$ MODULE$;
    private final UserDefinedFunction seasonUdf;
    private final UserDefinedFunction weekendUdf;
    private final UserDefinedFunction dayOfWeekUdf;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;

    static {
        symbol$1 = Symbol$.MODULE$.apply("Date");
        symbol$2 = Symbol$.MODULE$.apply("DateTmp");
        symbol$3 = Symbol$.MODULE$.apply("Month");
        symbol$4 = Symbol$.MODULE$.apply("WeekDay");
        new ChicagoCrimeApp$();
    }

    private UserDefinedFunction seasonUdf() {
        return this.seasonUdf;
    }

    private UserDefinedFunction weekendUdf() {
        return this.weekendUdf;
    }

    private UserDefinedFunction dayOfWeekUdf() {
        return this.dayOfWeekUdf;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Chicago Crime App").getOrCreate();
        Dataset weatherTable = this.loadCsv("./examples/smalldata/chicago/chicagoAllWeather.csv", spark).drop("date");
        String chicagoWeatherTableName = "chicagoWeather";
        weatherTable.createOrReplaceTempView(chicagoWeatherTableName);
        Dataset<Row> censusTable = this.loadCsv("./examples/smalldata/chicago/chicagoCensus.csv", spark);
        String chicagoCensusTableName = "chicagoCensus";
        censusTable.createOrReplaceTempView(chicagoCensusTableName);
        Dataset<Row> crimesTable = this.addAdditionalDateColumns(this.loadCsv("./examples/smalldata/chicago/chicagoCrimes10k.csv", spark), spark);
        String chicagoCrimeTableName = "chicagoCrime";
        crimesTable.createOrReplaceTempView(chicagoCrimeTableName);
        Seq crimeDataColumnsForTraining = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnName[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Year"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Month"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Day"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WeekNum"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HourOfDay"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weekend"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Season"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WeekDay"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IUCR"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Primary_Type"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Location_Description"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Community_Area"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"District"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Arrest"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Domestic"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beat"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ward"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FBI_Code"}))).$((Seq)Nil$.MODULE$)}));
        Seq censusDataColumnsForTraining = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnName[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_AGED_UNDER_18_OR_OVER_64"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PER_CAPITA_INCOME"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HARDSHIP_INDEX"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_OF_HOUSING_CROWDED"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_HOUSEHOLDS_BELOW_POVERTY"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_AGED_16_UNEMPLOYED"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_AGED_25_WITHOUT_HIGH_SCHOOL_DIPLOMA"}))).$((Seq)Nil$.MODULE$)}));
        Seq weatherDataColumnsForTraining = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnName[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minTemp"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxTemp"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"meanTemp"}))).$((Seq)Nil$.MODULE$)}));
        Dataset joinedDataForTraining = spark.table(chicagoCrimeTableName).as("cr").join(spark.table(chicagoWeatherTableName).as("we"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Year"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we.year"}))).$((Seq)Nil$.MODULE$)).and(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Month"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we.month"}))).$((Seq)Nil$.MODULE$))).and(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Day"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we.day"}))).$((Seq)Nil$.MODULE$)))).join(spark.table(chicagoCensusTableName).as("ce"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Community_Area"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ce.Community_Area_Number"}))).$((Seq)Nil$.MODULE$))).select((Seq)((TraversableLike)crimeDataColumnsForTraining.$plus$plus((GenTraversableOnce)censusDataColumnsForTraining, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)weatherDataColumnsForTraining, Seq$.MODULE$.canBuildFrom()));
        H2OContext$.MODULE$.getOrCreate();
        H2OMOJOModel gbmModel = this.trainGBM((Dataset<Row>)joinedDataForTraining);
        H2OMOJOModel dlModel = this.trainDeepLearning((Dataset<Row>)joinedDataForTraining);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.h2o.sparkling.examples.ChicagoCrimeApp.CrimeWithCensusData").asType().toTypeConstructor();
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator7$1() {
            }
        }
        Dataset crimesToScore = spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChicagoCrimeApp.CrimeWithCensusData[]{new ChicagoCrimeApp.CrimeWithCensusData("02/08/2015 11:43:58 PM", 1811, "NARCOTICS", "STREET", false, 422, 4, 7, 46, 18, 41.1, 16579, 75, 4.7, 29.8, 19.7, 26.6), new ChicagoCrimeApp.CrimeWithCensusData("02/08/2015 11:00:39 PM", 1150, "DECEPTIVE PRACTICE", "RESIDENCE", false, 923, 9, 14, 63, 11, 38.8, 12171, 93, 15.8, 23.4, 18.2, 51.5)})), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator7$1()))).toDF();
        this.score(this.addAdditionalDateColumns((Dataset<Row>)crimesToScore, spark), gbmModel, dlModel, spark);
    }

    private H2OMOJOModel trainGBM(Dataset<Row> train) {
        H2OGBM gbm = (H2OGBM)((H2OGBMParams)((H2OCommonParams)((H2OGBMParams)new H2OGBM().setSplitRatio(0.8)).setLabelCol("Arrest")).setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setNtrees(10).setMaxDepth(6).setDistribution("bernoulli");
        return gbm.fit(train);
    }

    private H2OMOJOModel trainDeepLearning(Dataset<Row> train) {
        H2ODeepLearning dl = (H2ODeepLearning)((H2ODeepLearningParams)((H2OCommonParams)((H2ODeepLearningParams)new H2ODeepLearning().setSplitRatio(0.8)).setLabelCol("Arrest")).setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setEpochs(10.0).setL1(1.0E-4).setL2(1.0E-4).setActivation("RectifierWithDropout").setHidden(new int[]{200, 200});
        return dl.fit(train);
    }

    private void score(Dataset<Row> crimes, H2OMOJOModel gbmModel, H2OMOJOModel dlModel, SparkSession spark) {
        Dataset arrestGBM = gbmModel.transform(crimes);
        Dataset arrestDL = dlModel.transform(crimes);
        Column willBeArrestedPrediction = spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"1");
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |  Will be arrested based on DeepLearning: ", "\n           |  Will be arrested based on GBM: ", "\n           |\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arrestDL.where(willBeArrestedPrediction).count()), BoxesRunTime.boxToLong((long)arrestGBM.where(willBeArrestedPrediction).count())})))).stripMargin());
    }

    private Dataset<Row> loadCsv(String dataPath, SparkSession spark) {
        String datafile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(dataPath).getAbsolutePath()}));
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        Column[] renamedColumns = (Column[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Column apply(String col) {
                String name = col.trim().replace(' ', '_').replace('+', '_').replace("__", "_");
                return this.df$1.apply(col).as(name);
            }
            {
                this.df$1 = df$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns));
    }

    private Dataset<Row> addAdditionalDateColumns(Dataset<Row> df, SparkSession spark) {
        return df.withColumn("DateTmp", functions$.MODULE$.from_unixtime(functions$.MODULE$.unix_timestamp((Column)spark.implicits().symbolToColumn(symbol$1), "MM/dd/yyyy hh:mm:ss a"))).withColumn("Year", functions$.MODULE$.year((Column)spark.implicits().symbolToColumn(symbol$2))).withColumn("Month", functions$.MODULE$.month((Column)spark.implicits().symbolToColumn(symbol$2))).withColumn("Day", functions$.MODULE$.dayofmonth((Column)spark.implicits().symbolToColumn(symbol$2))).withColumn("WeekNum", functions$.MODULE$.weekofyear((Column)spark.implicits().symbolToColumn(symbol$2))).withColumn("HourOfDay", functions$.MODULE$.hour((Column)spark.implicits().symbolToColumn(symbol$2))).withColumn("Season", this.seasonUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$3)}))).withColumn("WeekDay", this.dayOfWeekUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_format((Column)spark.implicits().symbolToColumn(symbol$2), "E")}))).withColumn("Weekend", this.weekendUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$4)}))).drop((Column)spark.implicits().symbolToColumn(symbol$2));
    }

    public String ai$h2o$sparkling$examples$ChicagoCrimeApp$$monthToSeason(int month) {
        return month >= 3 && month <= 5 ? "Spring" : (month >= 6 && month <= 8 ? "Summer" : (month >= 9 && month <= 10 ? "Autumn" : "Winter"));
    }

    public boolean ai$h2o$sparkling$examples$ChicagoCrimeApp$$isWeekend(int dayOfWeek) {
        return dayOfWeek == 7 || dayOfWeek == 6;
    }

    public int ai$h2o$sparkling$examples$ChicagoCrimeApp$$boolToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public int ai$h2o$sparkling$examples$ChicagoCrimeApp$$dayOfWeek(String day) {
        block9: {
            int n;
            block3: {
                String string;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        string = day;
                                        if (!"Mon".equals(string)) break block2;
                                        n = 1;
                                        break block3;
                                    }
                                    if (!"Tue".equals(string)) break block4;
                                    n = 2;
                                    break block3;
                                }
                                if (!"Wed".equals(string)) break block5;
                                n = 3;
                                break block3;
                            }
                            if (!"Thu".equals(string)) break block6;
                            n = 4;
                            break block3;
                        }
                        if (!"Fri".equals(string)) break block7;
                        n = 5;
                        break block3;
                    }
                    if (!"Sat".equals(string)) break block8;
                    n = 6;
                    break block3;
                }
                if (!"Sun".equals(string)) break block9;
                n = 7;
            }
            return n;
        }
        throw new RuntimeException("Invalid day!");
    }

    private ChicagoCrimeApp$() {
        MODULE$ = this;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1() {
            }
        }
        this.seasonUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int month) {
                return ChicagoCrimeApp$.MODULE$.ai$h2o$sparkling$examples$ChicagoCrimeApp$$monthToSeason(month);
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        this.weekendUdf = functions$.MODULE$.udf(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int dayOfWeek) {
                return this.apply$mcZI$sp(dayOfWeek);
            }

            public boolean apply$mcZI$sp(int dayOfWeek) {
                return ChicagoCrimeApp$.MODULE$.ai$h2o$sparkling$examples$ChicagoCrimeApp$$isWeekend(dayOfWeek);
            }
        }.andThen((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(boolean bool) {
                return ChicagoCrimeApp$.MODULE$.ai$h2o$sparkling$examples$ChicagoCrimeApp$$boolToInt(bool);
            }
        }), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1() {
            }
        }
        this.dayOfWeekUdf = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String day) {
                return ChicagoCrimeApp$.MODULE$.ai$h2o$sparkling$examples$ChicagoCrimeApp$$dayOfWeek(day);
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1()));
    }
}

