/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.examples.CraigslistJobTitlesApp$;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import scala.Predef$;
import scala.collection.Seq;

public final class CraigslistJobTitlesStructuredStreamingApp$ {
    public static final CraigslistJobTitlesStructuredStreamingApp$ MODULE$;

    static {
        new CraigslistJobTitlesStructuredStreamingApp$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Craigslist Job Titles Structured Streaming App").getOrCreate();
        Dataset<Row> titlesTable = CraigslistJobTitlesApp$.MODULE$.loadTitlesTable(spark);
        PipelineModel model = CraigslistJobTitlesApp$.MODULE$.fitModelPipeline(titlesTable);
        Dataset dataStream = spark.readStream().format("socket").option("host", "localhost").option("port", 9999L).load();
        Dataset jobTitlesStream = dataStream.as(spark.implicits().newStringEncoder()).withColumnRenamed("value", "jobtitle");
        Dataset prediction = model.transform(jobTitlesStream);
        Dataset categoryPrediction = prediction.select("jobtitle", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "detailed_prediction.probabilities.*"}));
        StreamingQuery query = categoryPrediction.writeStream().format("console").trigger(Trigger.ProcessingTime((String)"10 seconds")).start();
        query.awaitTermination();
    }

    private CraigslistJobTitlesStructuredStreamingApp$() {
        MODULE$ = this;
    }
}

