/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.models.H2ODeepLearningMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import java.io.File;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class DeepLearningDemo$ {
    public static final DeepLearningDemo$ MODULE$;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;
    private static Symbol symbol$6;
    private static Symbol symbol$7;
    private static Symbol symbol$8;
    private static Symbol symbol$9;
    private static Symbol symbol$10;
    private static Symbol symbol$11;
    private static Symbol symbol$12;
    private static Symbol symbol$13;
    private static Symbol symbol$14;

    static {
        symbol$1 = Symbol$.MODULE$.apply("Dest");
        symbol$2 = Symbol$.MODULE$.apply("Year");
        symbol$3 = Symbol$.MODULE$.apply("Month");
        symbol$4 = Symbol$.MODULE$.apply("DayofMonth");
        symbol$5 = Symbol$.MODULE$.apply("DayOfWeek");
        symbol$6 = Symbol$.MODULE$.apply("CRSDepTime");
        symbol$7 = Symbol$.MODULE$.apply("CRSArrTime");
        symbol$8 = Symbol$.MODULE$.apply("UniqueCarrier");
        symbol$9 = Symbol$.MODULE$.apply("FlightNum");
        symbol$10 = Symbol$.MODULE$.apply("TailNum");
        symbol$11 = Symbol$.MODULE$.apply("CRSElapsedTime");
        symbol$12 = Symbol$.MODULE$.apply("Origin");
        symbol$13 = Symbol$.MODULE$.apply("Distance");
        symbol$14 = Symbol$.MODULE$.apply("IsDepDelayed");
        new DeepLearningDemo$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Deep Learning Demo on Airlines Data").getOrCreate();
        String airlinesDataPath = "./examples/smalldata/airlines/allyears2k_headers.csv";
        String airlinesDataFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(airlinesDataPath).getAbsolutePath()}));
        Dataset airlinesTable = spark.read().option("header", "true").option("inferSchema", "true").option("nullValue", "NA").csv(airlinesDataFile);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of all flights: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)airlinesTable.count())})));
        Dataset airlinesSFO = airlinesTable.filter(spark.implicits().symbolToColumn(symbol$1).$eq$eq$eq((Object)"SFO"));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of flights with destination in SFO: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)airlinesSFO.count())})));
        Predef$.MODULE$.println((Object)"\n====> Running DeepLearning on the prepared data frame\n");
        Dataset train = airlinesSFO.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn(symbol$2), spark.implicits().symbolToColumn(symbol$3), spark.implicits().symbolToColumn(symbol$4), spark.implicits().symbolToColumn(symbol$5), spark.implicits().symbolToColumn(symbol$6), spark.implicits().symbolToColumn(symbol$7), spark.implicits().symbolToColumn(symbol$8), spark.implicits().symbolToColumn(symbol$9), spark.implicits().symbolToColumn(symbol$10), spark.implicits().symbolToColumn(symbol$11), spark.implicits().symbolToColumn(symbol$12), spark.implicits().symbolToColumn(symbol$1), spark.implicits().symbolToColumn(symbol$13), spark.implicits().symbolToColumn(symbol$14)}));
        H2OContext$.MODULE$.getOrCreate();
        H2ODeepLearning dl = (H2ODeepLearning)((H2OCommonParams)new H2ODeepLearning().setLabelCol("IsDepDelayed")).setConvertUnknownCategoricalLevelsToNa(true);
        long count = train.count();
        H2ODeepLearningMOJOModel model = dl.fit(train.repartition((int)count + 10));
        Row[] predictions = (Row[])model.transform(airlinesSFO).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        Predef$.MODULE$.println((Object)Predef$.MODULE$.refArrayOps((Object[])predictions).mkString("\n===> Model predictions from DL: ", ", ", ", ...\n"));
    }

    private DeepLearningDemo$() {
        MODULE$ = this;
    }
}

