/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.examples.ChicagoCrimeApp;
import ai.h2o.sparkling.examples.ChicagoCrimeApp$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.algos.H2OGBM;
import ai.h2o.sparkling.ml.models.H2OMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import ai.h2o.sparkling.ml.params.H2ODeepLearningParams;
import ai.h2o.sparkling.ml.params.H2OGBMParams;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

public final class ChicagoCrimeApp$ {
    public static ChicagoCrimeApp$ MODULE$;
    private final UserDefinedFunction seasonUdf;
    private final UserDefinedFunction weekendUdf;
    private final UserDefinedFunction dayOfWeekUdf;

    static {
        new ChicagoCrimeApp$();
    }

    private UserDefinedFunction seasonUdf() {
        return this.seasonUdf;
    }

    private UserDefinedFunction weekendUdf() {
        return this.weekendUdf;
    }

    private UserDefinedFunction dayOfWeekUdf() {
        return this.dayOfWeekUdf;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Chicago Crime App").getOrCreate();
        String weatherDataPath = "./examples/smalldata/chicago/chicagoAllWeather.csv";
        String weatherDataFile = new StringBuilder(7).append("file://").append(new File(weatherDataPath).getAbsolutePath()).toString();
        Dataset<Row> weatherTable = this.createWeatherTable(spark, weatherDataFile);
        weatherTable.createOrReplaceTempView("chicagoWeather");
        String censusDataPath = "./examples/smalldata/chicago/chicagoCensus.csv";
        String censusDataFile = new StringBuilder(7).append("file://").append(new File(censusDataPath).getAbsolutePath()).toString();
        Dataset<Row> censusTable = this.createCensusTable(spark, censusDataFile);
        censusTable.createOrReplaceTempView("chicagoCensus");
        String crimesDataPath = "./examples/smalldata/chicago/chicagoCrimes10k.csv";
        String crimesDataFile = new StringBuilder(7).append("file://").append(new File(crimesDataPath).getAbsolutePath()).toString();
        Dataset<Row> crimesTable = this.createCrimeTable(spark, crimesDataFile);
        crimesTable.createOrReplaceTempView("chicagoCrime");
        Dataset crimeWeather = spark.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |a.Year, a.Month, a.Day, a.WeekNum, a.HourOfDay, a.Weekend, a.Season, a.WeekDay,\n        |a.IUCR, a.Primary_Type, a.Location_Description, a.Community_Area, a.District,\n        |a.Arrest, a.Domestic, a.Beat, a.Ward, a.FBI_Code,\n        |b.minTemp, b.maxTemp, b.meanTemp,\n        |c.PERCENT_AGED_UNDER_18_OR_OVER_64, c.PER_CAPITA_INCOME, c.HARDSHIP_INDEX,\n        |c.PERCENT_OF_HOUSING_CROWDED, c.PERCENT_HOUSEHOLDS_BELOW_POVERTY,\n        |c.PERCENT_AGED_16__UNEMPLOYED, c.PERCENT_AGED_25__WITHOUT_HIGH_SCHOOL_DIPLOMA\n        |FROM chicagoCrime a\n        |JOIN chicagoWeather b\n        |ON a.Year = b.year AND a.Month = b.month AND a.Day = b.day\n        |JOIN chicagoCensus c\n        |ON a.Community_Area = c.Community_Area_Number")).stripMargin());
        H2OMOJOModel gbmModel = this.trainGBM((Dataset<Row>)crimeWeather);
        H2OMOJOModel dlModel = this.trainDeepLearning((Dataset<Row>)crimeWeather);
        Seq crimes = (Seq)new .colon.colon((Object)new ChicagoCrimeApp.Crime("02/08/2015 11:43:58 PM", 1811, "NARCOTICS", "STREET", false, 422, 4, 7, 46, 18), (List)new .colon.colon((Object)new ChicagoCrimeApp.Crime("02/08/2015 11:00:39 PM", 1150, "DECEPTIVE PRACTICE", "RESIDENCE", false, 923, 9, 14, 63, 11), (List)Nil$.MODULE$));
        this.score(spark, (Seq<ChicagoCrimeApp.Crime>)crimes, gbmModel, dlModel, censusTable);
    }

    public H2OMOJOModel trainGBM(Dataset<Row> train) {
        H2OContext$.MODULE$.getOrCreate();
        H2OGBM gbm = (H2OGBM)((H2OGBMParams)((H2OCommonParams)((H2OGBMParams)new H2OGBM().setSplitRatio(0.8)).setLabelCol("Arrest")).setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setNtrees(10).setMaxDepth(6).setDistribution("bernoulli");
        return gbm.fit(train);
    }

    public H2OMOJOModel trainDeepLearning(Dataset<Row> train) {
        H2OContext$.MODULE$.getOrCreate();
        H2ODeepLearning dl = (H2ODeepLearning)((H2ODeepLearningParams)((H2OCommonParams)((H2ODeepLearningParams)new H2ODeepLearning().setSplitRatio(0.8)).setLabelCol("Arrest")).setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setEpochs(10.0).setL1(1.0E-4).setL2(1.0E-4).setActivation("RectifierWithDropout").setHidden(new int[]{200, 200});
        return dl.fit(train);
    }

    public void score(SparkSession spark, Seq<ChicagoCrimeApp.Crime> crimes, H2OMOJOModel gbmModel, H2OMOJOModel dlModel, Dataset<Row> censusTable) {
        crimes.foreach((Function1 & Serializable & scala.Serializable)crime -> {
            ChicagoCrimeApp$.$anonfun$score$1(spark, gbmModel, censusTable, dlModel, crime);
            return BoxedUnit.UNIT;
        });
    }

    public boolean scoreEvent(SparkSession spark, ChicagoCrimeApp.Crime crime, H2OMOJOModel model, Dataset<Row> censusTable) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.h2o.sparkling.examples.ChicagoCrimeApp.Crime").asType().toTypeConstructor();
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator5$1() {
            }
        }
        Dataset<Row> df = this.addAdditionalDateColumns(spark, (Dataset<Row>)spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)new .colon.colon((Object)crime, (List)Nil$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(ChicagoCrimeApp.Crime.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator5$1()))).toDF());
        Dataset row = censusTable.join(df).where(spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Community_Area")).$eq$eq$eq((Object)SymbolLiteral.bootstrap("apply", "Community_Area_Number")));
        Dataset predictTable = model.transform(row);
        Object object = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictTable.collect())).head()).getAs("prediction");
        String string = "1";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public Dataset<Row> createWeatherTable(SparkSession spark, String datafile) {
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        return df.drop(df.columns()[0]);
    }

    public Dataset<Row> createCensusTable(SparkSession spark, String datafile) {
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        Column[] renamedColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)col -> {
            String name = col.trim().replace(' ', '_').replace('+', '_');
            return df.apply(col).as(name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns));
    }

    public Dataset<Row> createCrimeTable(SparkSession spark, String datafile) {
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        Column[] renamedColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)col -> {
            String name = col.trim().replace(' ', '_').replace('+', '_');
            return df.apply(col).as(name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return this.addAdditionalDateColumns(spark, (Dataset<Row>)df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns)));
    }

    public Dataset<Row> addAdditionalDateColumns(SparkSession spark, Dataset<Row> df) {
        return df.withColumn("DateTmp", functions$.MODULE$.from_unixtime(functions$.MODULE$.unix_timestamp((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Date")), "MM/dd/yyyy hh:mm:ss a"))).withColumn("Year", functions$.MODULE$.year((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("Month", functions$.MODULE$.month((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("Day", functions$.MODULE$.dayofmonth((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("WeekNum", functions$.MODULE$.weekofyear((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("HourOfDay", functions$.MODULE$.hour((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("Season", this.seasonUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Month"))}))).withColumn("WeekDay", this.dayOfWeekUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_format((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")), "E")}))).withColumn("Weekend", this.weekendUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "WeekDay"))}))).drop((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")));
    }

    private String getSeason(int month) {
        int seasonNum = month >= 3 && month <= 5 ? 0 : (month >= 6 && month <= 8 ? 1 : (month >= 9 && month <= 10 ? 2 : 3));
        return this.SEASONS()[seasonNum];
    }

    private String[] SEASONS() {
        return (String[])((Object[])new String[]{"Spring", "Summer", "Autumn", "Winter"});
    }

    private int isWeekend(int dayOfWeek) {
        return dayOfWeek == 7 || dayOfWeek == 6 ? 1 : 0;
    }

    private int dayOfWeek(String day) {
        int n;
        String string = day;
        if ("Mon".equals(string)) {
            n = 1;
        } else if ("Tue".equals(string)) {
            n = 2;
        } else if ("Wed".equals(string)) {
            n = 3;
        } else if ("Thu".equals(string)) {
            n = 4;
        } else if ("Fri".equals(string)) {
            n = 5;
        } else if ("Sat".equals(string)) {
            n = 6;
        } else if ("Sun".equals(string)) {
            n = 7;
        } else {
            throw new RuntimeException("Invalid day!");
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$score$1(SparkSession spark$1, H2OMOJOModel gbmModel$1, Dataset censusTable$1, H2OMOJOModel dlModel$1, ChicagoCrimeApp.Crime crime) {
        boolean arrestGBM = MODULE$.scoreEvent(spark$1, crime, gbmModel$1, (Dataset<Row>)censusTable$1);
        boolean arrestDL = MODULE$.scoreEvent(spark$1, crime, dlModel$1, (Dataset<Row>)censusTable$1);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n           |Crime: ").append(crime).append("\n           |  Will be arrested based on DeepLearning: ").append(arrestDL).append("\n           |  Will be arrested based on GBM: ").append(arrestGBM).append("\n           |\n        ").toString())).stripMargin());
    }

    private ChicagoCrimeApp$() {
        MODULE$ = this;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1() {
            }
        }
        this.seasonUdf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)month -> ChicagoCrimeApp$.MODULE$.getSeason(BoxesRunTime.unboxToInt((Object)month)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        this.weekendUdf = functions$.MODULE$.udf((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)dayOfWeek -> MODULE$.isWeekend(dayOfWeek), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1() {
            }
        }
        this.dayOfWeekUdf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)day -> BoxesRunTime.boxToInteger((int)ChicagoCrimeApp$.MODULE$.dayOfWeek(day)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1()));
    }
}

