/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.models.H2ODeepLearningMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import java.io.File;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.SymbolLiteral;

public final class DeepLearningDemo$ {
    public static DeepLearningDemo$ MODULE$;

    static {
        new DeepLearningDemo$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Deep Learning Demo on Airlines Data").getOrCreate();
        String airlinesDataPath = "./examples/smalldata/airlines/allyears2k_headers.csv";
        String airlinesDataFile = new StringBuilder(7).append("file://").append(new File(airlinesDataPath).getAbsolutePath()).toString();
        Dataset airlinesTable = spark.read().option("header", "true").option("inferSchema", "true").option("nullValue", "NA").csv(airlinesDataFile);
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("\n===> Number of all flights: ").append(airlinesTable.count()).append("\n").toString());
        Dataset airlinesSFO = airlinesTable.filter(spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Dest")).$eq$eq$eq((Object)"SFO"));
        Predef$.MODULE$.println((Object)new StringBuilder(50).append("\n===> Number of flights with destination in SFO: ").append(airlinesSFO.count()).append("\n").toString());
        Predef$.MODULE$.println((Object)"\n====> Running DeepLearning on the prepared data frame\n");
        Dataset train = airlinesSFO.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Year")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Month")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DayofMonth")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DayOfWeek")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "CRSDepTime")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "CRSArrTime")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "UniqueCarrier")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "FlightNum")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "TailNum")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "CRSElapsedTime")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Origin")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Dest")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Distance")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "IsDepDelayed"))}));
        H2OContext$.MODULE$.getOrCreate();
        H2ODeepLearning dl = (H2ODeepLearning)((H2OCommonParams)new H2ODeepLearning().setLabelCol("IsDepDelayed")).setConvertUnknownCategoricalLevelsToNa(true);
        long count = train.count();
        H2ODeepLearningMOJOModel model = dl.fit(train.repartition((int)count + 10));
        Row[] predictions = (Row[])model.transform(airlinesSFO).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).mkString("\n===> Model predictions from DL: ", ", ", ", ...\n"));
    }

    private DeepLearningDemo$() {
        MODULE$ = this;
    }
}

