/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.algos.H2OGBM;
import ai.h2o.sparkling.ml.models.H2ODeepLearningMOJOModel;
import ai.h2o.sparkling.ml.models.H2OGBMMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import ai.h2o.sparkling.ml.params.H2ODeepLearningParams;
import ai.h2o.sparkling.ml.params.H2OGBMParams;
import java.io.File;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.SymbolLiteral;

public final class AirlinesWithWeatherDemo$ {
    public static AirlinesWithWeatherDemo$ MODULE$;

    static {
        new AirlinesWithWeatherDemo$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Join of Airlines with Weather Data").getOrCreate();
        String weatherDataPath = "./examples/smalldata/chicago/Chicago_Ohare_International_Airport.csv";
        String weatherDataFile = new StringBuilder(7).append("file://").append(new File(weatherDataPath).getAbsolutePath()).toString();
        Dataset weatherTable = spark.read().option("header", "true").option("inferSchema", "true").csv(weatherDataFile).withColumn("Date", functions$.MODULE$.to_date(functions$.MODULE$.regexp_replace((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Date")), "(\\d+)/(\\d+)/(\\d+)", "$3-$2-$1"))).withColumn("Year", functions$.MODULE$.year((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Date")))).withColumn("Month", functions$.MODULE$.month((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Date")))).withColumn("DayofMonth", functions$.MODULE$.dayofmonth((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Date"))));
        String airlinesDataPath = "./examples/smalldata/airlines/allyears2k_headers.csv";
        String airlinesDataFile = new StringBuilder(7).append("file://").append(new File(airlinesDataPath).getAbsolutePath()).toString();
        Dataset airlinesTable = spark.read().option("header", "true").option("inferSchema", "true").option("nullValue", "NA").csv(airlinesDataFile);
        Dataset flightsToORD = airlinesTable.filter(spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Dest")).$eq$eq$eq((Object)"ORD"));
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("\nFlights to ORD: ").append(flightsToORD.count()).append("\n").toString());
        Dataset joined = flightsToORD.join(weatherTable, (Seq)new .colon.colon((Object)"Year", (List)new .colon.colon((Object)"Month", (List)new .colon.colon((Object)"DayofMonth", (List)Nil$.MODULE$))));
        H2OContext$.MODULE$.getOrCreate();
        H2ODeepLearning dl = (H2ODeepLearning)((H2ODeepLearningParams)((H2OCommonParams)new H2ODeepLearning().setLabelCol("ArrDelay")).setSplitRatio(0.8)).setEpochs(5.0).setHidden(new int[]{100, 100}).setActivation("RectifierWithDropout");
        H2ODeepLearningMOJOModel deepLearningModel = dl.fit(joined);
        Row[] predictionsFromDL = (Row[])deepLearningModel.transform(joined).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictionsFromDL)).mkString("\n===> Model predictions from DL: ", ", ", ", ...\n"));
        H2OGBM gbm = (H2OGBM)((H2OGBMParams)((H2OCommonParams)new H2OGBM().setLabelCol("ArrDelay")).setSplitRatio(0.8)).setNtrees(100);
        H2OGBMMOJOModel gbmModel = gbm.fit(joined);
        Row[] predictionsFromGBM = (Row[])gbmModel.transform(joined).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictionsFromGBM)).mkString("\n===> Model predictions from GBM: ", ", ", ", ...\n"));
    }

    private AirlinesWithWeatherDemo$() {
        MODULE$ = this;
    }
}

