/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.examples;

import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.examples.ChicagoCrimeApp;
import ai.h2o.sparkling.examples.ChicagoCrimeApp$;
import ai.h2o.sparkling.ml.algos.H2ODeepLearning;
import ai.h2o.sparkling.ml.algos.H2OGBM;
import ai.h2o.sparkling.ml.models.H2OMOJOModel;
import ai.h2o.sparkling.ml.params.H2OCommonParams;
import ai.h2o.sparkling.ml.params.H2ODeepLearningParams;
import ai.h2o.sparkling.ml.params.H2OGBMParams;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

public final class ChicagoCrimeApp$ {
    public static ChicagoCrimeApp$ MODULE$;
    private final UserDefinedFunction seasonUdf;
    private final UserDefinedFunction weekendUdf;
    private final UserDefinedFunction dayOfWeekUdf;

    static {
        new ChicagoCrimeApp$();
    }

    private UserDefinedFunction seasonUdf() {
        return this.seasonUdf;
    }

    private UserDefinedFunction weekendUdf() {
        return this.weekendUdf;
    }

    private UserDefinedFunction dayOfWeekUdf() {
        return this.dayOfWeekUdf;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Chicago Crime App").getOrCreate();
        Dataset weatherTable = this.loadCsv("./examples/smalldata/chicago/chicagoAllWeather.csv", spark).drop("date");
        String chicagoWeatherTableName = "chicagoWeather";
        weatherTable.createOrReplaceTempView(chicagoWeatherTableName);
        Dataset<Row> censusTable = this.loadCsv("./examples/smalldata/chicago/chicagoCensus.csv", spark);
        String chicagoCensusTableName = "chicagoCensus";
        censusTable.createOrReplaceTempView(chicagoCensusTableName);
        Dataset<Row> crimesTable = this.addAdditionalDateColumns(this.loadCsv("./examples/smalldata/chicago/chicagoCrimes10k.csv", spark), spark);
        String chicagoCrimeTableName = "chicagoCrime";
        crimesTable.createOrReplaceTempView(chicagoCrimeTableName);
        Seq crimeDataColumnsForTraining = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnName[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Year"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Month"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Day"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WeekNum"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HourOfDay"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weekend"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Season"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WeekDay"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IUCR"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Primary_Type"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Location_Description"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Community_Area"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"District"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Arrest"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Domestic"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beat"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ward"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FBI_Code"}))).$((Seq)Nil$.MODULE$)}));
        Seq censusDataColumnsForTraining = (Seq)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_AGED_UNDER_18_OR_OVER_64"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PER_CAPITA_INCOME"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HARDSHIP_INDEX"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_OF_HOUSING_CROWDED"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_HOUSEHOLDS_BELOW_POVERTY"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_AGED_16_UNEMPLOYED"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PERCENT_AGED_25_WITHOUT_HIGH_SCHOOL_DIPLOMA"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
        Seq weatherDataColumnsForTraining = (Seq)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minTemp"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxTemp"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"meanTemp"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)));
        Dataset joinedDataForTraining = spark.table(chicagoCrimeTableName).as("cr").join(spark.table(chicagoWeatherTableName).as("we"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Year"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we.year"}))).$((Seq)Nil$.MODULE$)).and(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Month"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we.month"}))).$((Seq)Nil$.MODULE$))).and(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Day"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we.day"}))).$((Seq)Nil$.MODULE$)))).join(spark.table(chicagoCensusTableName).as("ce"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cr.Community_Area"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ce.Community_Area_Number"}))).$((Seq)Nil$.MODULE$))).select((Seq)((TraversableLike)crimeDataColumnsForTraining.$plus$plus((GenTraversableOnce)censusDataColumnsForTraining, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)weatherDataColumnsForTraining, Seq$.MODULE$.canBuildFrom()));
        H2OContext$.MODULE$.getOrCreate();
        H2OMOJOModel gbmModel = this.trainGBM((Dataset<Row>)joinedDataForTraining);
        H2OMOJOModel dlModel = this.trainDeepLearning((Dataset<Row>)joinedDataForTraining);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.h2o.sparkling.examples.ChicagoCrimeApp.CrimeWithCensusData").asType().toTypeConstructor();
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator5$1() {
            }
        }
        Dataset crimesToScore = spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new ChicagoCrimeApp.CrimeWithCensusData("02/08/2015 11:43:58 PM", 1811, "NARCOTICS", "STREET", false, 422, 4, 7, 46, 18, 41.1, 16579, 75, 4.7, 29.8, 19.7, 26.6), (List)new .colon.colon((Object)new ChicagoCrimeApp.CrimeWithCensusData("02/08/2015 11:00:39 PM", 1150, "DECEPTIVE PRACTICE", "RESIDENCE", false, 923, 9, 14, 63, 11, 38.8, 12171, 93, 15.8, 23.4, 18.2, 51.5), (List)Nil$.MODULE$)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator5$1()))).toDF();
        this.score(this.addAdditionalDateColumns((Dataset<Row>)crimesToScore, spark), gbmModel, dlModel, spark);
    }

    private H2OMOJOModel trainGBM(Dataset<Row> train) {
        H2OGBM gbm = (H2OGBM)((H2OGBMParams)((H2OCommonParams)((H2OGBMParams)new H2OGBM().setSplitRatio(0.8)).setLabelCol("Arrest")).setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setNtrees(10).setMaxDepth(6).setDistribution("bernoulli");
        return gbm.fit(train);
    }

    private H2OMOJOModel trainDeepLearning(Dataset<Row> train) {
        H2ODeepLearning dl = (H2ODeepLearning)((H2ODeepLearningParams)((H2OCommonParams)((H2ODeepLearningParams)new H2ODeepLearning().setSplitRatio(0.8)).setLabelCol("Arrest")).setColumnsToCategorical("Arrest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).setEpochs(10.0).setL1(1.0E-4).setL2(1.0E-4).setActivation("RectifierWithDropout").setHidden(new int[]{200, 200});
        return dl.fit(train);
    }

    private void score(Dataset<Row> crimes, H2OMOJOModel gbmModel, H2OMOJOModel dlModel, SparkSession spark) {
        Dataset arrestGBM = gbmModel.transform(crimes);
        Dataset arrestDL = dlModel.transform(crimes);
        Column willBeArrestedPrediction = spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"1");
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("\n           |  Will be arrested based on DeepLearning: ").append(arrestDL.where(willBeArrestedPrediction).count()).append("\n           |  Will be arrested based on GBM: ").append(arrestGBM.where(willBeArrestedPrediction).count()).append("\n           |\n        ").toString())).stripMargin());
    }

    private Dataset<Row> loadCsv(String dataPath, SparkSession spark) {
        String datafile = new StringBuilder(7).append("file://").append(new File(dataPath).getAbsolutePath()).toString();
        Dataset df = spark.read().option("header", "true").option("inferSchema", "true").csv(datafile);
        Column[] renamedColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)col -> {
            String name = col.trim().replace(' ', '_').replace('+', '_').replace("__", "_");
            return df.apply(col).as(name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])renamedColumns));
    }

    private Dataset<Row> addAdditionalDateColumns(Dataset<Row> df, SparkSession spark) {
        return df.withColumn("DateTmp", functions$.MODULE$.from_unixtime(functions$.MODULE$.unix_timestamp((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Date")), "MM/dd/yyyy hh:mm:ss a"))).withColumn("Year", functions$.MODULE$.year((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("Month", functions$.MODULE$.month((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("Day", functions$.MODULE$.dayofmonth((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("WeekNum", functions$.MODULE$.weekofyear((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("HourOfDay", functions$.MODULE$.hour((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")))).withColumn("Season", this.seasonUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "Month"))}))).withColumn("WeekDay", this.dayOfWeekUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_format((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")), "E")}))).withColumn("Weekend", this.weekendUdf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "WeekDay"))}))).drop((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "DateTmp")));
    }

    private String monthToSeason(int month) {
        return month >= 3 && month <= 5 ? "Spring" : (month >= 6 && month <= 8 ? "Summer" : (month >= 9 && month <= 10 ? "Autumn" : "Winter"));
    }

    private boolean isWeekend(int dayOfWeek) {
        return dayOfWeek == 7 || dayOfWeek == 6;
    }

    private int boolToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    private int dayOfWeek(String day) {
        int n;
        String string = day;
        if ("Mon".equals(string)) {
            n = 1;
        } else if ("Tue".equals(string)) {
            n = 2;
        } else if ("Wed".equals(string)) {
            n = 3;
        } else if ("Thu".equals(string)) {
            n = 4;
        } else if ("Fri".equals(string)) {
            n = 5;
        } else if ("Sat".equals(string)) {
            n = 6;
        } else if ("Sun".equals(string)) {
            n = 7;
        } else {
            throw new RuntimeException("Invalid day!");
        }
        return n;
    }

    private ChicagoCrimeApp$() {
        MODULE$ = this;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1() {
            }
        }
        this.seasonUdf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)month -> ChicagoCrimeApp$.MODULE$.monthToSeason(BoxesRunTime.unboxToInt((Object)month)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        this.weekendUdf = functions$.MODULE$.udf(((JFunction1.mcZI.sp & Serializable & scala.Serializable)(JFunction1.mcZI.sp & Serializable & scala.Serializable)dayOfWeek -> MODULE$.isWeekend(dayOfWeek)).andThen((Function1 & Serializable & scala.Serializable)bool -> BoxesRunTime.boxToInteger((int)ChicagoCrimeApp$.MODULE$.boolToInt(BoxesRunTime.unboxToBoolean((Object)bool)))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1() {
            }
        }
        this.dayOfWeekUdf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)day -> BoxesRunTime.boxToInteger((int)ChicagoCrimeApp$.MODULE$.dayOfWeek(day)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_h2o_sparkling_examples_ChicagoCrimeApp$$typecreator2$1()));
    }
}

