/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.schemas.ModelBuilderSchema;
import org.apache.spark.ml.spark.models.MissingValuesHandling;
import org.apache.spark.ml.spark.models.svm.Gradient;
import org.apache.spark.ml.spark.models.svm.SVM;
import org.apache.spark.ml.spark.models.svm.SVMParameters;
import org.apache.spark.ml.spark.models.svm.Updater;
import water.DKV;
import water.Key;
import water.Value;
import water.api.API;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelParametersSchemaV3;
import water.fvec.Frame;

public class SVMV3
extends ModelBuilderSchema<SVM, SVMV3, SVMParametersV3> {

    public static final class SVMParametersV3
    extends ModelParametersSchemaV3<SVMParameters, SVMParametersV3> {
        public static String[] fields = new String[]{"model_id", "training_frame", "response_column", "initial_weights_frame", "validation_frame", "nfolds", "add_intercept", "step_size", "reg_param", "convergence_tol", "mini_batch_fraction", "threshold", "updater", "gradient", "ignored_columns", "ignore_const_cols", "missing_values_handling"};
        @API(help="Initial model weights.", direction=API.Direction.INOUT, gridable=true)
        public KeyV3.FrameKeyV3 initial_weights_frame;
        @API(help="Add intercept.", direction=API.Direction.INOUT, gridable=true, level=API.Level.expert)
        public boolean add_intercept = false;
        @API(help="Set step size", direction=API.Direction.INPUT, gridable=true, level=API.Level.expert)
        public double step_size = 1.0;
        @API(help="Set regularization parameter", direction=API.Direction.INPUT, gridable=true, level=API.Level.expert)
        public double reg_param = 0.01;
        @API(help="Set convergence tolerance", direction=API.Direction.INPUT, gridable=true, level=API.Level.expert)
        public double convergence_tol = 0.001;
        @API(help="Set mini batch fraction", direction=API.Direction.INPUT, gridable=true, level=API.Level.expert)
        public double mini_batch_fraction = 1.0;
        @API(help="Set threshold that separates positive predictions from negative ones. NaN for raw prediction.", direction=API.Direction.INOUT, gridable=true, level=API.Level.expert)
        public double threshold = 0.0;
        @API(help="Set the updater for SGD.", direction=API.Direction.INPUT, values={"L2", "L1", "Simple"}, required=true, gridable=true, level=API.Level.expert)
        public Updater updater = Updater.L2;
        @API(help="Set the gradient computation type for SGD.", direction=API.Direction.INPUT, values={"Hinge", "LeastSquares", "Logistic"}, required=true, gridable=true, level=API.Level.expert)
        public Gradient gradient = Gradient.Hinge;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, values={"NotAllowed", "Skip", "MeanImputation"}, help="Handling of missing values. Either NotAllowed, Skip or MeanImputation.")
        public MissingValuesHandling missing_values_handling;

        public SVMParametersV3 fillFromImpl(SVMParameters impl) {
            Value v;
            super.fillFromImpl((Model.Parameters)impl);
            if (null != impl._initial_weights && null != (v = DKV.get(impl._initial_weights))) {
                this.initial_weights_frame = new KeyV3.FrameKeyV3(((Frame)v.get())._key);
            }
            return this;
        }

        public SVMParameters fillImpl(SVMParameters impl) {
            super.fillImpl((Model.Parameters)impl);
            impl._initial_weights = null == this.initial_weights_frame ? null : Key.make((String)this.initial_weights_frame.name);
            return impl;
        }
    }
}

