/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.features;

import hex.FrameSplitter;
import java.io.IOException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.h2o.OneTimeTransformer;
import org.apache.spark.ml.h2o.features.DatasetSplitter$;
import org.apache.spark.ml.h2o.features.DatasetSplitterParams;
import org.apache.spark.ml.h2o.features.DatasetSplitterParams$class;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import water.DKV;
import water.H2O;
import water.Key;
import water.fvec.Frame;
import water.fvec.H2OFrame;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001=\u0011q\u0002R1uCN,Go\u00159mSR$XM\u001d\u0006\u0003\u0007\u0011\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u000b\u0019\t1\u0001\u001b\u001ap\u0015\t9\u0001\"\u0001\u0002nY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001B\u0003\u0007\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011!c\u00148f)&lW\r\u0016:b]N4wN]7feB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0016\t\u0006$\u0018m]3u'Bd\u0017\u000e\u001e;feB\u000b'/Y7t!\tIB$D\u0001\u001b\u0015\tYb!\u0001\u0003vi&d\u0017BA\u000f\u001b\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016D\u0001b\b\u0001\u0003\u0006\u0004%\t\u0005I\u0001\u0004k&$W#A\u0011\u0011\u0005\tBcBA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"\u0013A\u0002)sK\u0012,g-\u0003\u0002*U\t11\u000b\u001e:j]\u001eT!a\n\u0013\t\u00111\u0002!\u0011!Q\u0001\n\u0005\nA!^5eA!Aa\u0006\u0001BC\u0002\u0013\rq&\u0001\u0006ie=\u001cuN\u001c;fqR,\u0012\u0001\r\t\u0003cMj\u0011A\r\u0006\u0003\u000b!I!\u0001\u000e\u001a\u0003\u0015!\u0013tjQ8oi\u0016DH\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00031\u0003-A'g\\\"p]R,\u0007\u0010\u001e\u0011\t\u0011a\u0002!\u0011!Q\u0001\fe\n!b]9m\u0007>tG/\u001a=u!\tQT(D\u0001<\u0015\ta\u0004\"A\u0002tc2L!AP\u001e\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003A\u0001\u0011\u0005\u0011)\u0001\u0004=S:LGO\u0010\u000b\u0003\u0005\u001a#2a\u0011#F!\t)\u0002\u0001C\u0003/\u007f\u0001\u000f\u0001\u0007C\u00039\u007f\u0001\u000f\u0011\bC\u0003 \u007f\u0001\u0007\u0011\u0005C\u0003A\u0001\u0011\u0005\u0001\nF\u0001J)\r\u0019%j\u0013\u0005\u0006]\u001d\u0003\u001d\u0001\r\u0005\u0006q\u001d\u0003\u001d!\u000f\u0005\u0006\u001b\u0002!IAT\u0001\u0006gBd\u0017\u000e\u001e\u000b\u0005\u001fj{V\u000eE\u0002$!JK!!\u0015\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u00024wK\u000eT\u0011aV\u0001\u0006o\u0006$XM]\u0005\u00033R\u0013QA\u0012:b[\u0016DQa\u0017'A\u0002q\u000b!\u0001\u001a4\u0011\u0005Mk\u0016B\u00010U\u0005!A%g\u0014$sC6,\u0007\"\u00021M\u0001\u0004\t\u0017\u0001B6fsN\u00042A\u00196\"\u001d\t\u0019\u0007N\u0004\u0002eO6\tQM\u0003\u0002g\u001d\u00051AH]8pizJ\u0011!J\u0005\u0003S\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002lY\n\u00191+Z9\u000b\u0005%$\u0003\"\u00028M\u0001\u0004y\u0017A\u0002:bi&|7\u000fE\u0002cUB\u0004\"aI9\n\u0005I$#A\u0002#pk\ndW\rC\u0003u\u0001\u0011\u0005Q/A\u0005tKR\u0014\u0016\r^5pgR\u00111I\u001e\u0005\u0006oN\u0004\r\u0001_\u0001\u0006m\u0006dW/\u001a\t\u0004GA\u0003\b\"\u0002>\u0001\t\u0003Y\u0018aB:fi.+\u0017p\u001d\u000b\u0003\u0007rDQa^=A\u0002u\u00042a\t)\"\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005Y1/\u001a;Ue\u0006LgnS3z)\r\u0019\u00151\u0001\u0005\u0006oz\u0004\r!\t\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u0006\u0003/\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#Y\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\tI\"!\u0002A\u0002\u0005-\u0011AB:dQ\u0016l\u0017\r\u000b\u0003\u0002\u0006\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0002\"\u0001\u0006b]:|G/\u0019;j_:LA!a\n\u0002\"\taA)\u001a<fY>\u0004XM]!qS\"9\u00111\u0006\u0001\u0005B\u00055\u0012!\u0003;sC:\u001chm\u001c:n)\u0011\ty#a\u0013\u0011\t\u0005E\u0012Q\t\b\u0005\u0003g\t\u0019E\u0004\u0003\u00026\u0005\u0005c\u0002BA\u001c\u0003\u007fqA!!\u000f\u0002>9\u0019A-a\u000f\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011B\u0001\u001f\t\u0013\tI7(\u0003\u0003\u0002H\u0005%#!\u0003#bi\u00064%/Y7f\u0015\tI7\b\u0003\u0005\u0002N\u0005%\u0002\u0019AA(\u0003\u001d!\u0017\r^1tKR\u0004D!!\u0015\u0002\\A)!(a\u0015\u0002X%\u0019\u0011QK\u001e\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011LA.\u0019\u0001!A\"!\u0018\u0002L\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00132#\u0011\t\t'a\u001a\u0011\u0007\r\n\u0019'C\u0002\u0002f\u0011\u0012qAT8uQ&tw\rE\u0002$\u0003SJ1!a\u001b%\u0005\r\te.\u001f\u0005\b\u0003_\u0002A\u0011IA9\u0003\u0011\u0019w\u000e]=\u0015\t\u0005M\u00141\u0010\t\u0005\u0003k\n9(D\u0001\u0007\u0013\r\tIH\u0002\u0002\f)J\fgn\u001d4pe6,'\u000f\u0003\u0005\u0002~\u00055\u0004\u0019AA@\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC\r\u0005)\u0001/\u0019:b[&!\u0011\u0011RAB\u0005!\u0001\u0016M]1n\u001b\u0006\u0004xaBAG\u0005!\u0005\u0011qR\u0001\u0010\t\u0006$\u0018m]3u'Bd\u0017\u000e\u001e;feB\u0019Q#!%\u0007\r\u0005\u0011\u0001\u0012AAJ'!\t\t*!&\u0002\u001c\u0006\u0005\u0006cA\u0012\u0002\u0018&\u0019\u0011\u0011\u0014\u0013\u0003\r\u0005s\u0017PU3g!\u0011I\u0012QT\"\n\u0007\u0005}%D\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u00042aIAR\u0013\r\t)\u000b\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u0001\u0006EE\u0011AAU)\t\tyIB\u0004\u0002.\u0006EE!a,\u0003+\u0011\u000bG/Y:fiN\u0003H.\u001b;uKJ\u0014V-\u00193feN!\u00111VAY!\u0011I\u00121W\"\n\u0007\u0005U&D\u0001\u0005N\u0019J+\u0017\rZ3s\u0011\u001d\u0001\u00151\u0016C\u0001\u0003s#\"!a/\u0011\t\u0005u\u00161V\u0007\u0003\u0003#C!\"!1\u0002,\n\u0007I\u0011BAb\u0003%\u0019G.Y:t\u001d\u0006lW-\u0006\u0002\u0002FB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017\u0001\u00027b]\u001eT!!a4\u0002\t)\fg/Y\u0005\u0004S\u0005%\u0007\"CAk\u0003W\u0003\u000b\u0011BAc\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u0005\t\u00033\fY\u000b\"\u0011\u0002\\\u0006!An\\1e)\r\u0019\u0015Q\u001c\u0005\b\u0003?\f9\u000e1\u0001\"\u0003\u0011\u0001\u0018\r\u001e5\t\u0011\u0005\r\u0018\u0011\u0013C!\u0003K\fAA]3bIV\u0011\u0011\u0011\u0017\u0015\u0007\u0003C\fI/a<\u0011\t\u0005}\u00111^\u0005\u0005\u0003[\f\tCA\u0003TS:\u001cW-\t\u0002\u0002r\u0006)\u0011G\f\u001c/a!A\u0011\u0011\\AI\t\u0003\n)\u0010F\u0002D\u0003oDq!a8\u0002t\u0002\u0007\u0011\u0005\u000b\u0004\u0002t\u0006%\u0018q\u001e\u0005\u000b\u0003{\f\t*!A\u0005\n\u0005}\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0001\u0011\t\u0005\u001d'1A\u0005\u0005\u0005\u000b\tIM\u0001\u0004PE*,7\r\u001e")
public class DatasetSplitter
extends OneTimeTransformer
implements DatasetSplitterParams,
DefaultParamsWritable {
    private final String uid;
    private final H2OContext h2oContext;
    private final SQLContext sqlContext;
    private final DoubleArrayParam ratios;
    private final StringArrayParam keys;
    private final Param<String> trainKey;

    public static DatasetSplitter load(String string) {
        return DatasetSplitter$.MODULE$.load(string);
    }

    public static MLReader<DatasetSplitter> read() {
        return DatasetSplitter$.MODULE$.read();
    }

    public MLWriter write() {
        return DefaultParamsWritable.class.write((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    @Override
    public final DoubleArrayParam ratios() {
        return this.ratios;
    }

    @Override
    public final StringArrayParam keys() {
        return this.keys;
    }

    @Override
    public final Param<String> trainKey() {
        return this.trainKey;
    }

    @Override
    public final void org$apache$spark$ml$h2o$features$DatasetSplitterParams$_setter_$ratios_$eq(DoubleArrayParam x$1) {
        this.ratios = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$features$DatasetSplitterParams$_setter_$keys_$eq(StringArrayParam x$1) {
        this.keys = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$features$DatasetSplitterParams$_setter_$trainKey_$eq(Param x$1) {
        this.trainKey = x$1;
    }

    @Override
    public double[] getRatios() {
        return DatasetSplitterParams$class.getRatios(this);
    }

    @Override
    public String[] getKeys() {
        return DatasetSplitterParams$class.getKeys(this);
    }

    @Override
    public String getTrainKey() {
        return DatasetSplitterParams$class.getTrainKey(this);
    }

    public String uid() {
        return this.uid;
    }

    public H2OContext h2oContext() {
        return this.h2oContext;
    }

    private Frame[] split(H2OFrame df, Seq<String> keys, Seq<Object> ratios) {
        Key[] ks = (Key[])((TraversableOnce)keys.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Key<Frame> apply(String x$1) {
                return Key.make((String)x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Key.class));
        FrameSplitter splitter = new FrameSplitter((Frame)df, (double[])ratios.toArray(ClassTag$.MODULE$.Double()), ks, null);
        H2O.submitTask((H2O.H2OCountedCompleter)splitter);
        return splitter.getResult();
    }

    public DatasetSplitter setRatios(double[] value) {
        return (DatasetSplitter)this.set((Param)this.ratios(), value);
    }

    public DatasetSplitter setKeys(String[] value) {
        return (DatasetSplitter)this.set((Param)this.keys(), value);
    }

    public DatasetSplitter setTrainKey(String value) {
        return (DatasetSplitter)this.set(this.trainKey(), value);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return schema;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.keys())).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Keys can not be empty";
            }
        });
        this.split(this.h2oContext().implicits().asH2OFrameFromDataFrame(dataset.toDF()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.$((Param)this.keys())), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])this.$((Param)this.ratios())));
        String returnKey = Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.keys())).contains(this.$(this.trainKey())) ? (String)this.$(this.trainKey()) : ((String[])this.$((Param)this.keys()))[0];
        return this.h2oContext().asDataFrame((Frame)DKV.getGet((String)returnKey), this.h2oContext().asDataFrame$default$2(), this.sqlContext);
    }

    public Transformer copy(ParamMap extra) {
        return (Transformer)this.defaultCopy(extra);
    }

    public DatasetSplitter(String uid, H2OContext h2oContext, SQLContext sqlContext) {
        this.uid = uid;
        this.h2oContext = h2oContext;
        this.sqlContext = sqlContext;
        DatasetSplitterParams$class.$init$(this);
        MLWritable.class.$init$((MLWritable)this);
        DefaultParamsWritable.class.$init$((DefaultParamsWritable)this);
    }

    public DatasetSplitter(H2OContext h2oContext, SQLContext sqlContext) {
        this(Identifiable$.MODULE$.randomUID("h2oFrameSplitter"), h2oContext, sqlContext);
    }

    public static class DatasetSplitterReader
    extends MLReader<DatasetSplitter> {
        private final String className = DatasetSplitter.class.getName();

        private String className() {
            return this.className;
        }

        public DatasetSplitter load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            H2OContext h2oContext = H2OContext$.MODULE$.ensure((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "H2OContext has to be started in order to use H2O pipelines elements";
                }
            });
            DatasetSplitter datasetSplitter = new DatasetSplitter(metadata.uid(), h2oContext, this.sqlContext());
            DefaultParamsReader$.MODULE$.getAndSetParams((Params)datasetSplitter, metadata);
            return datasetSplitter;
        }
    }
}

