/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.models;

import hex.Model;
import java.io.IOException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.h2o.models.H2OModelWriter;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import water.fvec.Frame;
import water.fvec.H2OFrame;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!B\u0001\u0003\u0003\u0003y!\u0001\u0003%3\u001f6{G-\u001a7\u000b\u0005\r!\u0011AB7pI\u0016d7O\u0003\u0002\u0006\r\u0005\u0019\u0001NM8\u000b\u0005\u001dA\u0011AA7m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0004!]\u00193c\u0001\u0001\u0012\u0003B\u0019!cE\u000b\u000e\u0003\u0019I!\u0001\u0006\u0004\u0003\u000b5{G-\u001a7\u0011\u0005Y9B\u0002\u0001\u0003\u00061\u0001\u0011\r!\u0007\u0002\u0002'F\u0011!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0003!\u0006\u0012\u000e\u0003\t\u0001\"AF\u0012\u0005\u000b\u0011\u0002!\u0019A\u0013\u0003\u00035\u000b\"A\u0007\u00141\t\u001djCg\u000e\t\u0006Q-b3GN\u0007\u0002S)\t!&A\u0002iKbL!\u0001F\u0015\u0011\u0005YiC!\u0003\u0018$\u0003\u0003\u0005\tQ!\u00010\u0005\ryF%M\t\u00035A\u0002\"aG\u0019\n\u0005Ib\"aA!osB\u0011a\u0003\u000e\u0003\nk\r\n\t\u0011!A\u0003\u0002=\u00121a\u0018\u00133!\t1r\u0007B\u00059G\u0005\u0005\t\u0011!B\u0001s\t\u0019q\fJ\u001a\u0012\u0005iQ\u0004CA\u001e?\u001d\tAC(\u0003\u0002>S\u0005)Qj\u001c3fY&\u0011q\b\u0011\u0002\u0007\u001fV$\b/\u001e;\u000b\u0005uJ\u0003C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0007\u0003\u0011)H/\u001b7\n\u0005\u0019\u001b%AC'M/JLG/\u00192mK\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011*A\u0003n_\u0012,G.F\u0001#\u0011!Y\u0005A!A!\u0002\u0013\u0011\u0013AB7pI\u0016d\u0007\u0005\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0003)A'g\\\"p]R,\u0007\u0010\u001e\t\u0003\u001fFk\u0011\u0001\u0015\u0006\u0003\u000b!I!A\u0015)\u0003\u0015!\u0013tjQ8oi\u0016DH\u000f\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003-fk\u0011a\u0016\u0006\u00031\"\t1a]9m\u0013\tQvK\u0001\u0006T#2\u001buN\u001c;fqRDQ\u0001\u0018\u0001\u0005\u0002u\u000ba\u0001P5oSRtD\u0003\u0002\u0011_?\u0002DQ\u0001S.A\u0002\tBQ!T.A\u00029CQ\u0001V.A\u0002UCQA\u0019\u0001\u0005B\r\fAaY8qsR\u0011Q\u0003\u001a\u0005\u0006K\u0006\u0004\rAZ\u0001\u0006Kb$(/\u0019\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u001a\tQ\u0001]1sC6L!a\u001b5\u0003\u0011A\u000b'/Y7NCBDQ!\u001c\u0001\u0005B9\f\u0011\u0002\u001e:b]N4wN]7\u0015\u0007=\f\u0019\u0001\u0005\u0002q}:\u0011\u0011\u000f \b\u0003ent!a\u001d>\u000f\u0005QLhBA;y\u001b\u00051(BA<\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u00031\"I!!`,\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA?X\u0011\u001d\t)\u0001\u001ca\u0001\u0003\u000f\tq\u0001Z1uCN,G\u000f\r\u0003\u0002\n\u0005E\u0001#\u0002,\u0002\f\u0005=\u0011bAA\u0007/\n9A)\u0019;bg\u0016$\bc\u0001\f\u0002\u0012\u0011Y\u00111CA\u0002\u0003\u0003\u0005\tQ!\u00010\u0005\ryF\u0005\u000e\u0005\b\u0003/\u0001A\u0011IA\r\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u000e\u0003O\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C9\u0016!\u0002;za\u0016\u001c\u0018\u0002BA\u0013\u0003?\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\tI#!\u0006A\u0002\u0005m\u0011AB:dQ\u0016l\u0017\r\u000b\u0003\u0002\u0016\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0002\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u000e\u00022\taA)\u001a<fY>\u0004XM]!qS\"9\u00111\b\u0001\u0005B\u0005u\u0012!B<sSR,WCAA !\r\u0011\u0015\u0011I\u0005\u0004\u0003\u0007\u001a%\u0001C'M/JLG/\u001a:)\r\u0005e\u0012qIA'!\u0011\ty#!\u0013\n\t\u0005-\u0013\u0011\u0007\u0002\u0006'&t7-Z\u0011\u0003\u0003\u001f\nQ!\r\u00187]ABq!a\u0015\u0001\r\u0003\t)&A\beK\u001a\fW\u000f\u001c;GS2,g*Y7f+\t\t9\u0006\u0005\u0003\u0002Z\u0005}cbA\u000e\u0002\\%\u0019\u0011Q\f\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t'a\u0019\u0003\rM#(/\u001b8h\u0015\r\ti\u0006\b")
public abstract class H2OModel<S extends H2OModel<S, M>, M extends hex.Model<?, ?, ? extends Model.Output>>
extends Model<S>
implements MLWritable {
    private final M model;
    private final H2OContext h2oContext;
    private final SQLContext sqlContext;

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    public M model() {
        return this.model;
    }

    public S copy(ParamMap extra) {
        return (S)((Object)((H2OModel)this.defaultCopy(extra)));
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        H2OFrame frame = this.h2oContext.asH2OFrame(dataset.toDF());
        Frame prediction = this.model().score((Frame)frame);
        return this.h2oContext.asDataFrame(prediction, this.h2oContext.asDataFrame$default$2(), this.sqlContext);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        int ncols = ((hex.Model)this.model())._output.nclasses() == 1 ? 1 : ((hex.Model)this.model())._output.nclasses() + 1;
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])((hex.Model)this.model())._output._names).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String name) {
                return new StructField(name, (DataType)DoubleType$.MODULE$, true, null);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public MLWriter write() {
        return new H2OModelWriter<H2OModel>(this);
    }

    public abstract String defaultFileName();

    public H2OModel(M model, H2OContext h2oContext, SQLContext sqlContext) {
        this.model = model;
        this.h2oContext = h2oContext;
        this.sqlContext = sqlContext;
        MLWritable.class.$init$((MLWritable)this);
    }
}

