/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.AutoMLBuildSpec;
import hex.ScoreKeeper;
import java.io.IOException;
import java.util.Date;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.h2o.algos.H2OAutoML$;
import org.apache.spark.ml.h2o.algos.H2OAutoMLAlgosParam;
import org.apache.spark.ml.h2o.algos.H2OAutoMLParams;
import org.apache.spark.ml.h2o.algos.H2OAutoMLParams$class;
import org.apache.spark.ml.h2o.algos.H2OAutoMLStoppingMetricParam;
import org.apache.spark.ml.h2o.algos.H2OAutoMLWriter;
import org.apache.spark.ml.h2o.models.H2OMOJOModel;
import org.apache.spark.ml.h2o.param.NullableFloatArrayParam;
import org.apache.spark.ml.h2o.param.NullableStringParam;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.FloatParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import water.DKV;
import water.IcedWrapper;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.support.H2OFrameSupport$;
import water.support.ModelSerializationSupport$;
import water.util.TwoDimTable;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001=\u0011\u0011\u0002\u0013\u001aP\u0003V$x.\u0014'\u000b\u0005\r!\u0011!B1mO>\u001c(BA\u0003\u0007\u0003\rA'g\u001c\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!i\u0001\u0003cA\t\u0013)5\ta!\u0003\u0002\u0014\r\tIQi\u001d;j[\u0006$xN\u001d\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\ta!\\8eK2\u001c\u0018BA\r\u0017\u00051A%gT'P\u0015>ku\u000eZ3m!\tYb$D\u0001\u001d\u0015\tib!\u0001\u0003vi&d\u0017BA\u0010\u001d\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011q\u0002\u0013\u001aP\u0003V$x.\u0014'QCJ\fWn\u001d\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005y\u0011-\u001e;p[2\u0014U/\u001b7e'B,7-F\u0001(!\rA3&L\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1q\n\u001d;j_:\u0004\"A\f\u001b\u000e\u0003=R!\u0001M\u0019\u0002\r\u0005,Ho\\7m\u0015\t)!GC\u00014\u0003\t\t\u0017.\u0003\u00026_\ty\u0011)\u001e;p\u001b2\u0013U/\u001b7e'B,7\r\u0003\u00058\u0001\t\u0005\t\u0015!\u0003(\u0003A\tW\u000f^8nY\n+\u0018\u000e\u001c3Ta\u0016\u001c\u0007\u0005\u0003\u0005:\u0001\t\u0015\r\u0011\"\u0011;\u0003\r)\u0018\u000eZ\u000b\u0002wA\u0011Ah\u0010\b\u0003QuJ!AP\u0015\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}%B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IaO\u0001\u0005k&$\u0007\u0005\u0003\u0005F\u0001\t\u0005\t\u0015a\u0003G\u0003\tA7\r\u0005\u0002H\u00136\t\u0001J\u0003\u0002\u0006\u0011%\u0011!\n\u0013\u0002\u000b\u0011Jz5i\u001c8uKb$\b\u0002\u0003'\u0001\u0005\u0003\u0005\u000b1B'\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\u0011\u0005\u00191/\u001d7\n\u0005I{%AC*R\u0019\u000e{g\u000e^3yi\")A\u000b\u0001C\u0001+\u00061A(\u001b8jiz\"2A\u0016.\\)\r9\u0006,\u0017\t\u0003C\u0001AQ!R*A\u0004\u0019CQ\u0001T*A\u00045CQ!J*A\u0002\u001dBQ!O*A\u0002mBQ\u0001\u0016\u0001\u0005\u0002u#\u0012A\u0018\u000b\u0004/~\u0003\u0007\"B#]\u0001\b1\u0005\"\u0002']\u0001\bi\u0005\"\u0002+\u0001\t\u0003\u0011G\u0003B,dI\u0016DQ!O1A\u0002mBQ!R1A\u0002\u0019CQ\u0001T1A\u00025Cqa\u001a\u0001A\u0002\u0013\u0005\u0001.A\u0006mK\u0006$WM\u001d2pCJ$W#A5\u0011\u0007!Z#\u000e\u0005\u0002ls:\u0011An\u001e\b\u0003[Zt!A\\;\u000f\u0005=$hB\u00019t\u001b\u0005\t(B\u0001:\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003!\"I!\u0001_(\u0002\u000fA\f7m[1hK&\u0011!p\u001f\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001_(\t\u000fu\u0004\u0001\u0019!C\u0001}\u0006yA.Z1eKJ\u0014w.\u0019:e?\u0012*\u0017\u000fF\u0002\u0000\u0003\u000b\u00012\u0001KA\u0001\u0013\r\t\u0019!\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\bq\f\t\u00111\u0001j\u0003\rAH%\r\u0005\b\u0003\u0017\u0001\u0001\u0015)\u0003j\u00031aW-\u00193fe\n|\u0017M\u001d3!\u0011\u001d\ty\u0001\u0001C!\u0003#\t1AZ5u)\r!\u00121\u0003\u0005\t\u0003+\ti\u00011\u0001\u0002\u0018\u00059A-\u0019;bg\u0016$\b\u0007BA\r\u0003G\u0001RATA\u000e\u0003?I1!!\bP\u0005\u001d!\u0015\r^1tKR\u0004B!!\t\u0002$1\u0001A\u0001DA\u0013\u0003'\t\t\u0011!A\u0003\u0002\u0005\u001d\"aA0%cE!\u0011\u0011FA\u0018!\rA\u00131F\u0005\u0004\u0003[I#a\u0002(pi\"Lgn\u001a\t\u0004Q\u0005E\u0012bAA\u001aS\t\u0019\u0011I\\=\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u00059B.Z1eKJ\u0014w.\u0019:e\u0003N\u001c\u0006/\u0019:l\rJ\fW.\u001a\u000b\u0004S\u0006m\u0002\u0002CA\u001f\u0003k\u0001\r!a\u0010\u0002\u0007\u0005lG\u000eE\u0002/\u0003\u0003J1!a\u00110\u0005\u0019\tU\u000f^8N\u0019\"9\u0011q\t\u0001\u0005\u0002\u0005%\u0013A\u0003;sC&tWj\u001c3fYR\u0019A#a\u0013\t\u0011\u0005u\u0012Q\ta\u0001\u0003\u007fAq!a\u0014\u0001\t\u0003\n\t&A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t\u0019&a\u0018\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017P\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti&a\u0016\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0002b\u00055\u0003\u0019AA*\u0003\u0019\u00198\r[3nC\"\"\u0011QJA3!\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0014\u0011\u000e\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0005\b\u0003g\u0002A\u0011IA;\u0003\u0011\u0019w\u000e]=\u0015\t\u0005]\u0014\u0011P\u0007\u0002\u0001!A\u00111PA9\u0001\u0004\ti(A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019IB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0005QCJ\fW.T1q\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000bQa\u001e:ji\u0016,\"!a$\u0011\u0007m\t\t*C\u0002\u0002\u0014r\u0011\u0001\"\u0014'Xe&$XM\u001d\u0015\u0007\u0003\u0013\u000b9*!(\u0011\t\u0005\u001d\u0014\u0011T\u0005\u0005\u00037\u000bIGA\u0003TS:\u001cW-\t\u0002\u0002 \u0006)\u0011G\f\u001c/a!1\u00111\u0015\u0001\u0005\u0002i\nq\u0002Z3gCVdGOR5mK:\u000bW.Z\u0004\b\u0003O\u0013\u0001\u0012AAU\u0003%A%gT!vi>lE\nE\u0002\"\u0003W3a!\u0001\u0002\t\u0002\u000556\u0003CAV\u0003_\u000b),a/\u0011\u0007!\n\t,C\u0002\u00024&\u0012a!\u00118z%\u00164\u0007\u0003B\u000e\u00028^K1!!/\u001d\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0004Q\u0005u\u0016bAA`S\ta1+\u001a:jC2L'0\u00192mK\"9A+a+\u0005\u0002\u0005\rGCAAU\u0011)\t\u0019+a+C\u0002\u00135\u0011qY\u000b\u0003\u0003\u0013|!!a3\"\u0005\u00055\u0017!D1vi>lGn\u00189be\u0006l7\u000fC\u0005\u0002R\u0006-\u0006\u0015!\u0004\u0002J\u0006\u0001B-\u001a4bk2$h)\u001b7f\u001d\u0006lW\r\t\u0005\t\u0003+\fY\u000b\"\u0011\u0002X\u0006!!/Z1e+\t\tI\u000e\u0005\u0003\u001c\u00037<\u0016bAAo9\tAQ\n\u0014*fC\u0012,'\u000f\u000b\u0004\u0002T\u0006]\u0015Q\u0014\u0005\t\u0003G\fY\u000b\"\u0011\u0002f\u0006!An\\1e)\r9\u0016q\u001d\u0005\b\u0003S\f\t\u000f1\u0001<\u0003\u0011\u0001\u0018\r\u001e5)\r\u0005\u0005\u0018qSAO\u0011)\ty/a+\u0002\u0002\u0013%\u0011\u0011_\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002tB!\u0011Q_A\u0000\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018\u0001\u00027b]\u001eT!!!@\u0002\t)\fg/Y\u0005\u0005\u0005\u0003\t9P\u0001\u0004PE*,7\r\u001e")
public class H2OAutoML
extends Estimator<H2OMOJOModel>
implements MLWritable,
H2OAutoMLParams {
    private final Option<AutoMLBuildSpec> automlBuildSpec;
    private final String uid;
    private final H2OContext hc;
    private Option<Dataset<Row>> leaderboard;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical;
    private final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn;
    private final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns;
    private final H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance;
    private final H2OAutoMLStoppingMetricParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses;
    private final NullableFloatArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors;
    private final FloatParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels;

    public static H2OAutoML load(String string) {
        return H2OAutoML$.MODULE$.load(string);
    }

    public static MLReader<H2OAutoML> read() {
        return H2OAutoML$.MODULE$.read();
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical;
    }

    @Override
    public final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical;
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn;
    }

    @Override
    public final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns;
    }

    @Override
    public final H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName;
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds;
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance;
    }

    @Override
    public final H2OAutoMLStoppingMetricParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses;
    }

    @Override
    public final NullableFloatArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors;
    }

    @Override
    public final FloatParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical_$eq(StringArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns_$eq(StringArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos_$eq(H2OAutoMLAlgosParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric_$eq(H2OAutoMLStoppingMetricParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors_$eq(NullableFloatArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize_$eq(FloatParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels = x$1;
    }

    @Override
    public String getPredictionCol() {
        return H2OAutoMLParams$class.getPredictionCol(this);
    }

    @Override
    public boolean getAllStringColumnsToCategorical() {
        return H2OAutoMLParams$class.getAllStringColumnsToCategorical(this);
    }

    @Override
    public String[] getColumnsToCategorical() {
        return H2OAutoMLParams$class.getColumnsToCategorical(this);
    }

    @Override
    public double getRatio() {
        return H2OAutoMLParams$class.getRatio(this);
    }

    @Override
    public String getFoldColumn() {
        return H2OAutoMLParams$class.getFoldColumn(this);
    }

    @Override
    public String getWeightsColumn() {
        return H2OAutoMLParams$class.getWeightsColumn(this);
    }

    @Override
    public String[] getIgnoredColumns() {
        return H2OAutoMLParams$class.getIgnoredColumns(this);
    }

    @Override
    public Algo[] getExcludeAlgos() {
        return H2OAutoMLParams$class.getExcludeAlgos(this);
    }

    @Override
    public String getProjectName() {
        return H2OAutoMLParams$class.getProjectName(this);
    }

    @Override
    public double getMaxRuntimeSecs() {
        return H2OAutoMLParams$class.getMaxRuntimeSecs(this);
    }

    @Override
    public int getStoppingRounds() {
        return H2OAutoMLParams$class.getStoppingRounds(this);
    }

    @Override
    public double getStoppingTolerance() {
        return H2OAutoMLParams$class.getStoppingTolerance(this);
    }

    @Override
    public ScoreKeeper.StoppingMetric getStoppingMetric() {
        return H2OAutoMLParams$class.getStoppingMetric(this);
    }

    @Override
    public int getNfolds() {
        return H2OAutoMLParams$class.getNfolds(this);
    }

    @Override
    public boolean getConvertUnknownCategoricalLevelsToNa() {
        return H2OAutoMLParams$class.getConvertUnknownCategoricalLevelsToNa(this);
    }

    @Override
    public int getSeed() {
        return H2OAutoMLParams$class.getSeed(this);
    }

    @Override
    public String getSortMetric() {
        return H2OAutoMLParams$class.getSortMetric(this);
    }

    @Override
    public boolean getBalanceClasses() {
        return H2OAutoMLParams$class.getBalanceClasses(this);
    }

    @Override
    public float[] getClassSamplingFactors() {
        return H2OAutoMLParams$class.getClassSamplingFactors(this);
    }

    @Override
    public float getMaxAfterBalanceSize() {
        return H2OAutoMLParams$class.getMaxAfterBalanceSize(this);
    }

    @Override
    public boolean getKeepCrossValidationPredictions() {
        return H2OAutoMLParams$class.getKeepCrossValidationPredictions(this);
    }

    @Override
    public boolean getKeepCrossValidationModels() {
        return H2OAutoMLParams$class.getKeepCrossValidationModels(this);
    }

    @Override
    public int getMaxModels() {
        return H2OAutoMLParams$class.getMaxModels(this);
    }

    @Override
    public H2OAutoMLParams setPredictionCol(String value) {
        return H2OAutoMLParams$class.setPredictionCol(this, value);
    }

    @Override
    public H2OAutoMLParams setAllStringColumnsToCategorical(boolean value) {
        return H2OAutoMLParams$class.setAllStringColumnsToCategorical(this, value);
    }

    @Override
    public H2OAutoMLParams setColumnsToCategorical(String first, Seq<String> others) {
        return H2OAutoMLParams$class.setColumnsToCategorical(this, first, others);
    }

    @Override
    public H2OAutoMLParams setColumnsToCategorical(String[] columns) {
        return H2OAutoMLParams$class.setColumnsToCategorical(this, columns);
    }

    @Override
    public H2OAutoMLParams setRatio(double value) {
        return H2OAutoMLParams$class.setRatio(this, value);
    }

    @Override
    public H2OAutoMLParams setFoldColumn(String value) {
        return H2OAutoMLParams$class.setFoldColumn(this, value);
    }

    @Override
    public H2OAutoMLParams setWeightsColumn(String value) {
        return H2OAutoMLParams$class.setWeightsColumn(this, value);
    }

    @Override
    public H2OAutoMLParams setIgnoredColumns(String[] value) {
        return H2OAutoMLParams$class.setIgnoredColumns(this, value);
    }

    @Override
    public H2OAutoMLParams setExcludeAlgos(Algo[] value) {
        return H2OAutoMLParams$class.setExcludeAlgos(this, value);
    }

    @Override
    public H2OAutoMLParams setProjectName(String value) {
        return H2OAutoMLParams$class.setProjectName(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxRuntimeSecs(double value) {
        return H2OAutoMLParams$class.setMaxRuntimeSecs(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingRounds(int value) {
        return H2OAutoMLParams$class.setStoppingRounds(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingTolerance(double value) {
        return H2OAutoMLParams$class.setStoppingTolerance(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingMetric(ScoreKeeper.StoppingMetric value) {
        return H2OAutoMLParams$class.setStoppingMetric(this, value);
    }

    @Override
    public H2OAutoMLParams setNfolds(int value) {
        return H2OAutoMLParams$class.setNfolds(this, value);
    }

    @Override
    public H2OAutoMLParams setConvertUnknownCategoricalLevelsToNa(boolean value) {
        return H2OAutoMLParams$class.setConvertUnknownCategoricalLevelsToNa(this, value);
    }

    @Override
    public H2OAutoMLParams setSeed(int value) {
        return H2OAutoMLParams$class.setSeed(this, value);
    }

    @Override
    public H2OAutoMLParams setSortMetric(String value) {
        return H2OAutoMLParams$class.setSortMetric(this, value);
    }

    @Override
    public H2OAutoMLParams setBalanceClasses(boolean value) {
        return H2OAutoMLParams$class.setBalanceClasses(this, value);
    }

    @Override
    public H2OAutoMLParams setClassSamplingFactors(float[] value) {
        return H2OAutoMLParams$class.setClassSamplingFactors(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxAfterBalanceSize(float value) {
        return H2OAutoMLParams$class.setMaxAfterBalanceSize(this, value);
    }

    @Override
    public H2OAutoMLParams setKeepCrossValidationPredictions(boolean value) {
        return H2OAutoMLParams$class.setKeepCrossValidationPredictions(this, value);
    }

    @Override
    public H2OAutoMLParams setKeepCrossValidationModels(boolean value) {
        return H2OAutoMLParams$class.setKeepCrossValidationModels(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxModels(int value) {
        return H2OAutoMLParams$class.setMaxModels(this, value);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    public Option<AutoMLBuildSpec> automlBuildSpec() {
        return this.automlBuildSpec;
    }

    public String uid() {
        return this.uid;
    }

    public Option<Dataset<Row>> leaderboard() {
        return this.leaderboard;
    }

    public void leaderboard_$eq(Option<Dataset<Row>> x$1) {
        this.leaderboard = x$1;
    }

    public H2OMOJOModel fit(Dataset<?> dataset) {
        AutoMLBuildSpec spec = (AutoMLBuildSpec)this.automlBuildSpec().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AutoMLBuildSpec apply() {
                return new AutoMLBuildSpec();
            }
        });
        Object object = this.getProjectName() == null ? this.setProjectName(Random$.MODULE$.alphanumeric().take(30).toString()) : BoxedUnit.UNIT;
        H2OFrame input = this.hc.asH2OFrame(dataset.toDF());
        if (this.getRatio() < 1.0) {
            Frame[] keys = H2OFrameSupport$.MODULE$.split((Frame)input, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Key.rand(), Key.rand()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.getRatio()})));
            spec.input_spec.training_frame = keys[0]._key;
            if (keys.length > 1) {
                spec.input_spec.validation_frame = keys[1]._key;
            }
        } else {
            spec.input_spec.training_frame = input._key;
        }
        Frame trainFrame = (Frame)spec.input_spec.training_frame.get();
        Object object2 = this.getAllStringColumnsToCategorical() ? H2OFrameSupport$.MODULE$.allStringVecToCategorical(trainFrame) : BoxedUnit.UNIT;
        H2OFrameSupport$.MODULE$.columnsToCategorical(trainFrame, this.getColumnsToCategorical());
        spec.input_spec.response_column = this.getPredictionCol();
        spec.input_spec.fold_column = this.getFoldColumn();
        spec.input_spec.weights_column = this.getWeightsColumn();
        spec.input_spec.ignored_columns = this.getIgnoredColumns();
        spec.input_spec.sort_metric = this.getSortMetric();
        spec.build_models.exclude_algos = this.getExcludeAlgos() == null ? null : (AutoML.algo[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((AutoML.algo[])this.getExcludeAlgos())), ClassTag$.MODULE$.apply(AutoML.algo.class));
        spec.build_control.project_name = this.getProjectName();
        spec.build_control.stopping_criteria.set_seed((long)this.getSeed());
        spec.build_control.stopping_criteria.set_max_runtime_secs(this.getMaxRuntimeSecs());
        spec.build_control.stopping_criteria.set_stopping_rounds(this.getStoppingRounds());
        spec.build_control.stopping_criteria.set_stopping_tolerance(this.getStoppingTolerance());
        spec.build_control.stopping_criteria.set_stopping_metric(this.getStoppingMetric());
        spec.build_control.stopping_criteria.set_max_models(this.getMaxModels());
        spec.build_control.nfolds = this.getNfolds();
        spec.build_control.balance_classes = this.getBalanceClasses();
        spec.build_control.class_sampling_factors = this.getClassSamplingFactors();
        spec.build_control.max_after_balance_size = this.getMaxAfterBalanceSize();
        spec.build_control.keep_cross_validation_predictions = this.getKeepCrossValidationPredictions();
        spec.build_control.keep_cross_validation_models = this.getKeepCrossValidationModels();
        DKV.put((Keyed)trainFrame);
        AutoML aml = new AutoML(Key.make((String)this.uid()), new Date(), spec);
        AutoML.startAutoML((AutoML)aml);
        aml.get();
        this.leaderboard_$eq(this.leaderboardAsSparkFrame(aml));
        H2OMOJOModel model = this.trainModel(aml);
        model.setConvertUnknownCategoricalLevelsToNa(true);
        return model;
    }

    private Option<Dataset<Row>> leaderboardAsSparkFrame(AutoML aml) {
        TwoDimTable twoDimtable = aml.leaderboard().toTwoDimTable();
        String[] colNames = twoDimtable.getColHeaders();
        String[][] data = (String[][])Predef$.MODULE$.refArrayOps((Object[])aml.leaderboard().toTwoDimTable().getCellValues()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(IcedWrapper[] x$1) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])x$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(IcedWrapper x$2) {
                        return x$2.toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        Row[] rows = (Row[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(String[] x$3) {
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.wrapRefArray((Object[])x$3));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        StructType schema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])colNames).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String name) {
                return new StructField(name, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        RDD rdd = this.hc.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])rows), this.hc.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
        return new Some((Object)this.hc.sparkSession().createDataFrame(rdd, schema));
    }

    public H2OMOJOModel trainModel(AutoML aml) {
        return new H2OMOJOModel(ModelSerializationSupport$.MODULE$.getMojoData(aml.leader()));
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return schema;
    }

    public H2OAutoML copy(ParamMap extra) {
        return (H2OAutoML)this.defaultCopy(extra);
    }

    public MLWriter write() {
        return new H2OAutoMLWriter(this);
    }

    public String defaultFileName() {
        return "automl_params";
    }

    public H2OAutoML(Option<AutoMLBuildSpec> automlBuildSpec, String uid, H2OContext hc, SQLContext sqlContext) {
        this.automlBuildSpec = automlBuildSpec;
        this.uid = uid;
        this.hc = hc;
        MLWritable.class.$init$((MLWritable)this);
        H2OAutoMLParams$class.$init$(this);
        this.leaderboard = None$.MODULE$;
    }

    public H2OAutoML(H2OContext hc, SQLContext sqlContext) {
        this((Option<AutoMLBuildSpec>)None$.MODULE$, Identifiable$.MODULE$.randomUID("automl"), hc, sqlContext);
    }

    public H2OAutoML(String uid, H2OContext hc, SQLContext sqlContext) {
        this((Option<AutoMLBuildSpec>)None$.MODULE$, uid, hc, sqlContext);
    }
}

