/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import hex.StringPair;
import hex.deeplearning.DeepLearningModel;
import hex.glm.GLMModel;
import hex.schemas.GLMV3;
import org.apache.spark.ml.h2o.algos.H2OGLMFamilyParam;
import org.apache.spark.ml.h2o.algos.H2OGLMLinkParam;
import org.apache.spark.ml.h2o.algos.H2OGLMMissingValuesHandlingParam;
import org.apache.spark.ml.h2o.algos.H2OGLMParams;
import org.apache.spark.ml.h2o.algos.H2OGLMSolverParam;
import org.apache.spark.ml.h2o.algos.H2OGLMStringPairArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

public abstract class H2OGLMParams$class {
    public static ClassTag paramTag(H2OGLMParams $this) {
        return package$.MODULE$.classTag(ClassTag$.MODULE$.apply(GLMModel.GLMParameters.class));
    }

    public static ClassTag schemaTag(H2OGLMParams $this) {
        return package$.MODULE$.classTag(ClassTag$.MODULE$.apply(GLMV3.GLMParametersV3.class));
    }

    public static boolean getStandardize(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.standardize()));
    }

    public static GLMModel.GLMParameters.Family getFamily(H2OGLMParams $this) {
        return (GLMModel.GLMParameters.Family)$this.$($this.family());
    }

    public static GLMModel.GLMParameters.Link getLink(H2OGLMParams $this) {
        return (GLMModel.GLMParameters.Link)$this.$($this.link());
    }

    public static GLMModel.GLMParameters.Solver getSolver(H2OGLMParams $this) {
        return (GLMModel.GLMParameters.Solver)$this.$($this.solver());
    }

    public static double getTweedieVariancePower(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.tweedieVariancePower()));
    }

    public static double getTweedieLinkPower(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.tweedieLinkPower()));
    }

    public static double[] getAlpha(H2OGLMParams $this) {
        return (double[])$this.$($this.alpha());
    }

    public static double[] getLambda(H2OGLMParams $this) {
        return (double[])$this.$($this.lambda_());
    }

    public static DeepLearningModel.DeepLearningParameters.MissingValuesHandling getMissingValuesHandling(H2OGLMParams $this) {
        return (DeepLearningModel.DeepLearningParameters.MissingValuesHandling)$this.$($this.missingValuesHandling());
    }

    public static double getPrior(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.prior()));
    }

    public static boolean getLambdaSearch(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.lambdaSearch()));
    }

    public static int getNlambdas(H2OGLMParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.nlambdas()));
    }

    public static boolean getNonNegative(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.nonNegative()));
    }

    public static boolean getExactLambdas(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.exactLambdas()));
    }

    public static double getLambdaMinRatio(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.lambdaMinRatio()));
    }

    public static int getMaxIterations(H2OGLMParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.maxIterations()));
    }

    public static boolean getIntercept(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.intercept()));
    }

    public static double getBetaEpsilon(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.betaEpsilon()));
    }

    public static double getObjectiveEpsilon(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.objectiveEpsilon()));
    }

    public static double getGradientEpsilon(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.gradientEpsilon()));
    }

    public static double getObjReg(H2OGLMParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.objReg()));
    }

    public static boolean getComputePValues(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.computePValues()));
    }

    public static boolean getRemoteCollinearColumns(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.removeCollinearColumns()));
    }

    public static String[] getInteractions(H2OGLMParams $this) {
        return (String[])$this.$($this.interactions());
    }

    public static Tuple2[] getInteractionPairs(H2OGLMParams $this) {
        return (Tuple2[])$this.$($this.interactionPairs());
    }

    public static boolean getEarlyStopping(H2OGLMParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.earlyStopping()));
    }

    public static H2OGLMParams setStandardize(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.standardize(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setFamily(H2OGLMParams $this, GLMModel.GLMParameters.Family value) {
        return (H2OGLMParams)$this.set($this.family(), value);
    }

    public static H2OGLMParams setLink(H2OGLMParams $this, GLMModel.GLMParameters.Link value) {
        return (H2OGLMParams)$this.set($this.link(), value);
    }

    public static H2OGLMParams setSolver(H2OGLMParams $this, GLMModel.GLMParameters.Solver value) {
        return (H2OGLMParams)$this.set($this.solver(), value);
    }

    public static H2OGLMParams setTweedieVariancePower(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.tweedieVariancePower(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setTweedieLinkPower(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.tweedieLinkPower(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setAlpha(H2OGLMParams $this, double[] value) {
        return (H2OGLMParams)$this.set($this.alpha(), value);
    }

    public static H2OGLMParams setLambda(H2OGLMParams $this, double[] value) {
        return (H2OGLMParams)$this.set($this.lambda_(), value);
    }

    public static H2OGLMParams setMissingValuesHandling(H2OGLMParams $this, DeepLearningModel.DeepLearningParameters.MissingValuesHandling value) {
        return (H2OGLMParams)$this.set($this.missingValuesHandling(), value);
    }

    public static H2OGLMParams setPrior(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.prior(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setLambdaSearch(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.lambdaSearch(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setNlambdas(H2OGLMParams $this, int value) {
        return (H2OGLMParams)$this.set((Param)$this.nlambdas(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OGLMParams setNonNegative(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.nonNegative(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setExactLambdas(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.exactLambdas(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setLambdaMinRatio(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.lambdaMinRatio(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setMaxIterations(H2OGLMParams $this, int value) {
        return (H2OGLMParams)$this.set((Param)$this.maxIterations(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OGLMParams setIntercept(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.intercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setBetaEpsilon(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.betaEpsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setObjectiveEpsilon(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.objectiveEpsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setGradientEpsilon(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.gradientEpsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setObjReg(H2OGLMParams $this, double value) {
        return (H2OGLMParams)$this.set((Param)$this.objReg(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OGLMParams setComputePValues(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.computePValues(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setRemoteCollinearColumns(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.removeCollinearColumns(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OGLMParams setInteractions(H2OGLMParams $this, String[] value) {
        return (H2OGLMParams)$this.set($this.interactions(), value);
    }

    public static H2OGLMParams setInteractionPairs(H2OGLMParams $this, Tuple2[] value) {
        return (H2OGLMParams)$this.set($this.interactionPairs(), value);
    }

    public static H2OGLMParams setEarlyStopping(H2OGLMParams $this, boolean value) {
        return (H2OGLMParams)$this.set((Param)$this.earlyStopping(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static void updateH2OParams(H2OGLMParams $this) {
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$$super$updateH2OParams();
        ((GLMModel.GLMParameters)$this.parameters())._standardize = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.standardize()));
        ((GLMModel.GLMParameters)$this.parameters())._family = (GLMModel.GLMParameters.Family)$this.$($this.family());
        ((GLMModel.GLMParameters)$this.parameters())._link = (GLMModel.GLMParameters.Link)$this.$($this.link());
        ((GLMModel.GLMParameters)$this.parameters())._solver = (GLMModel.GLMParameters.Solver)$this.$($this.solver());
        ((GLMModel.GLMParameters)$this.parameters())._tweedie_variance_power = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.tweedieVariancePower()));
        ((GLMModel.GLMParameters)$this.parameters())._tweedie_link_power = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.tweedieLinkPower()));
        ((GLMModel.GLMParameters)$this.parameters())._alpha = (double[])$this.$($this.alpha());
        ((GLMModel.GLMParameters)$this.parameters())._lambda = (double[])$this.$($this.lambda_());
        ((GLMModel.GLMParameters)$this.parameters())._missing_values_handling = (DeepLearningModel.DeepLearningParameters.MissingValuesHandling)$this.$($this.missingValuesHandling());
        ((GLMModel.GLMParameters)$this.parameters())._prior = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.prior()));
        ((GLMModel.GLMParameters)$this.parameters())._lambda_search = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.lambdaSearch()));
        ((GLMModel.GLMParameters)$this.parameters())._nlambdas = BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.nlambdas()));
        ((GLMModel.GLMParameters)$this.parameters())._non_negative = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.nonNegative()));
        ((GLMModel.GLMParameters)$this.parameters())._exactLambdas = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.exactLambdas()));
        ((GLMModel.GLMParameters)$this.parameters())._lambda_min_ratio = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.lambdaMinRatio()));
        ((GLMModel.GLMParameters)$this.parameters())._max_iterations = BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.maxIterations()));
        ((GLMModel.GLMParameters)$this.parameters())._intercept = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.intercept()));
        ((GLMModel.GLMParameters)$this.parameters())._beta_epsilon = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.betaEpsilon()));
        ((GLMModel.GLMParameters)$this.parameters())._objective_epsilon = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.objectiveEpsilon()));
        ((GLMModel.GLMParameters)$this.parameters())._gradient_epsilon = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.gradientEpsilon()));
        ((GLMModel.GLMParameters)$this.parameters())._obj_reg = BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.objReg()));
        ((GLMModel.GLMParameters)$this.parameters())._compute_p_values = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.computePValues()));
        ((GLMModel.GLMParameters)$this.parameters())._remove_collinear_columns = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.removeCollinearColumns()));
        ((GLMModel.GLMParameters)$this.parameters())._interactions = (String[])$this.$($this.interactions());
        Tuple2[] pairs = (Tuple2[])$this.$($this.interactionPairs());
        ((GLMModel.GLMParameters)$this.parameters())._interaction_pairs = pairs == null ? null : (StringPair[])Predef$.MODULE$.refArrayOps((Object[])pairs).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final StringPair apply(Tuple2<String, String> v) {
                return new StringPair((String)v._1(), (String)v._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StringPair.class)));
        ((GLMModel.GLMParameters)$this.parameters())._early_stopping = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.earlyStopping()));
    }

    public static void $init$(H2OGLMParams $this) {
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$standardize_$eq($this.booleanParam("standardize", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$family_$eq(new H2OGLMFamilyParam($this, "family", "family"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$link_$eq(new H2OGLMLinkParam($this, "link", "link"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$solver_$eq(new H2OGLMSolverParam($this, "solver", "solver"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$tweedieVariancePower_$eq($this.doubleParam("tweedieVariancePower", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$tweedieLinkPower_$eq($this.doubleParam("tweedieLinkPower", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$alpha_$eq($this.nullableDoubleArrayParam("alpha", $this.nullableDoubleArrayParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$lambda__$eq($this.nullableDoubleArrayParam("lambda_", "lambda"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$missingValuesHandling_$eq(new H2OGLMMissingValuesHandlingParam($this, "missingValuesHandling", "missingValuesHandling"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$prior_$eq($this.doubleParam("prior", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$lambdaSearch_$eq($this.booleanParam("lambdaSearch", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$nlambdas_$eq($this.intParam("nlambdas", $this.intParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$nonNegative_$eq($this.booleanParam("nonNegative", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$exactLambdas_$eq($this.booleanParam("exactLambdas", "exact lambdas"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$lambdaMinRatio_$eq($this.doubleParam("lambdaMinRatio", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$maxIterations_$eq($this.intParam("maxIterations", $this.intParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$intercept_$eq($this.booleanParam("intercept", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$betaEpsilon_$eq($this.doubleParam("betaEpsilon", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$objectiveEpsilon_$eq($this.doubleParam("objectiveEpsilon", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$gradientEpsilon_$eq($this.doubleParam("gradientEpsilon", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$objReg_$eq($this.doubleParam("objReg", $this.doubleParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$computePValues_$eq($this.booleanParam("computePValues", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$removeCollinearColumns_$eq($this.booleanParam("removeCollinearColumns", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$interactions_$eq($this.nullableStringArrayParam("interactions", $this.nullableStringArrayParam$default$2()));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$interactionPairs_$eq(new H2OGLMStringPairArrayParam($this, "interactionPairs", "interactionPairs"));
        $this.org$apache$spark$ml$h2o$algos$H2OGLMParams$_setter_$earlyStopping_$eq($this.booleanParam("earlyStopping", $this.booleanParam$default$2()));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.standardize().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true)), $this.family().$minus$greater(GLMModel.GLMParameters.Family.gaussian), $this.link().$minus$greater(GLMModel.GLMParameters.Link.family_default), $this.solver().$minus$greater(GLMModel.GLMParameters.Solver.AUTO), $this.tweedieVariancePower().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.0)), $this.tweedieLinkPower().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.0)), $this.alpha().$minus$greater(null), $this.lambda_().$minus$greater(null), $this.missingValuesHandling().$minus$greater(DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation), $this.prior().$minus$greater((Object)BoxesRunTime.boxToDouble((double)-1.0)), $this.lambdaSearch().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.nlambdas().$minus$greater((Object)BoxesRunTime.boxToInteger((int)-1)), $this.nonNegative().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.exactLambdas().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.lambdaMinRatio().$minus$greater((Object)BoxesRunTime.boxToDouble((double)-1.0)), $this.maxIterations().$minus$greater((Object)BoxesRunTime.boxToInteger((int)-1)), $this.intercept().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true)), $this.betaEpsilon().$minus$greater((Object)BoxesRunTime.boxToDouble((double)1.0E-4)), $this.objectiveEpsilon().$minus$greater((Object)BoxesRunTime.boxToDouble((double)-1.0)), $this.gradientEpsilon().$minus$greater((Object)BoxesRunTime.boxToDouble((double)-1.0)), $this.objReg().$minus$greater((Object)BoxesRunTime.boxToDouble((double)-1.0)), $this.computePValues().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.removeCollinearColumns().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.interactions().$minus$greater(null), $this.interactionPairs().$minus$greater(null), $this.earlyStopping().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    }
}

