/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.ml.h2o.algos.H2OGridSearch;
import org.apache.spark.ml.h2o.algos.H2OGridSearchParams;
import org.apache.spark.ml.h2o.algos.H2OGridSearchReader$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0001\u0003\u0001\tq!a\u0005%3\u001f\u001e\u0013\u0018\u000eZ*fCJ\u001c\u0007NU3bI\u0016\u0014(BA\u0002\u0005\u0003\u0015\tGnZ8t\u0015\t)a!A\u0002ie=T!a\u0002\u0005\u0002\u00055d'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0016\u0005=A2C\u0001\u0001\u0011!\r\tBCF\u0007\u0002%)\u00111CB\u0001\u0005kRLG.\u0003\u0002\u0016%\tAQ\n\u0014*fC\u0012,'\u000f\u0005\u0002\u001811\u0001A!B\r\u0001\u0005\u0004Y\"!A!\u0004\u0001E\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\b\u001d>$\b.\u001b8h!\t\u0019C%D\u0001\u0003\u0013\t)#AA\u0007Ie=;%/\u001b3TK\u0006\u00148\r\u001b\u0005\tO\u0001\u0011)\u0019!C\u0001Q\u0005yA-\u001a4bk2$h)\u001b7f\u001d\u0006lW-F\u0001*!\tQSF\u0004\u0002\u001eW%\u0011AFH\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-=!A\u0011\u0007\u0001B\u0001B\u0003%\u0011&\u0001\teK\u001a\fW\u000f\u001c;GS2,g*Y7fA!A1\u0007\u0001B\u0002B\u0003-A'\u0001\u0006fm&$WM\\2fIE\u00022!\u000e\u001d\u0017\u001b\u00051$BA\u001c\u001f\u0003\u001d\u0011XM\u001a7fGRL!!\u000f\u001c\u0003\u0011\rc\u0017m]:UC\u001eDQa\u000f\u0001\u0005\u0002q\na\u0001P5oSRtDCA\u001fA)\tqt\bE\u0002$\u0001YAQa\r\u001eA\u0004QBQa\n\u001eA\u0002%BQA\u0011\u0001\u0005B\r\u000bA\u0001\\8bIR\u0011a\u0003\u0012\u0005\u0006\u000b\u0006\u0003\r!K\u0001\u0005a\u0006$\b\u000eC\u0003H\u0001\u0011%\u0001*\u0001\u0003nC.,WCA%M)\u0015QU+X0g)\tY%\u000b\u0005\u0002\u0018\u0019\u0012)QJ\u0012b\u0001\u001d\n\u00111\tV\t\u00039=\u0003\"!\b)\n\u0005Es\"aA!os\"91KRA\u0001\u0002\b!\u0016AC3wS\u0012,gnY3%eA\u0019Q\u0007O&\t\u000bY3\u0005\u0019A,\u0002!\u001d\u0014\u0018\u000eZ*fCJ\u001c\u0007\u000eU1sC6\u001c\bcA\u000fY5&\u0011\u0011L\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\rZ\u0016B\u0001/\u0003\u0005MA%gT$sS\u0012\u001cV-\u0019:dQB\u000b'/Y7t\u0011\u0015qf\t1\u0001*\u0003\r)\u0018\u000e\u001a\u0005\u0006A\u001a\u0003\r!Y\u0001\u000bQJz7i\u001c8uKb$\bC\u00012e\u001b\u0005\u0019'BA\u0003\t\u0013\t)7M\u0001\u0006Ie=\u001buN\u001c;fqRDQa\u001a$A\u0002!\f!b]9m\u0007>tG/\u001a=u!\tIG.D\u0001k\u0015\tY\u0007\"A\u0002tc2L!!\u001c6\u0003\u0015M\u000bFjQ8oi\u0016DHoB\u0003p\u0005!\u0005\u0001/A\nIe=;%/\u001b3TK\u0006\u00148\r\u001b*fC\u0012,'\u000f\u0005\u0002$c\u001a)\u0011A\u0001E\u0001eN\u0011\u0011o\u001d\t\u0003;QL!!\u001e\u0010\u0003\r\u0005s\u0017PU3g\u0011\u0015Y\u0014\u000f\"\u0001x)\u0005\u0001\b\"B=r\t\u0003Q\u0018AB2sK\u0006$X-\u0006\u0002|\u007fR\u0019A0a\u0002\u0015\u0007u\f\t\u0001E\u0002$\u0001y\u0004\"aF@\u0005\u000beA(\u0019A\u000e\t\u0013\u0005\r\u00010!AA\u0004\u0005\u0015\u0011AC3wS\u0012,gnY3%gA\u0019Q\u0007\u000f@\t\u000b\u001dB\b\u0019A\u0015")
public class H2OGridSearchReader<A extends H2OGridSearch>
extends MLReader<A> {
    private final String defaultFileName;
    private final ClassTag<A> evidence$1;

    public static <A extends H2OGridSearch> H2OGridSearchReader<A> create(String string, ClassTag<A> classTag) {
        return H2OGridSearchReader$.MODULE$.create(string, classTag);
    }

    public String defaultFileName() {
        return this.defaultFileName;
    }

    public A load(String path) {
        DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), DefaultParamsReader$.MODULE$.loadMetadata$default$3());
        Path inputPath = new Path(path, this.defaultFileName());
        FileSystem fs = inputPath.getFileSystem(this.sc().hadoopConfiguration());
        Path qualifiedInputPath = inputPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        ObjectInputStream ois = new ObjectInputStream((InputStream)fs.open(qualifiedInputPath));
        H2OGridSearchParams gridSearchParams = (H2OGridSearchParams)ois.readObject();
        H2OContext h2oContext = H2OContext$.MODULE$.ensure((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "H2OContext has to be started in order to use H2O pipelines elements.";
            }
        });
        H2OGridSearch algo2 = (H2OGridSearch)this.make((Option<H2OGridSearchParams>)Option$.MODULE$.apply((Object)gridSearchParams), metadata.uid(), h2oContext, this.sqlContext(), this.evidence$1);
        DefaultParamsReader$.MODULE$.getAndSetParams((Params)algo2, metadata, DefaultParamsReader$.MODULE$.getAndSetParams$default$3());
        return (A)algo2;
    }

    private <CT> CT make(Option<H2OGridSearchParams> gridSearchParams, String uid, H2OContext h2oContext, SQLContext sqlContext, ClassTag<CT> evidence$2) {
        Class aClass = ((ClassTag)Predef$.MODULE$.implicitly(evidence$2)).runtimeClass();
        Constructor ctor = aClass.getConstructor(Option.class, String.class, H2OContext.class, SQLContext.class);
        return (CT)ctor.newInstance(gridSearchParams, uid, h2oContext, sqlContext);
    }

    public H2OGridSearchReader(String defaultFileName, ClassTag<A> evidence$1) {
        this.defaultFileName = defaultFileName;
        this.evidence$1 = evidence$1;
    }
}

