/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.models;

import hex.Model;
import java.io.IOException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.h2o.models.H2OModelWriter;
import org.apache.spark.ml.h2o.param.H2OModelParams;
import org.apache.spark.ml.h2o.param.H2OModelParams$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Random$;
import water.fvec.Frame;
import water.fvec.H2OFrame;

@ScalaSignature(bytes="\u0006\u0001\u0005=d!B\u0001\u0003\u0003\u0003y!\u0001\u0003%3\u001f6{G-\u001a7\u000b\u0005\r!\u0011AB7pI\u0016d7O\u0003\u0002\u0006\r\u0005\u0019\u0001NM8\u000b\u0005\u001dA\u0011AA7m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0004!]\u00193\u0003\u0002\u0001\u0012\u0003\u001e\u00032AE\n\u0016\u001b\u00051\u0011B\u0001\u000b\u0007\u0005\u0015iu\u000eZ3m!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003M\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB!\u0011\u0005A\u000b#\u001b\u0005\u0011\u0001C\u0001\f$\t\u0015!\u0003A1\u0001&\u0005\u0005i\u0015C\u0001\u000e'a\u00119S\u0006N\u001c\u0011\u000b!ZCf\r\u001c\u000e\u0003%R\u0011AK\u0001\u0004Q\u0016D\u0018B\u0001\u000b*!\t1R\u0006B\u0005/G\u0005\u0005\t\u0011!B\u0001_\t\u0019q\fJ\u0019\u0012\u0005i\u0001\u0004CA\u000e2\u0013\t\u0011DDA\u0002B]f\u0004\"A\u0006\u001b\u0005\u0013U\u001a\u0013\u0011!A\u0001\u0006\u0003y#aA0%eA\u0011ac\u000e\u0003\nq\r\n\t\u0011!A\u0003\u0002e\u00121a\u0018\u00134#\tQ\"\b\u0005\u0002<}9\u0011\u0001\u0006P\u0005\u0003{%\nQ!T8eK2L!a\u0010!\u0003\r=+H\u000f];u\u0015\ti\u0014\u0006\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u0005)\u0001/\u0019:b[&\u0011ai\u0011\u0002\u000f\u0011JzUj\u001c3fYB\u000b'/Y7t!\tA5*D\u0001J\u0015\tQe!\u0001\u0003vi&d\u0017B\u0001'J\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\t\u001d\u0002\u0011)\u0019!C\u0001\u001f\u0006)Qn\u001c3fYV\t!\u0005\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003#\u0003\u0019iw\u000eZ3mA!A1\u000b\u0001B\u0001B\u0003%A+\u0001\u0006ie=\u001cuN\u001c;fqR\u0004\"!V,\u000e\u0003YS!!\u0002\u0005\n\u0005a3&A\u0003%3\u001f\u000e{g\u000e^3yi\"A!\f\u0001B\u0001B\u0003%1,\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u0005\u0002\u0007M\fH.\u0003\u0002a;\nQ1+\u0015'D_:$X\r\u001f;\t\u000b\t\u0004A\u0011A2\u0002\rqJg.\u001b;?)\u0011\u0001C-\u001a4\t\u000b9\u000b\u0007\u0019\u0001\u0012\t\u000bM\u000b\u0007\u0019\u0001+\t\u000bi\u000b\u0007\u0019A.\t\u000b!\u0004A\u0011I5\u0002\t\r|\u0007/\u001f\u000b\u0003+)DQa[4A\u00021\fQ!\u001a=ue\u0006\u0004\"!\\8\u000e\u00039T!\u0001\u0012\u0004\n\u0005At'\u0001\u0003)be\u0006lW*\u00199\t\u000bI\u0004A\u0011I:\u0002\u0013Q\u0014\u0018M\\:g_JlGc\u0001;\u0002\u000eA\u0019Q/a\u0002\u000f\u0007Y\f\u0019AD\u0002x\u0003\u0003q!\u0001_@\u000f\u0005ethB\u0001>~\u001b\u0005Y(B\u0001?\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003=\"I1!!\u0002^\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0003\u0002\f\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u000bi\u0006bBA\bc\u0002\u0007\u0011\u0011C\u0001\bI\u0006$\u0018m]3ua\u0011\t\u0019\"a\u0007\u0011\u000bq\u000b)\"!\u0007\n\u0007\u0005]QLA\u0004ECR\f7/\u001a;\u0011\u0007Y\tY\u0002B\u0006\u0002\u001e\u00055\u0011\u0011!A\u0001\u0006\u0003y#aA0%i!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005\u0015\u0012\u0011\u0007\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F/\u0002\u000bQL\b/Z:\n\t\u0005=\u0012\u0011\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\u001a\u0003?\u0001\r!!\n\u0002\rM\u001c\u0007.Z7bQ\u0011\ty\"a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\nYD\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000eC\u0004\u0002F\u0001!\t%a\u0012\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005%\u0003c\u0001%\u0002L%\u0019\u0011QJ%\u0003\u00115cuK]5uKJDc!a\u0011\u0002R\u0005]\u0003\u0003BA\u001d\u0003'JA!!\u0016\u0002<\t)1+\u001b8dK\u0006\u0012\u0011\u0011L\u0001\u0006c92d\u0006\r\u0005\b\u0003;\u0002a\u0011AA0\u0003=!WMZ1vYR4\u0015\u000e\\3OC6,WCAA1!\u0011\t\u0019'!\u001b\u000f\u0007m\t)'C\u0002\u0002hq\ta\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003[\u0012aa\u0015;sS:<'bAA49\u0001")
public abstract class H2OModel<S extends H2OModel<S, M>, M extends hex.Model<?, ?, ? extends Model.Output>>
extends Model<S>
implements H2OModelParams,
MLWritable {
    private final M model;
    private final H2OContext h2oContext;
    private final SQLContext sqlContext;
    private final Param<String> predictionCol;
    private final StringArrayParam featuresCols;
    private final Param<String> outputCol;
    private final BooleanParam convertUnknownCategoricalLevelsToNa;

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final StringArrayParam featuresCols() {
        return this.featuresCols;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final BooleanParam convertUnknownCategoricalLevelsToNa() {
        return this.convertUnknownCategoricalLevelsToNa;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OModelParams$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OModelParams$_setter_$featuresCols_$eq(StringArrayParam x$1) {
        this.featuresCols = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OModelParams$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OModelParams$_setter_$convertUnknownCategoricalLevelsToNa_$eq(BooleanParam x$1) {
        this.convertUnknownCategoricalLevelsToNa = x$1;
    }

    @Override
    public String getPredictionsCol() {
        return H2OModelParams$class.getPredictionsCol(this);
    }

    @Override
    public String[] getFeaturesCols() {
        return H2OModelParams$class.getFeaturesCols(this);
    }

    @Override
    public String getOutputCol() {
        return H2OModelParams$class.getOutputCol(this);
    }

    @Override
    public boolean getConvertUnknownCategoricalLevelsToNa() {
        return H2OModelParams$class.getConvertUnknownCategoricalLevelsToNa(this);
    }

    @Override
    public H2OModelParams setFeaturesCols(String[] cols) {
        return H2OModelParams$class.setFeaturesCols(this, cols);
    }

    @Override
    public H2OModelParams setPredictionCol(String value) {
        return H2OModelParams$class.setPredictionCol(this, value);
    }

    @Override
    public H2OModelParams setOutputCol(String value) {
        return H2OModelParams$class.setOutputCol(this, value);
    }

    @Override
    public H2OModelParams setConvertUnknownCategoricalLevelsToNa(boolean value) {
        return H2OModelParams$class.setConvertUnknownCategoricalLevelsToNa(this, value);
    }

    public M model() {
        return this.model;
    }

    public S copy(ParamMap extra) {
        return (S)((H2OModel)this.defaultCopy(extra));
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        String tempId = Random$.MODULE$.alphanumeric().take(20).mkString("");
        Dataset datasetWithId = dataset.withColumn(tempId, functions$.MODULE$.monotonically_increasing_id());
        Column[] cols = (Column[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.featuresCols())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{tempId}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        H2OFrame frame = this.h2oContext.asH2OFrame(datasetWithId.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])cols)).toDF());
        Frame ids = frame.extractFrame(frame._names.length - 1, frame._names.length);
        Frame frameNoId = frame.extractFrame(0, frame._names.length - 1);
        Frame prediction = this.model().score(frameNoId);
        Frame predictionIds = prediction.add(ids);
        predictionIds.update();
        Dataset predictionsSpark = this.h2oContext.asDataFrame(predictionIds, this.h2oContext.asDataFrame$default$2(), this.sqlContext);
        return datasetWithId.join(predictionsSpark, tempId).drop(tempId);
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        int ncols = ((hex.Model)this.model())._output.nclasses() == 1 ? 1 : ((hex.Model)this.model())._output.nclasses() + 1;
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((hex.Model)this.model())._output._names).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String name) {
                return new StructField(name, (DataType)DoubleType$.MODULE$, true, null);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public MLWriter write() {
        return new H2OModelWriter<H2OModel>(this);
    }

    public abstract String defaultFileName();

    public H2OModel(M model, H2OContext h2oContext, SQLContext sqlContext) {
        this.model = model;
        this.h2oContext = h2oContext;
        this.sqlContext = sqlContext;
        H2OModelParams$class.$init$(this);
        MLWritable.class.$init$((MLWritable)this);
    }
}

