/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.AutoMLBuildSpec;
import hex.Model;
import hex.ScoreKeeper;
import java.io.IOException;
import java.util.Date;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.h2o.algos.H2OAlgorithmCommons;
import org.apache.spark.ml.h2o.algos.H2OAlgorithmCommons$class;
import org.apache.spark.ml.h2o.algos.H2OAutoML$;
import org.apache.spark.ml.h2o.algos.H2OAutoMLAlgosParam;
import org.apache.spark.ml.h2o.algos.H2OAutoMLParams;
import org.apache.spark.ml.h2o.algos.H2OAutoMLParams$class;
import org.apache.spark.ml.h2o.models.H2OMOJOModel;
import org.apache.spark.ml.h2o.models.H2OMOJOModel$;
import org.apache.spark.ml.h2o.models.H2OMOJOSettings;
import org.apache.spark.ml.h2o.models.H2OMOJOSettings$;
import org.apache.spark.ml.h2o.param.DeprecatableParams$class;
import org.apache.spark.ml.h2o.param.H2OCommonParams;
import org.apache.spark.ml.h2o.param.H2OCommonParams$class;
import org.apache.spark.ml.h2o.param.NullableFloatArrayParam;
import org.apache.spark.ml.h2o.param.NullableStringParam;
import org.apache.spark.ml.h2o.param.StoppingMetricParam;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.FloatParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import scala.util.control.NoStackTrace;
import water.DKV;
import water.IcedWrapper;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.support.H2OFrameSupport$;
import water.support.ModelSerializationSupport$;
import water.util.TwoDimTable;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001=\u0011\u0011\u0002\u0013\u001aP\u0003V$x.\u0014'\u000b\u0005\r!\u0011!B1mO>\u001c(BA\u0003\u0007\u0003\rA'g\u001c\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!iqB\u0005E\u0002\u0012%Qi\u0011AB\u0005\u0003'\u0019\u0011\u0011\"R:uS6\fGo\u001c:\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011AB7pI\u0016d7/\u0003\u0002\u001a-\ta\u0001JM(N\u001f*{Uj\u001c3fYB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u0014\u0011Jz\u0015\t\\4pe&$\b.\\\"p[6|gn\u001d\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0019\tA!\u001e;jY&\u00111\u0005\t\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f!\tYR%\u0003\u0002'\u0005\ty\u0001JM(BkR|W\n\u0014)be\u0006l7\u000f\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0011*\u0003\r)\u0018\u000eZ\u000b\u0002UA\u00111&\r\b\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'L\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021[!AQ\u0007\u0001B\u0001B\u0003%!&\u0001\u0003vS\u0012\u0004\u0003\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0002:uA\u00111\u0004\u0001\u0005\u0006QY\u0002\rA\u000b\u0005\t\u0013\u0001A)\u0019!C\u0005yU\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A\u0011\u0005\u00191/\u001d7\n\u0005\t{$\u0001D*qCJ\\7+Z:tS>t\u0007\u0002\u0003#\u0001\u0011\u0003\u0005\u000b\u0015B\u001f\u0002\rM\u0004\u0018M]6!\u0011\u00159\u0004\u0001\"\u0001G)\u0005I\u0004b\u0002%\u0001\u0001\u0004%\t!S\u0001\fY\u0016\fG-\u001a:c_\u0006\u0014H-F\u0001K!\ra3*T\u0005\u0003\u00196\u0012aa\u00149uS>t\u0007C\u0001(]\u001d\ty%L\u0004\u0002Q3:\u0011\u0011\u000b\u0017\b\u0003%^s!a\u0015,\u000e\u0003QS!!\u0016\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002A\u0011%\u00111lP\u0001\ba\u0006\u001c7.Y4f\u0013\tifLA\u0005ECR\fgI]1nK*\u00111l\u0010\u0005\bA\u0002\u0001\r\u0011\"\u0001b\u0003=aW-\u00193fe\n|\u0017M\u001d3`I\u0015\fHC\u00012f!\ta3-\u0003\u0002e[\t!QK\\5u\u0011\u001d1w,!AA\u0002)\u000b1\u0001\u001f\u00132\u0011\u0019A\u0007\u0001)Q\u0005\u0015\u0006aA.Z1eKJ\u0014w.\u0019:eA!)!\u000e\u0001C!W\u0006\u0019a-\u001b;\u0015\u0005Qa\u0007\"B7j\u0001\u0004q\u0017a\u00023bi\u0006\u001cX\r\u001e\u0019\u0003_R\u00042A\u00109s\u0013\t\txHA\u0004ECR\f7/\u001a;\u0011\u0005M$H\u0002\u0001\u0003\nk2\f\t\u0011!A\u0003\u0002Y\u00141a\u0018\u00132#\t9(\u0010\u0005\u0002-q&\u0011\u00110\f\u0002\b\u001d>$\b.\u001b8h!\ta30\u0003\u0002}[\t\u0019\u0011I\\=\t\u000by\u0004A\u0011B@\u0002/1,\u0017\rZ3sE>\f'\u000fZ!t'B\f'o\u001b$sC6,Gc\u0001&\u0002\u0002!9\u00111A?A\u0002\u0005\u0015\u0011aA1nYB!\u0011qAA\n\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011AB1vi>lGNC\u0002\u0006\u0003\u001fQ!!!\u0005\u0002\u0005\u0005L\u0017\u0002BA\u000b\u0003\u0013\u0011a!Q;u_6c\u0005bBA\r\u0001\u0011\u0005\u00131D\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011QDA\u0015!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\u007f\u0005)A/\u001f9fg&!\u0011qEA\u0011\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0003W\t9\u00021\u0001\u0002\u001e\u000511o\u00195f[\u0006DC!a\u0006\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026!\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI$a\r\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\u0005!1m\u001c9z)\u0011\t\t%a\u0011\u000e\u0003\u0001A\u0001\"!\u0012\u0002<\u0001\u0007\u0011qI\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n\u0004\u0002\u000bA\f'/Y7\n\t\u0005E\u00131\n\u0002\t!\u0006\u0014\u0018-\\'ba\u001e9\u0011Q\u000b\u0002\t\u0002\u0005]\u0013!\u0003%3\u001f\u0006+Ho\\'M!\rY\u0012\u0011\f\u0004\u0007\u0003\tA\t!a\u0017\u0014\u0011\u0005e\u0013QLA2\u0003o\u00022\u0001LA0\u0013\r\t\t'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u000b}\t)'!\u001b\n\u0007\u0005\u001d\u0004EA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[R1aAA8\u0015\r9\u0011\u0011\u000f\u0006\u0003\u0003g\nA\u0002]=`gB\f'o\u001b7j]\u001eL1!AA7!\ra\u0013\u0011P\u0005\u0004\u0003wj#\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u001c\u0002Z\u0011\u0005\u0011q\u0010\u000b\u0003\u0003/B!\"a!\u0002Z\u0005\u0005I\u0011BAC\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u001d\u0005\u0003BAE\u0003'k!!a#\u000b\t\u00055\u0015qR\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0012\u0006!!.\u0019<b\u0013\u0011\t)*a#\u0003\r=\u0013'.Z2u\u0001")
public class H2OAutoML
extends Estimator<H2OMOJOModel>
implements H2OAlgorithmCommons,
DefaultParamsWritable,
H2OAutoMLParams {
    private final String uid;
    private SparkSession spark;
    private Option<Dataset<Row>> leaderboard;
    private final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredCols;
    private final H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$includeAlgos;
    private final H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance;
    private final StoppingMetricParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses;
    private final NullableFloatArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors;
    private final FloatParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels;
    private final StringArrayParam featuresCols;
    private final Param<String> labelCol;
    private final NullableStringParam foldCol;
    private final NullableStringParam weightCol;
    private final DoubleParam splitRatio;
    private final LongParam seed;
    private final IntParam nfolds;
    private final BooleanParam allStringColumnsToCategorical;
    private final StringArrayParam columnsToCategorical;
    private final BooleanParam convertUnknownCategoricalLevelsToNa;
    private final BooleanParam convertInvalidNumbersToNa;
    private volatile boolean bitmap$0;

    public static Object load(String string) {
        return H2OAutoML$.MODULE$.load(string);
    }

    public static MLReader<py_sparkling.ml.algos.H2OAutoML> read() {
        return H2OAutoML$.MODULE$.read();
    }

    private SparkSession spark$lzycompute() {
        H2OAutoML h2OAutoML = this;
        synchronized (h2OAutoML) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().getOrCreate();
                this.bitmap$0 = true;
            }
            return this.spark;
        }
    }

    @Override
    public StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredCols() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredCols;
    }

    @Override
    public H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$includeAlgos() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$includeAlgos;
    }

    @Override
    public H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos;
    }

    @Override
    public NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName;
    }

    @Override
    public DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs;
    }

    @Override
    public IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds;
    }

    @Override
    public DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance;
    }

    @Override
    public StoppingMetricParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric;
    }

    @Override
    public NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric;
    }

    @Override
    public BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses;
    }

    @Override
    public NullableFloatArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors;
    }

    @Override
    public FloatParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize;
    }

    @Override
    public BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions;
    }

    @Override
    public BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels;
    }

    @Override
    public IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredCols_$eq(StringArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredCols = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$includeAlgos_$eq(H2OAutoMLAlgosParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$includeAlgos = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos_$eq(H2OAutoMLAlgosParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric_$eq(StoppingMetricParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors_$eq(NullableFloatArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize_$eq(FloatParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels = x$1;
    }

    @Override
    public void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxModels = x$1;
    }

    @Override
    public Map<String, String> renamingMap() {
        return H2OAutoMLParams$class.renamingMap(this);
    }

    @Override
    public String[] getIgnoredCols() {
        return H2OAutoMLParams$class.getIgnoredCols(this);
    }

    @Override
    public Algo[] getIncludeAlgos() {
        return H2OAutoMLParams$class.getIncludeAlgos(this);
    }

    @Override
    public Algo[] getExcludeAlgos() {
        return H2OAutoMLParams$class.getExcludeAlgos(this);
    }

    @Override
    public String getProjectName() {
        return H2OAutoMLParams$class.getProjectName(this);
    }

    @Override
    public double getMaxRuntimeSecs() {
        return H2OAutoMLParams$class.getMaxRuntimeSecs(this);
    }

    @Override
    public int getStoppingRounds() {
        return H2OAutoMLParams$class.getStoppingRounds(this);
    }

    @Override
    public double getStoppingTolerance() {
        return H2OAutoMLParams$class.getStoppingTolerance(this);
    }

    @Override
    public ScoreKeeper.StoppingMetric getStoppingMetric() {
        return H2OAutoMLParams$class.getStoppingMetric(this);
    }

    @Override
    public String getSortMetric() {
        return H2OAutoMLParams$class.getSortMetric(this);
    }

    @Override
    public boolean getBalanceClasses() {
        return H2OAutoMLParams$class.getBalanceClasses(this);
    }

    @Override
    public float[] getClassSamplingFactors() {
        return H2OAutoMLParams$class.getClassSamplingFactors(this);
    }

    @Override
    public float getMaxAfterBalanceSize() {
        return H2OAutoMLParams$class.getMaxAfterBalanceSize(this);
    }

    @Override
    public boolean getKeepCrossValidationPredictions() {
        return H2OAutoMLParams$class.getKeepCrossValidationPredictions(this);
    }

    @Override
    public boolean getKeepCrossValidationModels() {
        return H2OAutoMLParams$class.getKeepCrossValidationModels(this);
    }

    @Override
    public int getMaxModels() {
        return H2OAutoMLParams$class.getMaxModels(this);
    }

    @Override
    public H2OAutoMLParams setIgnoredCols(String[] value) {
        return H2OAutoMLParams$class.setIgnoredCols(this, value);
    }

    @Override
    public H2OAutoMLParams setIncludeAlgos(Algo[] value) {
        return H2OAutoMLParams$class.setIncludeAlgos(this, value);
    }

    @Override
    public H2OAutoMLParams setExcludeAlgos(Algo[] value) {
        return H2OAutoMLParams$class.setExcludeAlgos(this, value);
    }

    @Override
    public H2OAutoMLParams setProjectName(String value) {
        return H2OAutoMLParams$class.setProjectName(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxRuntimeSecs(double value) {
        return H2OAutoMLParams$class.setMaxRuntimeSecs(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingRounds(int value) {
        return H2OAutoMLParams$class.setStoppingRounds(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingTolerance(double value) {
        return H2OAutoMLParams$class.setStoppingTolerance(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingMetric(ScoreKeeper.StoppingMetric value) {
        return H2OAutoMLParams$class.setStoppingMetric(this, value);
    }

    @Override
    public H2OAutoMLParams setSortMetric(String value) {
        return H2OAutoMLParams$class.setSortMetric(this, value);
    }

    @Override
    public H2OAutoMLParams setBalanceClasses(boolean value) {
        return H2OAutoMLParams$class.setBalanceClasses(this, value);
    }

    @Override
    public H2OAutoMLParams setClassSamplingFactors(float[] value) {
        return H2OAutoMLParams$class.setClassSamplingFactors(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxAfterBalanceSize(float value) {
        return H2OAutoMLParams$class.setMaxAfterBalanceSize(this, value);
    }

    @Override
    public H2OAutoMLParams setKeepCrossValidationPredictions(boolean value) {
        return H2OAutoMLParams$class.setKeepCrossValidationPredictions(this, value);
    }

    @Override
    public H2OAutoMLParams setKeepCrossValidationModels(boolean value) {
        return H2OAutoMLParams$class.setKeepCrossValidationModels(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxModels(int value) {
        return H2OAutoMLParams$class.setMaxModels(this, value);
    }

    @Override
    public String getPredictionCol() {
        return H2OAutoMLParams$class.getPredictionCol(this);
    }

    @Override
    public double getRatio() {
        return H2OAutoMLParams$class.getRatio(this);
    }

    @Override
    public String getFoldColumn() {
        return H2OAutoMLParams$class.getFoldColumn(this);
    }

    @Override
    public String getWeightsColumn() {
        return H2OAutoMLParams$class.getWeightsColumn(this);
    }

    @Override
    public String[] getIgnoredColumns() {
        return H2OAutoMLParams$class.getIgnoredColumns(this);
    }

    @Override
    public H2OAutoMLParams setPredictionCol(String value) {
        return H2OAutoMLParams$class.setPredictionCol(this, value);
    }

    @Override
    public H2OAutoMLParams setRatio(double value) {
        return H2OAutoMLParams$class.setRatio(this, value);
    }

    @Override
    public H2OAutoMLParams setFoldColumn(String value) {
        return H2OAutoMLParams$class.setFoldColumn(this, value);
    }

    @Override
    public H2OAutoMLParams setWeightsColumn(String value) {
        return H2OAutoMLParams$class.setWeightsColumn(this, value);
    }

    @Override
    public H2OAutoMLParams setIgnoredColumns(String[] value) {
        return H2OAutoMLParams$class.setIgnoredColumns(this, value);
    }

    @Override
    public /* synthetic */ boolean org$apache$spark$ml$h2o$param$DeprecatableParams$$super$hasParam(String paramName) {
        return Params.class.hasParam((Params)this, (String)paramName);
    }

    @Override
    public /* synthetic */ Param org$apache$spark$ml$h2o$param$DeprecatableParams$$super$getParam(String paramName) {
        return Params.class.getParam((Params)this, (String)paramName);
    }

    @Override
    public boolean hasParam(String paramName) {
        return DeprecatableParams$class.hasParam(this, paramName);
    }

    @Override
    public Param<Object> getParam(String paramName) {
        return DeprecatableParams$class.getParam(this, paramName);
    }

    public MLWriter write() {
        return DefaultParamsWritable.class.write((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    @Override
    public Tuple2<Frame, Option<Frame>> prepareDatasetForFitting(Dataset<?> dataset) {
        return H2OAlgorithmCommons$class.prepareDatasetForFitting(this, dataset);
    }

    @Override
    public final StringArrayParam featuresCols() {
        return this.featuresCols;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final NullableStringParam foldCol() {
        return this.foldCol;
    }

    @Override
    public final NullableStringParam weightCol() {
        return this.weightCol;
    }

    @Override
    public final DoubleParam splitRatio() {
        return this.splitRatio;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final IntParam nfolds() {
        return this.nfolds;
    }

    @Override
    public final BooleanParam allStringColumnsToCategorical() {
        return this.allStringColumnsToCategorical;
    }

    @Override
    public final StringArrayParam columnsToCategorical() {
        return this.columnsToCategorical;
    }

    @Override
    public final BooleanParam convertUnknownCategoricalLevelsToNa() {
        return this.convertUnknownCategoricalLevelsToNa;
    }

    @Override
    public final BooleanParam convertInvalidNumbersToNa() {
        return this.convertInvalidNumbersToNa;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$featuresCols_$eq(StringArrayParam x$1) {
        this.featuresCols = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$foldCol_$eq(NullableStringParam x$1) {
        this.foldCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$weightCol_$eq(NullableStringParam x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$splitRatio_$eq(DoubleParam x$1) {
        this.splitRatio = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$nfolds_$eq(IntParam x$1) {
        this.nfolds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$allStringColumnsToCategorical_$eq(BooleanParam x$1) {
        this.allStringColumnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$columnsToCategorical_$eq(StringArrayParam x$1) {
        this.columnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$convertUnknownCategoricalLevelsToNa_$eq(BooleanParam x$1) {
        this.convertUnknownCategoricalLevelsToNa = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$param$H2OCommonParams$_setter_$convertInvalidNumbersToNa_$eq(BooleanParam x$1) {
        this.convertInvalidNumbersToNa = x$1;
    }

    @Override
    public String[] getFeaturesCols() {
        return H2OCommonParams$class.getFeaturesCols(this);
    }

    @Override
    public String getLabelCol() {
        return H2OCommonParams$class.getLabelCol(this);
    }

    @Override
    public String getFoldCol() {
        return H2OCommonParams$class.getFoldCol(this);
    }

    @Override
    public String getWeightCol() {
        return H2OCommonParams$class.getWeightCol(this);
    }

    @Override
    public double getSplitRatio() {
        return H2OCommonParams$class.getSplitRatio(this);
    }

    @Override
    public long getSeed() {
        return H2OCommonParams$class.getSeed(this);
    }

    @Override
    public int getNfolds() {
        return H2OCommonParams$class.getNfolds(this);
    }

    @Override
    public boolean getAllStringColumnsToCategorical() {
        return H2OCommonParams$class.getAllStringColumnsToCategorical(this);
    }

    @Override
    public String[] getColumnsToCategorical() {
        return H2OCommonParams$class.getColumnsToCategorical(this);
    }

    @Override
    public boolean getConvertUnknownCategoricalLevelsToNa() {
        return H2OCommonParams$class.getConvertUnknownCategoricalLevelsToNa(this);
    }

    @Override
    public boolean getConvertInvalidNumbersToNa() {
        return H2OCommonParams$class.getConvertInvalidNumbersToNa(this);
    }

    @Override
    public H2OCommonParams setFeaturesCol(String first) {
        return H2OCommonParams$class.setFeaturesCol(this, first);
    }

    @Override
    public H2OCommonParams setFeaturesCols(String first, Seq<String> others) {
        return H2OCommonParams$class.setFeaturesCols(this, first, others);
    }

    @Override
    public H2OCommonParams setFeaturesCols(String[] columnNames) {
        return H2OCommonParams$class.setFeaturesCols(this, columnNames);
    }

    @Override
    public H2OCommonParams setLabelCol(String columnName) {
        return H2OCommonParams$class.setLabelCol(this, columnName);
    }

    @Override
    public H2OCommonParams setFoldCol(String columnName) {
        return H2OCommonParams$class.setFoldCol(this, columnName);
    }

    @Override
    public H2OCommonParams setWeightCol(String columnName) {
        return H2OCommonParams$class.setWeightCol(this, columnName);
    }

    @Override
    public H2OCommonParams setSplitRatio(double ratio) {
        return H2OCommonParams$class.setSplitRatio(this, ratio);
    }

    @Override
    public H2OCommonParams setSeed(long value) {
        return H2OCommonParams$class.setSeed(this, value);
    }

    @Override
    public H2OCommonParams setNfolds(int value) {
        return H2OCommonParams$class.setNfolds(this, value);
    }

    @Override
    public H2OCommonParams setAllStringColumnsToCategorical(boolean value) {
        return H2OCommonParams$class.setAllStringColumnsToCategorical(this, value);
    }

    @Override
    public H2OCommonParams setColumnsToCategorical(String first, Seq<String> others) {
        return H2OCommonParams$class.setColumnsToCategorical(this, first, others);
    }

    @Override
    public H2OCommonParams setColumnsToCategorical(String[] columns) {
        return H2OCommonParams$class.setColumnsToCategorical(this, columns);
    }

    @Override
    public H2OCommonParams setConvertUnknownCategoricalLevelsToNa(boolean value) {
        return H2OCommonParams$class.setConvertUnknownCategoricalLevelsToNa(this, value);
    }

    @Override
    public H2OCommonParams setConvertInvalidNumbersToNa(boolean value) {
        return H2OCommonParams$class.setConvertInvalidNumbersToNa(this, value);
    }

    @Override
    public Seq<String> getExcludedCols() {
        return H2OCommonParams$class.getExcludedCols(this);
    }

    public String uid() {
        return this.uid;
    }

    private SparkSession spark() {
        return this.bitmap$0 ? this.spark : this.spark$lzycompute();
    }

    public Option<Dataset<Row>> leaderboard() {
        return this.leaderboard;
    }

    public void leaderboard_$eq(Option<Dataset<Row>> x$1) {
        this.leaderboard = x$1;
    }

    public H2OMOJOModel fit(Dataset<?> dataset) {
        AutoMLBuildSpec spec = new AutoMLBuildSpec();
        Object object = this.getProjectName() == null ? this.setProjectName(Random$.MODULE$.alphanumeric().take(30).mkString()) : BoxedUnit.UNIT;
        Tuple2<Frame, Option<Frame>> tuple2 = this.prepareDatasetForFitting(dataset);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Frame train = (Frame)tuple2._1();
            Option valid = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)train, (Object)valid);
            Frame train2 = (Frame)tuple23._1();
            Option valid2 = (Option)tuple23._2();
            spec.input_spec.training_frame = train2._key;
            spec.input_spec.validation_frame = (Key)valid2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Key<Frame> apply(Frame x$2) {
                    return x$2._key;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            Frame trainFrame = (Frame)spec.input_spec.training_frame.get();
            Object object2 = this.getAllStringColumnsToCategorical() ? H2OFrameSupport$.MODULE$.allStringVecToCategorical(trainFrame) : BoxedUnit.UNIT;
            H2OFrameSupport$.MODULE$.columnsToCategorical(trainFrame, this.getColumnsToCategorical());
            spec.input_spec.response_column = this.getLabelCol();
            spec.input_spec.fold_column = this.getFoldCol();
            spec.input_spec.weights_column = this.getWeightCol();
            spec.input_spec.ignored_columns = this.getIgnoredCols();
            spec.input_spec.sort_metric = this.getSortMetric();
            spec.build_models.exclude_algos = this.getExcludeAlgos() == null ? null : (Algo[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.getExcludeAlgos()), ClassTag$.MODULE$.apply(Algo.class));
            spec.build_models.include_algos = this.getIncludeAlgos() == null ? null : (Algo[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.getIncludeAlgos()), ClassTag$.MODULE$.apply(Algo.class));
            spec.build_control.project_name = this.getProjectName();
            spec.build_control.stopping_criteria.set_seed(this.getSeed());
            spec.build_control.stopping_criteria.set_max_runtime_secs(this.getMaxRuntimeSecs());
            spec.build_control.stopping_criteria.set_stopping_rounds(this.getStoppingRounds());
            spec.build_control.stopping_criteria.set_stopping_tolerance(this.getStoppingTolerance());
            spec.build_control.stopping_criteria.set_stopping_metric(this.getStoppingMetric());
            spec.build_control.stopping_criteria.set_max_models(this.getMaxModels());
            spec.build_control.nfolds = this.getNfolds();
            spec.build_control.balance_classes = this.getBalanceClasses();
            spec.build_control.class_sampling_factors = this.getClassSamplingFactors();
            spec.build_control.max_after_balance_size = this.getMaxAfterBalanceSize();
            spec.build_control.keep_cross_validation_predictions = this.getKeepCrossValidationPredictions();
            spec.build_control.keep_cross_validation_models = this.getKeepCrossValidationModels();
            DKV.put((Keyed)trainFrame);
            AutoML aml = new AutoML(Key.make((String)this.uid()), new Date(), spec);
            AutoML.startAutoML((AutoML)aml);
            aml.get();
            this.leaderboard_$eq(this.leaderboardAsSparkFrame(aml));
            if (aml.leader() == null) {
                throw new NoStackTrace(this){

                    public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                        return super.fillInStackTrace();
                    }

                    public Throwable fillInStackTrace() {
                        return NoStackTrace.class.fillInStackTrace((NoStackTrace)this);
                    }
                    {
                        NoStackTrace.class.$init$((NoStackTrace)this);
                    }
                };
            }
            Model binaryModel = aml.leader();
            byte[] mojoData = ModelSerializationSupport$.MODULE$.getMojoData(binaryModel);
            H2OMOJOSettings modelSettings = new H2OMOJOSettings(this.getConvertUnknownCategoricalLevelsToNa(), this.getConvertInvalidNumbersToNa(), H2OMOJOSettings$.MODULE$.apply$default$3());
            return H2OMOJOModel$.MODULE$.createFromMojo(mojoData, Identifiable$.MODULE$.randomUID(aml.leader()._parms.algoName()), modelSettings);
        }
        throw new MatchError(tuple2);
    }

    private Option<Dataset<Row>> leaderboardAsSparkFrame(AutoML aml) {
        TwoDimTable twoDimtable = aml.leaderboard().toTwoDimTable();
        String[] colNames = twoDimtable.getColHeaders();
        String[][] data = (String[][])Predef$.MODULE$.refArrayOps((Object[])aml.leaderboard().toTwoDimTable().getCellValues()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(IcedWrapper[] x$3) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])x$3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(IcedWrapper x$4) {
                        return x$4.toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        Row[] rows = (Row[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(String[] x$5) {
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.wrapRefArray((Object[])x$5));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        StructType schema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])colNames).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String name) {
                return new StructField(name, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        RDD rdd = this.spark().sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])rows), this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
        return new Some((Object)this.spark().createDataFrame(rdd, schema));
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return schema;
    }

    public H2OAutoML copy(ParamMap extra) {
        return (H2OAutoML)this.defaultCopy(extra);
    }

    public H2OAutoML(String uid) {
        this.uid = uid;
        H2OCommonParams$class.$init$(this);
        H2OAlgorithmCommons$class.$init$(this);
        MLWritable.class.$init$((MLWritable)this);
        DefaultParamsWritable.class.$init$((DefaultParamsWritable)this);
        DeprecatableParams$class.$init$(this);
        H2OAutoMLParams$class.$init$(this);
        this.setDefault((Param)this.nfolds(), BoxesRunTime.boxToInteger((int)5));
        this.logWarning((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Default value of 'convertUnknownCategoricalLevelsToNa' parameter will be changed to 'false' in the next major release.";
            }
        });
        this.setDefault((Param)this.convertUnknownCategoricalLevelsToNa(), BoxesRunTime.boxToBoolean((boolean)true));
        this.leaderboard = None$.MODULE$;
    }

    public H2OAutoML() {
        this(Identifiable$.MODULE$.randomUID("automl"));
    }
}

