/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.spark.models.svm;

import hex.Model;
import org.apache.spark.ml.spark.models.MissingValuesHandling;
import org.apache.spark.ml.spark.models.svm.Gradient;
import org.apache.spark.ml.spark.models.svm.SparkSVM;
import org.apache.spark.ml.spark.models.svm.SparkSVMModel;
import org.apache.spark.ml.spark.models.svm.Updater;
import water.Key;
import water.fvec.Frame;

public class SparkSVMParameters
extends Model.Parameters {
    public int _max_iterations = 1000;
    public boolean _add_intercept = false;
    public double _step_size = 1.0;
    public double _reg_param = 0.01;
    public double _convergence_tol = 0.001;
    public double _mini_batch_fraction = 1.0;
    public double _threshold = 0.0;
    public Updater _updater = Updater.L2;
    public Gradient _gradient = Gradient.Hinge;
    public Key<Frame> _initial_weights = null;
    public MissingValuesHandling _missing_values_handling = MissingValuesHandling.MeanImputation;

    public String algoName() {
        return "SparkSVM";
    }

    public String fullName() {
        return "Support Vector Machine (*Spark*)";
    }

    public String javaName() {
        return SparkSVMModel.class.getName();
    }

    public long progressUnits() {
        return this._max_iterations;
    }

    public final Frame initialWeights() {
        if (null == this._initial_weights) {
            return null;
        }
        return (Frame)this._initial_weights.get();
    }

    public void validate(SparkSVM svm) {
        if (this._max_iterations < 0 || (double)this._max_iterations > 1000000.0) {
            svm.error("_max_iterations", " max_iterations must be between 0 and 1e6");
        }
        if (this._step_size <= 0.0) {
            svm.error("_step_size", "The step size has to be positive.");
        }
        if (this._reg_param <= 0.0) {
            svm.error("_reg_param", "The regularization parameter has to be positive.");
        }
        if (this._convergence_tol <= 0.0) {
            svm.error("_convergence_tol", "The convergence tolerance has to be positive.");
        }
        if (this._mini_batch_fraction <= 0.0) {
            svm.error("_mini_batch_fraction", "The minimum batch fraction has to be positive.");
        }
    }
}

