/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.FrameMLUtils$;
import org.apache.spark.ml.spark.models.MissingValuesHandling;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import water.fvec.Frame;
import water.fvec.H2OFrame;

public final class FrameMLUtils$ {
    public static final FrameMLUtils$ MODULE$;

    static {
        new FrameMLUtils$();
    }

    public Tuple2<RDD<LabeledPoint>, double[]> toLabeledPoints(Frame frame, String reponseColumn, int nfeatures, MissingValuesHandling missingHandler, H2OContext h2oContext, SQLContext sqlContext) {
        ObjectRef means = ObjectRef.create((Object)new double[nfeatures]);
        String[][] domains = frame.domains();
        Dataset trainingDF = h2oContext.asDataFrame((Frame)new H2OFrame(frame), h2oContext.asDataFrame$default$2());
        StructField[] fields = trainingDF.schema().fields();
        RDD trainingRDD = trainingDF.rdd();
        if (MissingValuesHandling.Skip == missingHandler) {
            trainingRDD = trainingRDD.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Row x$1) {
                    return !x$1.anyNull();
                }
            });
        } else if (MissingValuesHandling.MeanImputation == missingHandler) {
            means.elem = this.movingAverage((RDD<Row>)trainingRDD, fields, domains);
        }
        return new Tuple2((Object)trainingRDD.map((Function1)new Serializable(reponseColumn, nfeatures, means, domains, fields){
            public static final long serialVersionUID = 0L;
            private final String reponseColumn$1;
            private final int nfeatures$1;
            public final ObjectRef means$1;
            public final String[][] domains$1;
            public final StructField[] fields$1;

            public final LabeledPoint apply(Row row) {
                double[] features = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nfeatures$1).map((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.toLabeledPoints.2 $outer;
                    private final Row row$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return this.row$1.isNullAt(i) ? ((double[])this.$outer.means$1.elem)[i] : FrameMLUtils$.MODULE$.toDouble(this.row$1.get(i), this.$outer.fields$1[i], this.$outer.domains$1[i]);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.row$1 = row$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                return new LabeledPoint(FrameMLUtils$.MODULE$.toDouble(row.getAs(this.reponseColumn$1), this.fields$1[this.fields$1.length - 1], this.domains$1[this.domains$1.length - 1]), Vectors$.MODULE$.dense(features));
            }
            {
                this.reponseColumn$1 = reponseColumn$1;
                this.nfeatures$1 = nfeatures$1;
                this.means$1 = means$1;
                this.domains$1 = domains$1;
                this.fields$1 = fields$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)), (Object)((double[])means.elem));
    }

    public double[] movingAverage(RDD<Row> trainingRDD, StructField[] fields, String[][] domains) {
        double[] means = new double[fields.length];
        int[] counts = new int[means.length];
        return (double[])Predef$.MODULE$.refArrayOps((Object[])trainingRDD.aggregate(Predef$.MODULE$.doubleArrayOps(means).zip((GenIterable)Predef$.MODULE$.wrapIntArray(counts), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), (Function2)new Serializable(fields, domains){
            public static final long serialVersionUID = 0L;
            public final StructField[] fields$2;
            public final String[][] domains$2;

            public final Tuple2<Object, Object>[] apply(Tuple2<Object, Object>[] agg, Row row) {
                Predef$.MODULE$.refArrayOps((Object[])agg).indices().foreach$mVc$sp((Function1)new Serializable(this, agg, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.movingAverage.1 $outer;
                    private final Tuple2[] agg$1;
                    private final Row row$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        if (!this.row$2.isNullAt(i)) {
                            double value = FrameMLUtils$.MODULE$.toDouble(this.row$2.get(i), this.$outer.fields$2[i], this.$outer.domains$2[i]);
                            double delta = value - this.agg$1[i]._1$mcD$sp();
                            int n = this.agg$1[i]._2$mcI$sp() + 1;
                            this.agg$1[i] = new Tuple2.mcDI.sp(this.agg$1[i]._1$mcD$sp() + delta / (double)n, n);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.agg$1 = agg$1;
                        this.row$2 = row$2;
                    }
                });
                return agg;
            }
            {
                this.fields$2 = fields$2;
                this.domains$2 = domains$2;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object>[] apply(Tuple2<Object, Object>[] agg1, Tuple2<Object, Object>[] agg2) {
                return FrameMLUtils$.MODULE$.merge(agg1, agg2);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$2) {
                return x$2._1$mcD$sp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public Tuple2<Object, Object>[] merge(Tuple2<Object, Object>[] agg1, Tuple2<Object, Object>[] agg2) {
        Predef$.MODULE$.refArrayOps((Object[])agg1).indices().foreach$mVc$sp((Function1)new Serializable(agg1, agg2){
            public static final long serialVersionUID = 0L;
            private final Tuple2[] agg1$1;
            private final Tuple2[] agg2$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                if (this.agg1$1[idx]._2$mcI$sp() == 0) {
                    this.agg1$1[idx] = this.agg2$1[idx];
                } else {
                    double otherMu = this.agg2$1[idx]._1$mcD$sp();
                    double mu = this.agg1$1[idx]._1$mcD$sp();
                    int n = this.agg1$1[idx]._2$mcI$sp();
                    int otherN = this.agg2$1[idx]._2$mcI$sp();
                    double delta = otherMu - mu;
                    this.agg1$1[idx] = otherN * 10 < n ? new Tuple2.mcDI.sp(mu + delta * (double)otherN / (double)(n + otherN), n + otherN) : (n * 10 < otherN ? new Tuple2.mcDI.sp(otherMu - delta * (double)n / (double)(n + otherN), n + otherN) : new Tuple2.mcDI.sp((mu * (double)n + otherMu * (double)otherN) / (double)(n + otherN), n + otherN));
                }
            }
            {
                this.agg1$1 = agg1$1;
                this.agg2$1 = agg2$1;
            }
        });
        return agg1;
    }

    public double toDouble(Object value, StructField fieldStruct, String[] domain) {
        block7: {
            double d;
            block3: {
                Object object;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = value;
                                if (!(object instanceof Byte)) break block2;
                                byte by = BoxesRunTime.unboxToByte((Object)object);
                                DataType dataType = fieldStruct.dataType();
                                DataType dataType2 = DataTypes.ByteType;
                                if (dataType != null ? !dataType.equals(dataType2) : dataType2 != null) break block2;
                                d = Predef$.MODULE$.byte2Byte(by).doubleValue();
                                break block3;
                            }
                            if (!(object instanceof Short)) break block4;
                            short s = BoxesRunTime.unboxToShort((Object)object);
                            DataType dataType = fieldStruct.dataType();
                            DataType dataType3 = DataTypes.ShortType;
                            if (dataType != null ? !dataType.equals(dataType3) : dataType3 != null) break block4;
                            d = Predef$.MODULE$.short2Short(s).doubleValue();
                            break block3;
                        }
                        if (!(object instanceof Integer)) break block5;
                        int n = BoxesRunTime.unboxToInt((Object)object);
                        DataType dataType = fieldStruct.dataType();
                        DataType dataType4 = DataTypes.IntegerType;
                        if (dataType != null ? !dataType.equals(dataType4) : dataType4 != null) break block5;
                        d = Predef$.MODULE$.int2Integer(n).doubleValue();
                        break block3;
                    }
                    if (!(object instanceof Double)) break block6;
                    double d2 = BoxesRunTime.unboxToDouble((Object)object);
                    DataType dataType = fieldStruct.dataType();
                    DataType dataType5 = DataTypes.DoubleType;
                    if (dataType != null ? !dataType.equals(dataType5) : dataType5 != null) break block6;
                    d = d2;
                    break block3;
                }
                if (!(object instanceof String)) break block7;
                String string = (String)object;
                DataType dataType = fieldStruct.dataType();
                DataType dataType6 = DataTypes.StringType;
                if (dataType != null ? !dataType.equals(dataType6) : dataType6 != null) break block7;
                d = Predef$.MODULE$.refArrayOps((Object[])domain).indexOf((Object)string);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Target column has to be an enum or a number. ").append((Object)fieldStruct).toString());
    }

    private FrameMLUtils$() {
        MODULE$ = this;
    }
}

