/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.algos;

import ai.h2o.sparkling.ml.algos.H2OKMeansParams;
import ai.h2o.sparkling.ml.params.H2OAlgoParamsHelper$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import hex.ClusteringModel;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.schemas.GLMV3;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import water.Key;

public abstract class H2OKMeansParams$class {
    public static ClassTag paramTag(H2OKMeansParams $this) {
        return package$.MODULE$.classTag(ClassTag$.MODULE$.apply(KMeansModel.KMeansParameters.class));
    }

    public static ClassTag schemaTag(H2OKMeansParams $this) {
        return package$.MODULE$.classTag(ClassTag$.MODULE$.apply(GLMV3.GLMParametersV3.class));
    }

    public static int getMaxIterations(H2OKMeansParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$maxIterations()));
    }

    public static boolean getStandardize(H2OKMeansParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$standardize()));
    }

    public static String getInit(H2OKMeansParams $this) {
        return (String)$this.$($this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$init());
    }

    public static double[][] getUserPoints(H2OKMeansParams $this) {
        return (double[][])$this.$($this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$userPoints());
    }

    public static boolean getEstimateK(H2OKMeansParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$estimateK()));
    }

    public static int getK(H2OKMeansParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$k()));
    }

    public static H2OKMeansParams setMaxIterations(H2OKMeansParams $this, int value) {
        return (H2OKMeansParams)$this.set((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$maxIterations(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OKMeansParams setStandardize(H2OKMeansParams $this, boolean value) {
        return (H2OKMeansParams)$this.set((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$standardize(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OKMeansParams setInit(H2OKMeansParams $this, String value) {
        String validated = H2OAlgoParamsHelper$.MODULE$.getValidatedEnumValue(value, ClassTag$.MODULE$.apply(KMeans.Initialization.class));
        return (H2OKMeansParams)$this.set($this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$init(), validated);
    }

    public static H2OKMeansParams setUserPoints(H2OKMeansParams $this, double[][] value) {
        return (H2OKMeansParams)$this.set($this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$userPoints(), value);
    }

    public static H2OKMeansParams setEstimateK(H2OKMeansParams $this, boolean value) {
        return (H2OKMeansParams)$this.set((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$estimateK(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OKMeansParams setK(H2OKMeansParams $this, int value) {
        return (H2OKMeansParams)$this.set((Param)$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$k(), BoxesRunTime.boxToInteger((int)value));
    }

    public static void updateH2OParams(H2OKMeansParams $this) {
        Key key;
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$super$updateH2OParams();
        ((KMeansModel.KMeansParameters)$this.parameters())._max_iterations = $this.getMaxIterations();
        ((KMeansModel.KMeansParameters)$this.parameters())._standardize = $this.getStandardize();
        ((KMeansModel.KMeansParameters)$this.parameters())._init = KMeans.Initialization.valueOf((String)$this.getInit());
        KMeansModel.KMeansParameters kMeansParameters = (KMeansModel.KMeansParameters)$this.parameters();
        double[][] userPoints = $this.getUserPoints();
        if (userPoints == null) {
            key = null;
        } else {
            SparkSession spark = SparkSessionUtils$.MODULE$.active();
            Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])userPoints), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))), spark.implicits().newDoubleArrayEncoder()).toDF();
            key = H2OContext$.MODULE$.getOrCreate().asH2OFrame(df).key();
        }
        kMeansParameters._user_points = key;
        ((KMeansModel.KMeansParameters)$this.parameters())._estimate_k = $this.getEstimateK();
        ((ClusteringModel.ClusteringParameters)$this.parameters())._k = $this.getK();
    }

    public static void $init$(H2OKMeansParams $this) {
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$_setter_$ai$h2o$sparkling$ml$algos$H2OKMeansParams$$maxIterations_$eq($this.intParam("maxIterations", "Maximum number of KMeans iterations to find the centroids."));
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$_setter_$ai$h2o$sparkling$ml$algos$H2OKMeansParams$$standardize_$eq($this.booleanParam("standardize", "Standardize the numeric columns to have a mean of zero and unit variance."));
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$_setter_$ai$h2o$sparkling$ml$algos$H2OKMeansParams$$init_$eq($this.stringParam("init", "Initialization mode for finding the initial cluster centers."));
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$_setter_$ai$h2o$sparkling$ml$algos$H2OKMeansParams$$userPoints_$eq($this.nullableDoubleArrayArrayParam("userPoints", "This option allows you to specify array of points, where each point represents coordinates of an initial cluster center. The user-specified points must have the same number of columns as the training observations. The number of rows must equal the number of clusters."));
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$_setter_$ai$h2o$sparkling$ml$algos$H2OKMeansParams$$estimateK_$eq($this.booleanParam("estimateK", "If enabled, the algorithm tries to identify optimal number of clusters, up to k clusters."));
        $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$_setter_$ai$h2o$sparkling$ml$algos$H2OKMeansParams$$k_$eq($this.intParam("k", "Number of clusters to generate."));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$maxIterations().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10)), $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$standardize().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true)), $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$init().$minus$greater((Object)KMeans.Initialization.Furthest.name()), $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$userPoints().$minus$greater(null), $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$estimateK().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.ai$h2o$sparkling$ml$algos$H2OKMeansParams$$k().$minus$greater((Object)BoxesRunTime.boxToInteger((int)2))}));
    }
}

