/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.algos;

import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.H2OFrame$;
import ai.h2o.sparkling.ml.algos.H2OAlgoCommonUtils;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class H2OAlgoCommonUtils$class {
    public static String[] getFeaturesColsInternal(H2OAlgoCommonUtils $this) {
        return $this.getFeaturesCols();
    }

    public static String[] getColumnsToCategoricalInternal(H2OAlgoCommonUtils $this) {
        return $this.getColumnsToCategorical();
    }

    public static double getSplitRatioInternal(H2OAlgoCommonUtils $this) {
        return $this.getSplitRatio();
    }

    public static H2OAlgoCommonUtils setFeaturesColsInternal(H2OAlgoCommonUtils $this, String[] value) {
        return $this.setFeaturesCols(value);
    }

    public static Tuple2 prepareDatasetForFitting(H2OAlgoCommonUtils $this, Dataset dataset) {
        H2OFrame[] frames;
        H2OAlgoCommonUtils h2OAlgoCommonUtils;
        Seq<String> excludedCols = $this.getExcludedCols();
        if (Predef$.MODULE$.refArrayOps((Object[])$this.getFeaturesColsInternal()).isEmpty()) {
            String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])dataset.columns()).filter((Function1)new Serializable($this, excludedCols){
                public static final long serialVersionUID = 0L;
                private final Seq excludedCols$1;

                public final boolean apply(String c) {
                    return this.excludedCols$1.forall((Function1)new Serializable(this, c){
                        public static final long serialVersionUID = 0L;
                        private final String c$1;

                        public final boolean apply(String e) {
                            return this.c$1.compareToIgnoreCase(e) != 0;
                        }
                        {
                            this.c$1 = c$1;
                        }
                    });
                }
                {
                    this.excludedCols$1 = excludedCols$1;
                }
            });
            h2OAlgoCommonUtils = $this.setFeaturesColsInternal(features);
        } else {
            String[] missingColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])$this.getFeaturesColsInternal()).filterNot((Function1)new Serializable($this, dataset){
                public static final long serialVersionUID = 0L;
                private final Dataset dataset$1;

                public final boolean apply(String col) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.dataset$1.columns()).contains((Object)col);
                }
                {
                    this.dataset$1 = dataset$1;
                }
            });
            if (Predef$.MODULE$.refArrayOps((Object[])missingColumns).nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"The following feature columns are not available on").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" the training dataset: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])missingColumns).mkString(", ")}))).toString());
            }
            h2OAlgoCommonUtils = BoxedUnit.UNIT;
        }
        Column[] featureColumns = (Column[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.getFeaturesColsInternal()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ H2OAlgoCommonUtils $outer;

            public final String apply(String colName) {
                return this.$outer.sanitize(colName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        Seq excludedColumns = (Seq)((TraversableLike)excludedCols.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ H2OAlgoCommonUtils $outer;

            public final String apply(String colName) {
                return this.$outer.sanitize(colName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Column[] columns = (Column[])Predef$.MODULE$.refArrayOps((Object[])featureColumns).$plus$plus((GenTraversableOnce)excludedColumns, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        H2OContext h2oContext = H2OContext$.MODULE$.ensure((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "H2OContext needs to be created in order to train the model. Please create one as H2OContext.getOrCreate().";
            }
        });
        H2OFrame trainFrame = H2OFrame$.MODULE$.apply(h2oContext.asH2OFrameKeyString(dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns)).toDF()));
        trainFrame.convertColumnsToCategorical($this.getColumnsToCategoricalInternal());
        return $this.getSplitRatioInternal() < 1.0 ? ((frames = trainFrame.split((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{$this.getSplitRatioInternal()}))).length > 1 ? new Tuple2((Object)frames[0], (Object)new Some((Object)frames[1])) : new Tuple2((Object)frames[0], (Object)None$.MODULE$)) : new Tuple2((Object)trainFrame, (Object)None$.MODULE$);
    }

    public static String sanitize(H2OAlgoCommonUtils $this, String colName) {
        return new StringBuilder().append('`').append((Object)colName).append((Object)BoxesRunTime.boxToCharacter((char)'`')).toString();
    }

    public static void $init$(H2OAlgoCommonUtils $this) {
    }
}

