/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.backend.H2OJob$;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.ml.internals.H2OModel;
import ai.h2o.sparkling.ml.internals.H2OModel$;
import ai.h2o.sparkling.ml.models.H2OMOJOModel;
import ai.h2o.sparkling.ml.models.H2OMOJOSettings;
import ai.h2o.sparkling.ml.models.H2OMOJOSettings$;
import ai.h2o.sparkling.ml.utils.EstimatorCommonUtils;
import hex.schemas.ModelBuilderSchema;
import java.io.File;
import java.net.URI;
import org.apache.spark.expose.Utils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class EstimatorCommonUtils$class {
    public static String trainAndGetDestinationKey(EstimatorCommonUtils $this, String endpointSuffix, Map params, boolean encodeParamsAsJson) {
        H2OConf conf = H2OContext$.MODULE$.ensure((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return H2OContext$.MODULE$.ensure$default$1();
            }
        }).getConf();
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        ModelBuilderSchema modelBuilder = (ModelBuilderSchema)$this.update(endpoint, endpointSuffix, conf, params, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ModelBuilderSchema.class, (Object)"parameters")})), encodeParamsAsJson, ClassTag$.MODULE$.apply(ModelBuilderSchema.class));
        String jobId = modelBuilder.job.key.name;
        H2OJob$.MODULE$.apply(jobId).waitForFinish();
        return modelBuilder.job.dest.name;
    }

    public static boolean trainAndGetDestinationKey$default$3(EstimatorCommonUtils $this) {
        return false;
    }

    public static H2OMOJOModel trainAndGetMOJOModel(EstimatorCommonUtils $this, String endpointSuffix, Map params, boolean encodeParamsAsJson) {
        String modelKey = $this.trainAndGetDestinationKey(endpointSuffix, (Map<String, Object>)params, encodeParamsAsJson);
        H2OModel mojo = H2OModel$.MODULE$.apply(modelKey);
        return mojo.toMOJOModel(new StringBuilder().append((Object)modelKey).append((Object)"_uid").toString(), new H2OMOJOSettings(H2OMOJOSettings$.MODULE$.apply$default$1(), H2OMOJOSettings$.MODULE$.apply$default$2(), H2OMOJOSettings$.MODULE$.apply$default$3(), H2OMOJOSettings$.MODULE$.apply$default$4(), H2OMOJOSettings$.MODULE$.apply$default$5(), H2OMOJOSettings$.MODULE$.apply$default$6(), H2OMOJOSettings$.MODULE$.apply$default$7(), H2OMOJOSettings$.MODULE$.apply$default$8(), H2OMOJOSettings$.MODULE$.apply$default$9(), H2OMOJOSettings$.MODULE$.apply$default$10()), false);
    }

    public static boolean trainAndGetMOJOModel$default$3(EstimatorCommonUtils $this) {
        return false;
    }

    public static File downloadBinaryModel(EstimatorCommonUtils $this, String modelId, H2OConf conf) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        File sparkTmpDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.getLocalDir(conf.sparkConf()), Utils$.MODULE$.createTempDir$default$2());
        File target = new File(sparkTmpDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".bin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelId})));
        $this.downloadBinaryURLContent(endpoint, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/3/Models.fetch.bin/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelId})), conf, target);
        return target;
    }

    /*
     * WARNING - void declaration
     */
    public static String convertModelIdToKey(EstimatorCommonUtils $this, String key) {
        String string;
        if (H2OModel$.MODULE$.modelExists(key)) {
            void var2_2;
            String replacement = EstimatorCommonUtils$class.findAlternativeKey($this, key);
            $this.logWarning((Function0)new Serializable($this, replacement, key){
                public static final long serialVersionUID = 0L;
                private final String replacement$1;
                private final String key$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model id '", "' is already used by a different H2O model. Replacing the original id with '", "' ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.replacement$1}));
                }
                {
                    this.replacement$1 = replacement$1;
                    this.key$1 = key$1;
                }
            });
            string = var2_2;
        } else {
            string = key;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String findAlternativeKey(EstimatorCommonUtils $this, String modelId) {
        void var3_3;
        int suffixNumber = 0;
        String replacement = null;
        while (H2OModel$.MODULE$.modelExists(replacement = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelId, BoxesRunTime.boxToInteger((int)(++suffixNumber))})))) {
        }
        return var3_3;
    }

    public static void $init$(EstimatorCommonUtils $this) {
    }
}

