/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.params;

import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.ml.params.EnumParamValidator$;
import ai.h2o.sparkling.ml.params.H2OPCAParams;
import hex.DataInfo;
import hex.pca.PCAImplementation;
import hex.pca.PCAModel;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

public abstract class H2OPCAParams$class {
    public static ClassTag paramTag(H2OPCAParams $this) {
        return package$.MODULE$.classTag(ClassTag$.MODULE$.apply(PCAModel.PCAParameters.class));
    }

    public static String getTransform(H2OPCAParams $this) {
        return (String)$this.$($this.transform());
    }

    public static String getPcaMethod(H2OPCAParams $this) {
        return (String)$this.$($this.pcaMethod());
    }

    public static String getPcaImpl(H2OPCAParams $this) {
        return (String)$this.$($this.pcaImpl());
    }

    public static int getK(H2OPCAParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.k()));
    }

    public static int getMaxIterations(H2OPCAParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.maxIterations()));
    }

    public static long getSeed(H2OPCAParams $this) {
        return BoxesRunTime.unboxToLong((Object)$this.$((Param)$this.seed()));
    }

    public static boolean getUseAllFactorLevels(H2OPCAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.useAllFactorLevels()));
    }

    public static boolean getComputeMetrics(H2OPCAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.computeMetrics()));
    }

    public static boolean getImputeMissing(H2OPCAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.imputeMissing()));
    }

    public static String getModelId(H2OPCAParams $this) {
        return (String)$this.$((Param)$this.modelId());
    }

    public static boolean getIgnoreConstCols(H2OPCAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.ignoreConstCols()));
    }

    public static boolean getScoreEachIteration(H2OPCAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.scoreEachIteration()));
    }

    public static double getMaxRuntimeSecs(H2OPCAParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.maxRuntimeSecs()));
    }

    public static String getExportCheckpointsDir(H2OPCAParams $this) {
        return (String)$this.$((Param)$this.exportCheckpointsDir());
    }

    public static H2OPCAParams setTransform(H2OPCAParams $this, String value) {
        String validated = EnumParamValidator$.MODULE$.getValidatedEnumValue(value, ClassTag$.MODULE$.apply(DataInfo.TransformType.class));
        return (H2OPCAParams)$this.set($this.transform(), validated);
    }

    public static H2OPCAParams setPcaMethod(H2OPCAParams $this, String value) {
        String validated = EnumParamValidator$.MODULE$.getValidatedEnumValue(value, ClassTag$.MODULE$.apply(PCAModel.PCAParameters.Method.class));
        return (H2OPCAParams)$this.set($this.pcaMethod(), validated);
    }

    public static H2OPCAParams setPcaImpl(H2OPCAParams $this, String value) {
        String validated = EnumParamValidator$.MODULE$.getValidatedEnumValue(value, ClassTag$.MODULE$.apply(PCAImplementation.class));
        return (H2OPCAParams)$this.set($this.pcaImpl(), validated);
    }

    public static H2OPCAParams setK(H2OPCAParams $this, int value) {
        return (H2OPCAParams)$this.set((Param)$this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OPCAParams setMaxIterations(H2OPCAParams $this, int value) {
        return (H2OPCAParams)$this.set((Param)$this.maxIterations(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OPCAParams setSeed(H2OPCAParams $this, long value) {
        return (H2OPCAParams)$this.set((Param)$this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public static H2OPCAParams setUseAllFactorLevels(H2OPCAParams $this, boolean value) {
        return (H2OPCAParams)$this.set((Param)$this.useAllFactorLevels(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OPCAParams setComputeMetrics(H2OPCAParams $this, boolean value) {
        return (H2OPCAParams)$this.set((Param)$this.computeMetrics(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OPCAParams setImputeMissing(H2OPCAParams $this, boolean value) {
        return (H2OPCAParams)$this.set((Param)$this.imputeMissing(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OPCAParams setModelId(H2OPCAParams $this, String value) {
        return (H2OPCAParams)$this.set((Param)$this.modelId(), value);
    }

    public static H2OPCAParams setIgnoreConstCols(H2OPCAParams $this, boolean value) {
        return (H2OPCAParams)$this.set((Param)$this.ignoreConstCols(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OPCAParams setScoreEachIteration(H2OPCAParams $this, boolean value) {
        return (H2OPCAParams)$this.set((Param)$this.scoreEachIteration(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OPCAParams setMaxRuntimeSecs(H2OPCAParams $this, double value) {
        return (H2OPCAParams)$this.set((Param)$this.maxRuntimeSecs(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OPCAParams setExportCheckpointsDir(H2OPCAParams $this, String value) {
        return (H2OPCAParams)$this.set((Param)$this.exportCheckpointsDir(), value);
    }

    public static Map getH2OAlgorithmParams(H2OPCAParams $this, H2OFrame trainingFrame) {
        return $this.ai$h2o$sparkling$ml$params$H2OPCAParams$$super$getH2OAlgorithmParams(trainingFrame).$plus$plus($this.getH2OPCAParams(trainingFrame));
    }

    public static Map getH2OPCAParams(H2OPCAParams $this, H2OFrame trainingFrame) {
        return $this.ParametersExtraMethods((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transform"), (Object)$this.getTransform()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pca_method"), (Object)$this.getPcaMethod()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pca_impl"), (Object)$this.getPcaImpl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)$this.getK())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_iterations"), (Object)BoxesRunTime.boxToInteger((int)$this.getMaxIterations())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seed"), (Object)BoxesRunTime.boxToLong((long)$this.getSeed())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"use_all_factor_levels"), (Object)BoxesRunTime.boxToBoolean((boolean)$this.getUseAllFactorLevels())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compute_metrics"), (Object)BoxesRunTime.boxToBoolean((boolean)$this.getComputeMetrics())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"impute_missing"), (Object)BoxesRunTime.boxToBoolean((boolean)$this.getImputeMissing())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"model_id"), (Object)$this.getModelId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ignore_const_cols"), (Object)BoxesRunTime.boxToBoolean((boolean)$this.getIgnoreConstCols())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"score_each_iteration"), (Object)BoxesRunTime.boxToBoolean((boolean)$this.getScoreEachIteration())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_runtime_secs"), (Object)BoxesRunTime.boxToDouble((double)$this.getMaxRuntimeSecs())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"export_checkpoints_dir"), (Object)$this.getExportCheckpointsDir())})))).$plus$plus$plus($this.getIgnoredColsParam(trainingFrame));
    }

    public static Map getSWtoH2OParamNameMap(H2OPCAParams $this) {
        return $this.ai$h2o$sparkling$ml$params$H2OPCAParams$$super$getSWtoH2OParamNameMap().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transform"), (Object)"transform"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pcaMethod"), (Object)"pca_method"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pcaImpl"), (Object)"pca_impl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"k"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIterations"), (Object)"max_iterations"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seed"), (Object)"seed"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"useAllFactorLevels"), (Object)"use_all_factor_levels"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computeMetrics"), (Object)"compute_metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"imputeMissing"), (Object)"impute_missing"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modelId"), (Object)"model_id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ignoreConstCols"), (Object)"ignore_const_cols"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scoreEachIteration"), (Object)"score_each_iteration"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRuntimeSecs"), (Object)"max_runtime_secs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exportCheckpointsDir"), (Object)"export_checkpoints_dir")})));
    }

    public static void $init$(H2OPCAParams $this) {
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$transform_$eq($this.stringParam("transform", "Transformation of training data. Possible values are ``\"NONE\"``, ``\"STANDARDIZE\"``, ``\"NORMALIZE\"``, ``\"DEMEAN\"``, ``\"DESCALE\"``."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$pcaMethod_$eq($this.stringParam("pcaMethod", "Specify the algorithm to use for computing the principal components: GramSVD - uses a distributed computation of the Gram matrix, followed by a local SVD; Power - computes the SVD using the power iteration method (experimental); Randomized - uses randomized subspace iteration method; GLRM - fits a generalized low-rank model with L2 loss function and no regularization and solves for the SVD using local matrix algebra (experimental). Possible values are ``\"GramSVD\"``, ``\"Power\"``, ``\"Randomized\"``, ``\"GLRM\"``."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$pcaImpl_$eq($this.stringParam("pcaImpl", "Specify the implementation to use for computing PCA (via SVD or EVD): MTJ_EVD_DENSEMATRIX - eigenvalue decompositions for dense matrix using MTJ; MTJ_EVD_SYMMMATRIX - eigenvalue decompositions for symmetric matrix using MTJ; MTJ_SVD_DENSEMATRIX - singular-value decompositions for dense matrix using MTJ; JAMA - eigenvalue decompositions for dense matrix using JAMA. References: JAMA - http://math.nist.gov/javanumerics/jama/; MTJ - https://github.com/fommil/matrix-toolkits-java/. Possible values are ``\"MTJ_EVD_DENSEMATRIX\"``, ``\"MTJ_EVD_SYMMMATRIX\"``, ``\"MTJ_SVD_DENSEMATRIX\"``, ``\"JAMA\"``."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$k_$eq($this.intParam("k", "Rank of matrix approximation."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$maxIterations_$eq($this.intParam("maxIterations", "Maximum training iterations."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$seed_$eq($this.longParam("seed", "RNG seed for initialization."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$useAllFactorLevels_$eq($this.booleanParam("useAllFactorLevels", "Whether first factor level is included in each categorical expansion."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$computeMetrics_$eq($this.booleanParam("computeMetrics", "Whether to compute metrics on the training data."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$imputeMissing_$eq($this.booleanParam("imputeMissing", "Whether to impute missing entries with the column mean."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$modelId_$eq($this.nullableStringParam("modelId", "Destination id for this model; auto-generated if not specified."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$ignoreConstCols_$eq($this.booleanParam("ignoreConstCols", "Ignore constant columns."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$scoreEachIteration_$eq($this.booleanParam("scoreEachIteration", "Whether to score during each iteration of model training."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$maxRuntimeSecs_$eq($this.doubleParam("maxRuntimeSecs", "Maximum allowed runtime in seconds for model training. Use 0 to disable."));
        $this.ai$h2o$sparkling$ml$params$H2OPCAParams$_setter_$exportCheckpointsDir_$eq($this.nullableStringParam("exportCheckpointsDir", "Automatically export generated models to this directory."));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.transform().$minus$greater((Object)DataInfo.TransformType.NONE.name()), $this.pcaMethod().$minus$greater((Object)PCAModel.PCAParameters.Method.GramSVD.name()), $this.pcaImpl().$minus$greater((Object)PCAImplementation.MTJ_EVD_SYMMMATRIX.name()), $this.k().$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), $this.maxIterations().$minus$greater((Object)BoxesRunTime.boxToInteger((int)1000)), $this.seed().$minus$greater((Object)BoxesRunTime.boxToLong((long)-1L)), $this.useAllFactorLevels().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.computeMetrics().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true)), $this.imputeMissing().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.modelId().$minus$greater(null), $this.ignoreConstCols().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true)), $this.scoreEachIteration().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), $this.maxRuntimeSecs().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.0)), $this.exportCheckpointsDir().$minus$greater(null)}));
    }
}

