/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ai.h2o.sparkling.ml.algos.regression

import ai.h2o.sparkling.H2OFrame
import ai.h2o.sparkling.ml.algos.{H2OAlgoCommonUtils, ProblemType}
import org.apache.spark.sql.Dataset

trait FamilyForRegressionCheck extends H2OAlgoCommonUtils {
  def getFamily(): String

  override private[sparkling] def prepareDatasetForFitting(dataset: Dataset[_]): (H2OFrame, Option[H2OFrame]) = {
    val family = getFamily()
    val problemType = ProblemType.familyToProblemType(family)
    if (problemType != ProblemType.Both && problemType != ProblemType.Regression) {
      throw new RuntimeException(s"Family '$family' is not supported for a regression problem.")
    }
    super.prepareDatasetForFitting(dataset)
  }
}
