/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class EigenvalueDecomposition
implements Serializable {
    private int n;
    private boolean issymmetric;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;
    private static final long serialVersionUID = 1L;

    private void tred2() {
        double d2;
        int n2;
        for (n2 = 0; n2 < this.n; ++n2) {
            this.d[n2] = this.V[this.n - 1][n2];
        }
        for (n2 = this.n - 1; n2 > 0; --n2) {
            int n3;
            d2 = 0.0;
            double d3 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                d2 += Math.abs(this.d[n3]);
            }
            if (d2 == 0.0) {
                this.e[n2] = this.d[n2 - 1];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.d[n3] = this.V[n2 - 1][n3];
                    this.V[n2][n3] = 0.0;
                    this.V[n3][n2] = 0.0;
                }
            } else {
                int n4;
                int n5;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n6 = n3;
                    this.d[n6] = this.d[n6] / d2;
                    d3 += this.d[n3] * this.d[n3];
                }
                double d4 = this.d[n2 - 1];
                double d5 = Math.sqrt(d3);
                if (d4 > 0.0) {
                    d5 = -d5;
                }
                this.e[n2] = d2 * d5;
                d3 -= d4 * d5;
                this.d[n2 - 1] = d4 - d5;
                for (n5 = 0; n5 < n2; ++n5) {
                    this.e[n5] = 0.0;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    this.V[n5][n2] = d4 = this.d[n5];
                    d5 = this.e[n5] + this.V[n5][n5] * d4;
                    for (int i2 = n5 + 1; i2 <= n2 - 1; ++i2) {
                        d5 += this.V[i2][n5] * this.d[i2];
                        int n7 = i2;
                        this.e[n7] = this.e[n7] + this.V[i2][n5] * d4;
                    }
                    this.e[n5] = d5;
                }
                d4 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    int n8 = n5;
                    this.e[n8] = this.e[n8] / d3;
                    d4 += this.e[n5] * this.d[n5];
                }
                double d6 = d4 / (d3 + d3);
                for (n4 = 0; n4 < n2; ++n4) {
                    int n9 = n4;
                    this.e[n9] = this.e[n9] - d6 * this.d[n4];
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    d4 = this.d[n4];
                    d5 = this.e[n4];
                    for (int i3 = n4; i3 <= n2 - 1; ++i3) {
                        double[] dArray = this.V[i3];
                        int n10 = n4;
                        dArray[n10] = dArray[n10] - (d4 * this.e[i3] + d5 * this.d[i3]);
                    }
                    this.d[n4] = this.V[n2 - 1][n4];
                    this.V[n2][n4] = 0.0;
                }
            }
            this.d[n2] = d3;
        }
        for (n2 = 0; n2 < this.n - 1; ++n2) {
            int n11;
            this.V[this.n - 1][n2] = this.V[n2][n2];
            this.V[n2][n2] = 1.0;
            d2 = this.d[n2 + 1];
            if (d2 != 0.0) {
                for (n11 = 0; n11 <= n2; ++n11) {
                    this.d[n11] = this.V[n11][n2 + 1] / d2;
                }
                for (n11 = 0; n11 <= n2; ++n11) {
                    int n12;
                    double d7 = 0.0;
                    for (n12 = 0; n12 <= n2; ++n12) {
                        d7 += this.V[n12][n2 + 1] * this.V[n12][n11];
                    }
                    for (n12 = 0; n12 <= n2; ++n12) {
                        double[] dArray = this.V[n12];
                        int n13 = n11;
                        dArray[n13] = dArray[n13] - d7 * this.d[n12];
                    }
                }
            }
            for (n11 = 0; n11 <= n2; ++n11) {
                this.V[n11][n2 + 1] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            this.d[n2] = this.V[this.n - 1][n2];
            this.V[this.n - 1][n2] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        int n2;
        int n3;
        for (int i2 = 1; i2 < this.n; ++i2) {
            this.e[i2 - 1] = this.e[i2];
        }
        this.e[this.n - 1] = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Math.pow(2.0, -52.0);
        for (n3 = 0; n3 < this.n; ++n3) {
            d3 = Math.max(d3, Math.abs(this.d[n3]) + Math.abs(this.e[n3]));
            for (n2 = n3; n2 < this.n && !(Math.abs(this.e[n2]) <= d4 * d3); ++n2) {
            }
            if (n2 > n3) {
                int n4 = 0;
                do {
                    double d5;
                    ++n4;
                    double d6 = this.d[n3];
                    double d7 = (this.d[n3 + 1] - d6) / (2.0 * this.e[n3]);
                    double d8 = Maths.hypot(d7, 1.0);
                    if (d7 < 0.0) {
                        d8 = -d8;
                    }
                    this.d[n3] = this.e[n3] / (d7 + d8);
                    this.d[n3 + 1] = this.e[n3] * (d7 + d8);
                    double d9 = this.d[n3 + 1];
                    double d10 = d6 - this.d[n3];
                    int n5 = n3 + 2;
                    while (n5 < this.n) {
                        int n6 = n5++;
                        this.d[n6] = this.d[n6] - d10;
                    }
                    d2 += d10;
                    d7 = this.d[n2];
                    double d11 = d5 = 1.0;
                    double d12 = d5;
                    double d13 = this.e[n3 + 1];
                    double d14 = 0.0;
                    double d15 = 0.0;
                    for (int i3 = n2 - 1; i3 >= n3; --i3) {
                        d12 = d11;
                        d11 = d5;
                        d15 = d14;
                        d6 = d5 * this.e[i3];
                        d10 = d5 * d7;
                        d8 = Maths.hypot(d7, this.e[i3]);
                        this.e[i3 + 1] = d14 * d8;
                        d14 = this.e[i3] / d8;
                        d5 = d7 / d8;
                        d7 = d5 * this.d[i3] - d14 * d6;
                        this.d[i3 + 1] = d10 + d14 * (d5 * d6 + d14 * this.d[i3]);
                        for (int i4 = 0; i4 < this.n; ++i4) {
                            d10 = this.V[i4][i3 + 1];
                            this.V[i4][i3 + 1] = d14 * this.V[i4][i3] + d5 * d10;
                            this.V[i4][i3] = d5 * this.V[i4][i3] - d14 * d10;
                        }
                    }
                    d7 = -d14 * d15 * d12 * d13 * this.e[n3] / d9;
                    this.e[n3] = d14 * d7;
                    this.d[n3] = d5 * d7;
                } while (Math.abs(this.e[n3]) > d4 * d3);
            }
            this.d[n3] = this.d[n3] + d2;
            this.e[n3] = 0.0;
        }
        for (n3 = 0; n3 < this.n - 1; ++n3) {
            int n7;
            n2 = n3;
            double d16 = this.d[n3];
            for (n7 = n3 + 1; n7 < this.n; ++n7) {
                if (!(this.d[n7] < d16)) continue;
                n2 = n7;
                d16 = this.d[n7];
            }
            if (n2 == n3) continue;
            this.d[n2] = this.d[n3];
            this.d[n3] = d16;
            for (n7 = 0; n7 < this.n; ++n7) {
                d16 = this.V[n7][n3];
                this.V[n7][n3] = this.V[n7][n2];
                this.V[n7][n2] = d16;
            }
        }
    }

    private void orthes() {
        int n2;
        int n3 = 0;
        int n4 = this.n - 1;
        for (n2 = n3 + 1; n2 <= n4 - 1; ++n2) {
            int n5;
            double d2;
            int n6;
            double d3 = 0.0;
            for (int i2 = n2; i2 <= n4; ++i2) {
                d3 += Math.abs(this.H[i2][n2 - 1]);
            }
            if (d3 == 0.0) continue;
            double d4 = 0.0;
            for (int i3 = n4; i3 >= n2; --i3) {
                this.ort[i3] = this.H[i3][n2 - 1] / d3;
                d4 += this.ort[i3] * this.ort[i3];
            }
            double d5 = Math.sqrt(d4);
            if (this.ort[n2] > 0.0) {
                d5 = -d5;
            }
            d4 -= this.ort[n2] * d5;
            this.ort[n2] = this.ort[n2] - d5;
            for (n6 = n2; n6 < this.n; ++n6) {
                d2 = 0.0;
                for (n5 = n4; n5 >= n2; --n5) {
                    d2 += this.ort[n5] * this.H[n5][n6];
                }
                d2 /= d4;
                for (n5 = n2; n5 <= n4; ++n5) {
                    double[] dArray = this.H[n5];
                    int n7 = n6;
                    dArray[n7] = dArray[n7] - d2 * this.ort[n5];
                }
            }
            for (n6 = 0; n6 <= n4; ++n6) {
                d2 = 0.0;
                for (n5 = n4; n5 >= n2; --n5) {
                    d2 += this.ort[n5] * this.H[n6][n5];
                }
                d2 /= d4;
                for (n5 = n2; n5 <= n4; ++n5) {
                    double[] dArray = this.H[n6];
                    int n8 = n5;
                    dArray[n8] = dArray[n8] - d2 * this.ort[n5];
                }
            }
            this.ort[n2] = d3 * this.ort[n2];
            this.H[n2][n2 - 1] = d3 * d5;
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            for (int i4 = 0; i4 < this.n; ++i4) {
                this.V[n2][i4] = n2 == i4 ? 1.0 : 0.0;
            }
        }
        for (n2 = n4 - 1; n2 >= n3 + 1; --n2) {
            int n9;
            if (this.H[n2][n2 - 1] == 0.0) continue;
            for (n9 = n2 + 1; n9 <= n4; ++n9) {
                this.ort[n9] = this.H[n9][n2 - 1];
            }
            for (n9 = n2; n9 <= n4; ++n9) {
                int n10;
                double d6 = 0.0;
                for (n10 = n2; n10 <= n4; ++n10) {
                    d6 += this.ort[n10] * this.V[n10][n9];
                }
                d6 = d6 / this.ort[n2] / this.H[n2][n2 - 1];
                for (n10 = n2; n10 <= n4; ++n10) {
                    double[] dArray = this.V[n10];
                    int n11 = n9;
                    dArray[n11] = dArray[n11] + d6 * this.ort[n10];
                }
            }
        }
    }

    private void cdiv(double d2, double d3, double d4, double d5) {
        if (Math.abs(d4) > Math.abs(d5)) {
            double d6 = d5 / d4;
            double d7 = d4 + d6 * d5;
            this.cdivr = (d2 + d6 * d3) / d7;
            this.cdivi = (d3 - d6 * d2) / d7;
        } else {
            double d8 = d4 / d5;
            double d9 = d5 + d8 * d4;
            this.cdivr = (d8 * d2 + d3) / d9;
            this.cdivi = (d8 * d3 - d2) / d9;
        }
    }

    private void hqr2() {
        double d2;
        int n2;
        double d3;
        double d4;
        int n3;
        int n4;
        int n5 = this.n;
        int n6 = n5 - 1;
        int n7 = 0;
        int n8 = n5 - 1;
        double d5 = Math.pow(2.0, -52.0);
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (n4 < n7 | n4 > n8) {
                this.d[n4] = this.H[n4][n4];
                this.e[n4] = 0.0;
            }
            for (n3 = Math.max(n4 - 1, 0); n3 < n5; ++n3) {
                d12 += Math.abs(this.H[n4][n3]);
            }
        }
        n4 = 0;
        while (n6 >= n7) {
            int n9;
            for (n3 = n6; n3 > n7; --n3) {
                d10 = Math.abs(this.H[n3 - 1][n3 - 1]) + Math.abs(this.H[n3][n3]);
                if (d10 == 0.0) {
                    d10 = d12;
                }
                if (Math.abs(this.H[n3][n3 - 1]) < d5 * d10) break;
            }
            if (n3 == n6) {
                this.H[n6][n6] = this.H[n6][n6] + d6;
                this.d[n6] = this.H[n6][n6];
                this.e[n6] = 0.0;
                --n6;
                n4 = 0;
                continue;
            }
            if (n3 == n6 - 1) {
                d4 = this.H[n6][n6 - 1] * this.H[n6 - 1][n6];
                d7 = (this.H[n6 - 1][n6 - 1] - this.H[n6][n6]) / 2.0;
                d8 = d7 * d7 + d4;
                d11 = Math.sqrt(Math.abs(d8));
                this.H[n6][n6] = this.H[n6][n6] + d6;
                this.H[n6 - 1][n6 - 1] = this.H[n6 - 1][n6 - 1] + d6;
                d3 = this.H[n6][n6];
                if (d8 >= 0.0) {
                    d11 = d7 >= 0.0 ? d7 + d11 : d7 - d11;
                    this.d[n6 - 1] = d3 + d11;
                    this.d[n6] = this.d[n6 - 1];
                    if (d11 != 0.0) {
                        this.d[n6] = d3 - d4 / d11;
                    }
                    this.e[n6 - 1] = 0.0;
                    this.e[n6] = 0.0;
                    d3 = this.H[n6][n6 - 1];
                    d10 = Math.abs(d3) + Math.abs(d11);
                    d7 = d3 / d10;
                    d8 = d11 / d10;
                    d9 = Math.sqrt(d7 * d7 + d8 * d8);
                    d7 /= d9;
                    d8 /= d9;
                    for (n2 = n6 - 1; n2 < n5; ++n2) {
                        d11 = this.H[n6 - 1][n2];
                        this.H[n6 - 1][n2] = d8 * d11 + d7 * this.H[n6][n2];
                        this.H[n6][n2] = d8 * this.H[n6][n2] - d7 * d11;
                    }
                    for (n2 = 0; n2 <= n6; ++n2) {
                        d11 = this.H[n2][n6 - 1];
                        this.H[n2][n6 - 1] = d8 * d11 + d7 * this.H[n2][n6];
                        this.H[n2][n6] = d8 * this.H[n2][n6] - d7 * d11;
                    }
                    for (n2 = n7; n2 <= n8; ++n2) {
                        d11 = this.V[n2][n6 - 1];
                        this.V[n2][n6 - 1] = d8 * d11 + d7 * this.V[n2][n6];
                        this.V[n2][n6] = d8 * this.V[n2][n6] - d7 * d11;
                    }
                } else {
                    this.d[n6 - 1] = d3 + d7;
                    this.d[n6] = d3 + d7;
                    this.e[n6 - 1] = d11;
                    this.e[n6] = -d11;
                }
                n6 -= 2;
                n4 = 0;
                continue;
            }
            d3 = this.H[n6][n6];
            d2 = 0.0;
            d4 = 0.0;
            if (n3 < n6) {
                d2 = this.H[n6 - 1][n6 - 1];
                d4 = this.H[n6][n6 - 1] * this.H[n6 - 1][n6];
            }
            if (n4 == 10) {
                d6 += d3;
                n2 = n7;
                while (n2 <= n6) {
                    double[] dArray = this.H[n2];
                    int n10 = n2++;
                    dArray[n10] = dArray[n10] - d3;
                }
                d10 = Math.abs(this.H[n6][n6 - 1]) + Math.abs(this.H[n6 - 1][n6 - 2]);
                d3 = d2 = 0.75 * d10;
                d4 = -0.4375 * d10 * d10;
            }
            if (n4 == 30) {
                d10 = (d2 - d3) / 2.0;
                if ((d10 = d10 * d10 + d4) > 0.0) {
                    d10 = Math.sqrt(d10);
                    if (d2 < d3) {
                        d10 = -d10;
                    }
                    d10 = d3 - d4 / ((d2 - d3) / 2.0 + d10);
                    n2 = n7;
                    while (n2 <= n6) {
                        double[] dArray = this.H[n2];
                        int n11 = n2++;
                        dArray[n11] = dArray[n11] - d10;
                    }
                    d6 += d10;
                    d4 = 0.964;
                    d2 = 0.964;
                    d3 = 0.964;
                }
            }
            ++n4;
            for (n2 = n6 - 2; n2 >= n3; --n2) {
                d11 = this.H[n2][n2];
                d9 = d3 - d11;
                d10 = d2 - d11;
                d7 = (d9 * d10 - d4) / this.H[n2 + 1][n2] + this.H[n2][n2 + 1];
                d8 = this.H[n2 + 1][n2 + 1] - d11 - d9 - d10;
                d9 = this.H[n2 + 2][n2 + 1];
                d10 = Math.abs(d7) + Math.abs(d8) + Math.abs(d9);
                if (n2 == n3 || Math.abs(this.H[n2][n2 - 1]) * (Math.abs(d8 /= d10) + Math.abs(d9 /= d10)) < d5 * (Math.abs(d7 /= d10) * (Math.abs(this.H[n2 - 1][n2 - 1]) + Math.abs(d11) + Math.abs(this.H[n2 + 1][n2 + 1])))) break;
            }
            for (n9 = n2 + 2; n9 <= n6; ++n9) {
                this.H[n9][n9 - 2] = 0.0;
                if (n9 <= n2 + 2) continue;
                this.H[n9][n9 - 3] = 0.0;
            }
            for (n9 = n2; n9 <= n6 - 1; ++n9) {
                int n12;
                boolean bl;
                boolean bl2 = bl = n9 != n6 - 1;
                if (n9 != n2) {
                    d7 = this.H[n9][n9 - 1];
                    d8 = this.H[n9 + 1][n9 - 1];
                    d9 = bl ? this.H[n9 + 2][n9 - 1] : 0.0;
                    d3 = Math.abs(d7) + Math.abs(d8) + Math.abs(d9);
                    if (d3 == 0.0) continue;
                    d7 /= d3;
                    d8 /= d3;
                    d9 /= d3;
                }
                d10 = Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9);
                if (d7 < 0.0) {
                    d10 = -d10;
                }
                if (d10 == 0.0) continue;
                if (n9 != n2) {
                    this.H[n9][n9 - 1] = -d10 * d3;
                } else if (n3 != n2) {
                    this.H[n9][n9 - 1] = -this.H[n9][n9 - 1];
                }
                d3 = (d7 += d10) / d10;
                d2 = d8 / d10;
                d11 = d9 / d10;
                d8 /= d7;
                d9 /= d7;
                for (n12 = n9; n12 < n5; ++n12) {
                    d7 = this.H[n9][n12] + d8 * this.H[n9 + 1][n12];
                    if (bl) {
                        this.H[n9 + 2][n12] = this.H[n9 + 2][n12] - (d7 += d9 * this.H[n9 + 2][n12]) * d11;
                    }
                    this.H[n9][n12] = this.H[n9][n12] - d7 * d3;
                    this.H[n9 + 1][n12] = this.H[n9 + 1][n12] - d7 * d2;
                }
                for (n12 = 0; n12 <= Math.min(n6, n9 + 3); ++n12) {
                    d7 = d3 * this.H[n12][n9] + d2 * this.H[n12][n9 + 1];
                    if (bl) {
                        this.H[n12][n9 + 2] = this.H[n12][n9 + 2] - (d7 += d11 * this.H[n12][n9 + 2]) * d9;
                    }
                    this.H[n12][n9] = this.H[n12][n9] - d7;
                    this.H[n12][n9 + 1] = this.H[n12][n9 + 1] - d7 * d8;
                }
                for (n12 = n7; n12 <= n8; ++n12) {
                    d7 = d3 * this.V[n12][n9] + d2 * this.V[n12][n9 + 1];
                    if (bl) {
                        this.V[n12][n9 + 2] = this.V[n12][n9 + 2] - (d7 += d11 * this.V[n12][n9 + 2]) * d9;
                    }
                    this.V[n12][n9] = this.V[n12][n9] - d7;
                    this.V[n12][n9 + 1] = this.V[n12][n9 + 1] - d7 * d8;
                }
            }
        }
        if (d12 == 0.0) {
            return;
        }
        for (n6 = n5 - 1; n6 >= 0; --n6) {
            double d13;
            d7 = this.d[n6];
            d8 = this.e[n6];
            if (d8 == 0.0) {
                n3 = n6;
                this.H[n6][n6] = 1.0;
                for (n2 = n6 - 1; n2 >= 0; --n2) {
                    int n13;
                    d4 = this.H[n2][n2] - d7;
                    d9 = 0.0;
                    for (n13 = n3; n13 <= n6; ++n13) {
                        d9 += this.H[n2][n13] * this.H[n13][n6];
                    }
                    if (this.e[n2] < 0.0) {
                        d11 = d4;
                        d10 = d9;
                        continue;
                    }
                    n3 = n2;
                    if (this.e[n2] == 0.0) {
                        this.H[n2][n6] = d4 != 0.0 ? -d9 / d4 : -d9 / (d5 * d12);
                    } else {
                        d3 = this.H[n2][n2 + 1];
                        d2 = this.H[n2 + 1][n2];
                        d8 = (this.d[n2] - d7) * (this.d[n2] - d7) + this.e[n2] * this.e[n2];
                        this.H[n2][n6] = d13 = (d3 * d10 - d11 * d9) / d8;
                        this.H[n2 + 1][n6] = Math.abs(d3) > Math.abs(d11) ? (-d9 - d4 * d13) / d3 : (-d10 - d2 * d13) / d11;
                    }
                    d13 = Math.abs(this.H[n2][n6]);
                    if (!(d5 * d13 * d13 > 1.0)) continue;
                    for (n13 = n2; n13 <= n6; ++n13) {
                        this.H[n13][n6] = this.H[n13][n6] / d13;
                    }
                }
                continue;
            }
            if (!(d8 < 0.0)) continue;
            n3 = n6 - 1;
            if (Math.abs(this.H[n6][n6 - 1]) > Math.abs(this.H[n6 - 1][n6])) {
                this.H[n6 - 1][n6 - 1] = d8 / this.H[n6][n6 - 1];
                this.H[n6 - 1][n6] = -(this.H[n6][n6] - d7) / this.H[n6][n6 - 1];
            } else {
                this.cdiv(0.0, -this.H[n6 - 1][n6], this.H[n6 - 1][n6 - 1] - d7, d8);
                this.H[n6 - 1][n6 - 1] = this.cdivr;
                this.H[n6 - 1][n6] = this.cdivi;
            }
            this.H[n6][n6 - 1] = 0.0;
            this.H[n6][n6] = 1.0;
            for (n2 = n6 - 2; n2 >= 0; --n2) {
                int n14;
                double d14 = 0.0;
                double d15 = 0.0;
                for (n14 = n3; n14 <= n6; ++n14) {
                    d14 += this.H[n2][n14] * this.H[n14][n6 - 1];
                    d15 += this.H[n2][n14] * this.H[n14][n6];
                }
                d4 = this.H[n2][n2] - d7;
                if (this.e[n2] < 0.0) {
                    d11 = d4;
                    d9 = d14;
                    d10 = d15;
                    continue;
                }
                n3 = n2;
                if (this.e[n2] == 0.0) {
                    this.cdiv(-d14, -d15, d4, d8);
                    this.H[n2][n6 - 1] = this.cdivr;
                    this.H[n2][n6] = this.cdivi;
                } else {
                    double d16;
                    d3 = this.H[n2][n2 + 1];
                    d2 = this.H[n2 + 1][n2];
                    double d17 = (this.d[n2] - d7) * (this.d[n2] - d7) + this.e[n2] * this.e[n2] - d8 * d8;
                    if (d17 == 0.0 & (d16 = (this.d[n2] - d7) * 2.0 * d8) == 0.0) {
                        d17 = d5 * d12 * (Math.abs(d4) + Math.abs(d8) + Math.abs(d3) + Math.abs(d2) + Math.abs(d11));
                    }
                    this.cdiv(d3 * d9 - d11 * d14 + d8 * d15, d3 * d10 - d11 * d15 - d8 * d14, d17, d16);
                    this.H[n2][n6 - 1] = this.cdivr;
                    this.H[n2][n6] = this.cdivi;
                    if (Math.abs(d3) > Math.abs(d11) + Math.abs(d8)) {
                        this.H[n2 + 1][n6 - 1] = (-d14 - d4 * this.H[n2][n6 - 1] + d8 * this.H[n2][n6]) / d3;
                        this.H[n2 + 1][n6] = (-d15 - d4 * this.H[n2][n6] - d8 * this.H[n2][n6 - 1]) / d3;
                    } else {
                        this.cdiv(-d9 - d2 * this.H[n2][n6 - 1], -d10 - d2 * this.H[n2][n6], d11, d8);
                        this.H[n2 + 1][n6 - 1] = this.cdivr;
                        this.H[n2 + 1][n6] = this.cdivi;
                    }
                }
                d13 = Math.max(Math.abs(this.H[n2][n6 - 1]), Math.abs(this.H[n2][n6]));
                if (!(d5 * d13 * d13 > 1.0)) continue;
                for (n14 = n2; n14 <= n6; ++n14) {
                    this.H[n14][n6 - 1] = this.H[n14][n6 - 1] / d13;
                    this.H[n14][n6] = this.H[n14][n6] / d13;
                }
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (!(n3 < n7 | n3 > n8)) continue;
            for (n2 = n3; n2 < n5; ++n2) {
                this.V[n3][n2] = this.H[n3][n2];
            }
        }
        for (n3 = n5 - 1; n3 >= n7; --n3) {
            for (n2 = n7; n2 <= n8; ++n2) {
                d11 = 0.0;
                for (int i2 = n7; i2 <= Math.min(n3, n8); ++i2) {
                    d11 += this.V[n2][i2] * this.H[i2][n3];
                }
                this.V[n2][n3] = d11;
            }
        }
    }

    public EigenvalueDecomposition(Matrix matrix) {
        int n2;
        double[][] dArray = matrix.getArray();
        this.n = matrix.getColumnDimension();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = true;
        int n3 = 0;
        while (n3 < this.n & this.issymmetric) {
            n2 = 0;
            while (n2 < this.n & this.issymmetric) {
                this.issymmetric = dArray[n2][n3] == dArray[n3][n2];
                ++n2;
            }
            ++n3;
        }
        if (this.issymmetric) {
            for (n3 = 0; n3 < this.n; ++n3) {
                for (n2 = 0; n2 < this.n; ++n2) {
                    this.V[n3][n2] = dArray[n3][n2];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (n3 = 0; n3 < this.n; ++n3) {
                for (n2 = 0; n2 < this.n; ++n2) {
                    this.H[n2][n3] = dArray[n2][n3];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = 0.0;
            }
            dArray[i2][i2] = this.d[i2];
            if (this.e[i2] > 0.0) {
                dArray[i2][i2 + 1] = this.e[i2];
                continue;
            }
            if (!(this.e[i2] < 0.0)) continue;
            dArray[i2][i2 - 1] = this.e[i2];
        }
        return matrix;
    }
}

