/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;
    private static final long serialVersionUID = 1L;

    public LUDecomposition(Matrix matrix) {
        this.LU = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.piv = new int[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            this.piv[i2] = i2;
        }
        this.pivsign = 1;
        double[] dArray = new double[this.m];
        for (int i3 = 0; i3 < this.n; ++i3) {
            double d2;
            int n2;
            int n3;
            for (n3 = 0; n3 < this.m; ++n3) {
                dArray[n3] = this.LU[n3][i3];
            }
            n3 = 0;
            while (n3 < this.m) {
                double[] dArray2 = this.LU[n3];
                n2 = Math.min(n3, i3);
                d2 = 0.0;
                for (int i4 = 0; i4 < n2; ++i4) {
                    d2 += dArray2[i4] * dArray[i4];
                }
                int n4 = n3++;
                double d3 = dArray[n4] - d2;
                dArray[n4] = d3;
                dArray2[i3] = d3;
            }
            n3 = i3;
            for (n2 = i3 + 1; n2 < this.m; ++n2) {
                if (!(Math.abs(dArray[n2]) > Math.abs(dArray[n3]))) continue;
                n3 = n2;
            }
            if (n3 != i3) {
                for (n2 = 0; n2 < this.n; ++n2) {
                    d2 = this.LU[n3][n2];
                    this.LU[n3][n2] = this.LU[i3][n2];
                    this.LU[i3][n2] = d2;
                }
                n2 = this.piv[n3];
                this.piv[n3] = this.piv[i3];
                this.piv[i3] = n2;
                this.pivsign = -this.pivsign;
            }
            if (!(i3 < this.m & this.LU[i3][i3] != 0.0)) continue;
            for (n2 = i3 + 1; n2 < this.m; ++n2) {
                double[] dArray3 = this.LU[n2];
                int n5 = i3;
                dArray3[n5] = dArray3[n5] / this.LU[i3][i3];
            }
        }
    }

    public boolean isNonsingular() {
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.LU[i2][i2] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = i2 > i3 ? this.LU[i2][i3] : (i2 == i3 ? 1.0 : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getU() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = i2 <= i3 ? this.LU[i2][i3] : 0.0;
            }
        }
        return matrix;
    }

    public int[] getPivot() {
        int[] nArray = new int[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            nArray[i2] = this.piv[i2];
        }
        return nArray;
    }

    public double[] getDoublePivot() {
        double[] dArray = new double[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            dArray[i2] = this.piv[i2];
        }
        return dArray;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d2 = this.pivsign;
        for (int i2 = 0; i2 < this.n; ++i2) {
            d2 *= this.LU[i2][i2];
        }
        return d2;
    }

    public Matrix solve(Matrix matrix) {
        int n2;
        int n3;
        int n4;
        if (matrix.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int n5 = matrix.getColumnDimension();
        Matrix matrix2 = matrix.getMatrix(this.piv, 0, n5 - 1);
        double[][] dArray = matrix2.getArray();
        for (n4 = 0; n4 < this.n; ++n4) {
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    double[] dArray2 = dArray[n3];
                    int n6 = n2;
                    dArray2[n6] = dArray2[n6] - dArray[n4][n2] * this.LU[n3][n4];
                }
            }
        }
        for (n4 = this.n - 1; n4 >= 0; --n4) {
            n3 = 0;
            while (n3 < n5) {
                double[] dArray3 = dArray[n4];
                int n7 = n3++;
                dArray3[n7] = dArray3[n7] / this.LU[n4][n4];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    double[] dArray4 = dArray[n3];
                    int n8 = n2;
                    dArray4[n8] = dArray4[n8] - dArray[n4][n2] * this.LU[n3][n4];
                }
            }
        }
        return matrix2;
    }
}

