/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.StepDefinition;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import water.Iced;
import water.util.ArrayUtils;

public abstract class ModelingSteps
extends Iced<ModelingSteps> {
    private transient AutoML _aml;

    public ModelingSteps(AutoML autoML) {
        this._aml = autoML;
    }

    protected AutoML aml() {
        return this._aml;
    }

    public Optional<ModelingStep> getStep(String id) {
        return Stream.of(this.getAllSteps()).map(step -> step._id.equals(id) ? Optional.of(step) : step.getSubStep(id)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    protected ModelingStep[] getSteps(StepDefinition.Step[] steps) {
        ArrayList tSteps = new ArrayList();
        for (StepDefinition.Step step : steps) {
            this.getStep(step._id).ifPresent(tStep -> {
                if (step._weight != -1) {
                    tStep._weight = step._weight;
                }
                if (step._group != -1) {
                    tStep._priorityGroup = step._group;
                }
                tSteps.add(tStep);
            });
        }
        return tSteps.toArray(new ModelingStep[0]);
    }

    protected ModelingStep[] getSteps(StepDefinition.Alias alias2) {
        switch (alias2) {
            case all: {
                return this.getAllSteps();
            }
            case defaults: {
                return this.getDefaultModels();
            }
            case grids: {
                return this.getGrids();
            }
            case optionals: 
            case exploitation: {
                return this.getOptionals();
            }
        }
        return new ModelingStep[0];
    }

    protected ModelingStep[] getAllSteps() {
        ModelingStep[] all = new ModelingStep[]{};
        all = ArrayUtils.append(all, this.getDefaultModels());
        all = ArrayUtils.append(all, this.getGrids());
        all = ArrayUtils.append(all, this.getOptionals());
        return all;
    }

    protected ModelingStep[] getDefaultModels() {
        return new ModelingStep[0];
    }

    protected ModelingStep[] getGrids() {
        return new ModelingStep[0];
    }

    protected ModelingStep[] getOptionals() {
        return new ModelingStep[0];
    }

    public abstract String getProvider();

    protected void cleanup() {
    }
}

