/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import water.Iced;

public class StepDefinition
extends Iced<StepDefinition> {
    String _name;
    Alias _alias;
    Step[] _steps;

    public StepDefinition() {
    }

    public StepDefinition(String name) {
        this(name, Alias.all);
    }

    public StepDefinition(String name, Alias alias2) {
        this._name = name;
        this._alias = alias2;
    }

    public StepDefinition(String name, String ... ids) {
        this._name = name;
        this._steps = new Step[ids.length];
        for (int i2 = 0; i2 < ids.length; ++i2) {
            this._steps[i2] = new Step(ids[i2]);
        }
    }

    public StepDefinition(String name, Step ... steps) {
        this._name = name;
        this._steps = steps;
    }

    public String getName() {
        return this._name;
    }

    public Alias getAlias() {
        return this._alias;
    }

    public List<Step> getSteps() {
        return this._steps == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this._steps));
    }

    public String toString() {
        return "{" + this._name + " : " + (this._steps == null ? this._alias : Arrays.toString(this._steps)) + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        StepDefinition that = (StepDefinition)o2;
        return this._name.equals(that._name) && this._alias == that._alias && Arrays.equals(this._steps, that._steps);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this._name, this._alias});
        result = 31 * result + Arrays.hashCode(this._steps);
        return result;
    }

    public static class Step
    extends Iced<Step> {
        public static final int DEFAULT_GROUP = -1;
        public static final int DEFAULT_WEIGHT = -1;
        String _id;
        int _group = -1;
        int _weight = -1;

        public Step() {
        }

        public Step(String _id) {
            this._id = _id;
        }

        public Step(String id, int group2, int weight) {
            assert (group2 == -1 || group2 >= 0) : "non-default group must be >= 0";
            assert (weight == -1 || weight >= 0) : "non-default weight must be >= 0";
            this._id = id;
            this._group = group2;
            this._weight = weight;
        }

        public String getId() {
            return this._id;
        }

        public int getGroup() {
            return this._group;
        }

        public int getWeight() {
            return this._weight;
        }

        public String toString() {
            String s2 = this._id;
            if (this._group > -1 || this._weight > -1) {
                s2 = s2 + " (";
                String sep = "";
                if (this._group > -1) {
                    s2 = s2 + sep + this._group + "g";
                    sep = ", ";
                }
                if (this._weight > -1) {
                    s2 = s2 + sep + this._weight + "w";
                    sep = ", ";
                }
                s2 = s2 + ")";
            }
            return s2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Step step = (Step)o2;
            return this._id.equals(step._id) && this._group == step._group && this._weight == step._weight;
        }

        public int hashCode() {
            return Objects.hash(this._id, this._group, this._weight);
        }
    }

    public static enum Alias {
        all,
        defaults,
        grids,
        exploitation,
        optionals;

    }
}

