/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.events;

import ai.h2o.automl.AutoML;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import water.Iced;
import water.Key;
import water.logging.LoggingLevel;
import water.util.TwoDimTable;

public class EventLogEntry<V extends Serializable>
extends Iced {
    public static final ThreadLocal<Format> epochFormat = ThreadLocal.withInitial(() -> new SimpleFormat<Date>(){

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo) {
            long epoch = Math.round((double)date.getTime() / 1000.0);
            toAppendTo.append(epoch);
            return toAppendTo;
        }
    });
    public static final ThreadLocal<SimpleDateFormat> dateTimeISOFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    public static final ThreadLocal<SimpleDateFormat> dateTimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S"));
    public static final ThreadLocal<SimpleDateFormat> timeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm:ss.S"));
    private static final String[] colHeaders = new String[]{"timestamp", "level", "stage", "message", "name", "value"};
    private static final String[] colTypes = new String[]{"string", "string", "string", "string", "string", "string"};
    private static final String[] colFormats = new String[]{"%s", "%s", "%s", "%s", "%s", "%s"};
    private final int longestLevel = EventLogEntry.longest(LoggingLevel.class);
    private final int longestStage = EventLogEntry.longest(Stage.class);
    private Key<AutoML> _automlKey;
    private long _timestamp;
    private LoggingLevel _level;
    private Stage _stage;
    private String _message;
    private String _name;
    private V _value;
    private Format _valueFormatter;

    static TwoDimTable makeTwoDimTable(String tableHeader, int length) {
        String[] rowHeaders = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            rowHeaders[i2] = "" + i2;
        }
        return new TwoDimTable(tableHeader, "Actions taken and discoveries made by AutoML", rowHeaders, colHeaders, colTypes, colFormats, "#");
    }

    static String nowStr() {
        return dateTimeFormat.get().format(new Date());
    }

    private static <E extends Enum<E>> int longest(Class<E> enu) {
        int longest = -1;
        for (Enum v2 : (Enum[])enu.getEnumConstants()) {
            longest = Math.max(longest, v2.name().length());
        }
        return longest;
    }

    public Key<AutoML> getAutomlKey() {
        return this._automlKey;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public LoggingLevel getLevel() {
        return this._level;
    }

    public Stage getStage() {
        return this._stage;
    }

    public String getMessage() {
        return this._message;
    }

    public String getName() {
        return this._name;
    }

    public V getValue() {
        return this._value;
    }

    public Format getValueFormatter() {
        return this._valueFormatter;
    }

    public EventLogEntry(Key<AutoML> automlKey, LoggingLevel level, Stage stage, String message) {
        this._automlKey = automlKey;
        this._timestamp = System.currentTimeMillis();
        this._level = level;
        this._stage = stage;
        this._message = message;
    }

    public void setNamedValue(String name, V value) {
        this.setNamedValue(name, value, null);
    }

    public void setNamedValue(String name, V value, Format formatter) {
        this._name = name;
        this._value = value;
        this._valueFormatter = formatter;
    }

    void addTwoDimTableRow(TwoDimTable table, int row) {
        int col = 0;
        table.set(row, col++, timeFormat.get().format(new Date(this._timestamp)));
        table.set(row, col++, (Object)this._level);
        table.set(row, col++, (Object)this._stage);
        table.set(row, col++, this._message);
        table.set(row, col++, this._name);
        table.set(row, col++, this._valueFormatter == null ? this._value : this._valueFormatter.format(this._value));
    }

    public String toString() {
        return String.format("%-12s %-" + this.longestLevel + "s %-" + this.longestStage + "s %s %s %s", new Object[]{timeFormat.get().format(new Date(this._timestamp)), this._level, this._stage, Objects.toString(this._message, ""), Objects.toString(this._name, ""), this._valueFormatter == null ? Objects.toString(this._value, "") : this._valueFormatter.format(this._value)});
    }

    static abstract class SimpleFormat<T>
    extends Format {
        SimpleFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
            this.format(obj, toAppendTo);
            return toAppendTo;
        }

        public abstract StringBuffer format(T var1, StringBuffer var2);

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    public static enum Stage {
        Validation,
        Workflow,
        DataImport,
        FeatureAnalysis,
        FeatureReduction,
        FeatureCreation,
        ModelTraining,
        ModelSelection;

    }
}

