/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.leaderboard;

import ai.h2o.automl.leaderboard.LeaderboardCell;
import ai.h2o.automl.leaderboard.LeaderboardColumn;
import hex.Model;
import water.Iced;
import water.Key;
import water.util.Log;

public class TrainingTime
extends Iced<TrainingTime>
implements LeaderboardCell<Long, TrainingTime> {
    public static final LeaderboardColumn COLUMN = new LeaderboardColumn("training_time_ms", "long", "%s");
    private final Key<Model> _modelId;
    private Long _trainingTimeMillis;

    public TrainingTime(Model model) {
        this._modelId = model._key;
        this._trainingTimeMillis = ((Model.Output)model._output)._run_time;
    }

    public TrainingTime(Key<Model> modelId) {
        this._modelId = modelId;
    }

    @Override
    public LeaderboardColumn getColumn() {
        return COLUMN;
    }

    @Override
    public Key<Model> getModelId() {
        return this._modelId;
    }

    @Override
    public Long getValue() {
        return this._trainingTimeMillis;
    }

    @Override
    public void setValue(Long value) {
        this._trainingTimeMillis = value;
    }

    @Override
    public boolean isNA() {
        return this.getValue() == null || this.getValue() < 0L;
    }

    @Override
    public Long fetch() {
        if (this.getValue() == null) {
            try {
                this.setValue(((Model.Output)this._modelId.get()._output)._run_time);
            }
            catch (Exception e2) {
                Log.err("Could not retrieve training time for model " + this._modelId, e2);
                this.setValue(-1L);
            }
        }
        return this.getValue();
    }
}

