/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.modeling;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelParametersProvider;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import hex.tree.SharedTreeModel;
import hex.tree.drf.DRFModel;
import water.Job;
import water.Key;

public class DRFStepsProvider
implements ModelingStepsProvider<DRFSteps>,
ModelParametersProvider<DRFModel.DRFParameters> {
    @Override
    public String getName() {
        return DRFSteps.NAME;
    }

    @Override
    public DRFSteps newInstance(AutoML aml) {
        return new DRFSteps(aml);
    }

    @Override
    public DRFModel.DRFParameters newDefaultParameters() {
        return new DRFModel.DRFParameters();
    }

    public static class DRFSteps
    extends ModelingSteps {
        static final String NAME = Algo.DRF.name();
        private final ModelingStep[] defaults = new DRFModelStep[]{new DRFModelStep("def_1", this.aml()){}, new DRFModelStep("XRT", this.aml()){
            {
                super(id, autoML);
                this._description = this._description + " (Extremely Randomized Trees)";
            }

            @Override
            public DRFModel.DRFParameters prepareModelParameters() {
                DRFModel.DRFParameters params = super.prepareModelParameters();
                params._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.Random;
                return params;
            }

            @Override
            protected Job<DRFModel> startJob() {
                Key key = this.makeKey("XRT", true);
                return this.trainModel(key, this.prepareModelParameters());
            }
        }};

        public DRFSteps(AutoML autoML) {
            super(autoML);
        }

        @Override
        public String getProvider() {
            return NAME;
        }

        @Override
        protected ModelingStep[] getDefaultModels() {
            return this.defaults;
        }

        static abstract class DRFModelStep
        extends ModelingStep.ModelStep<DRFModel> {
            DRFModelStep(String id, AutoML autoML) {
                super(NAME, Algo.DRF, id, autoML);
            }

            @Override
            public DRFModel.DRFParameters prepareModelParameters() {
                DRFModel.DRFParameters params = new DRFModel.DRFParameters();
                params._score_tree_interval = 5;
                return params;
            }
        }
    }
}

