/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.auth;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.SignableRequest;
import ai.h2o.com.amazonaws.auth.AWSCredentials;
import ai.h2o.com.amazonaws.auth.AWSSessionCredentials;
import ai.h2o.com.amazonaws.auth.AbstractAWSSigner;
import ai.h2o.com.amazonaws.auth.AnonymousAWSCredentials;
import ai.h2o.com.amazonaws.auth.SigningAlgorithm;
import ai.h2o.com.amazonaws.log.InternalLogApi;
import ai.h2o.com.amazonaws.log.InternalLogFactory;
import ai.h2o.com.amazonaws.util.DateUtils;
import ai.h2o.com.amazonaws.util.SdkHttpUtils;
import ai.h2o.com.amazonaws.util.StringUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class AWS3Signer
extends AbstractAWSSigner {
    private static final String AUTHORIZATION_HEADER = "X-Amzn-Authorization";
    private static final String NONCE_HEADER = "x-amz-nonce";
    private static final String HTTP_SCHEME = "AWS3";
    private static final String HTTPS_SCHEME = "AWS3-HTTPS";
    private String overriddenDate;
    @Deprecated
    protected static final DateUtils dateUtils = new DateUtils();
    private static final InternalLogApi log = InternalLogFactory.getLog(AWS3Signer.class);

    @Override
    public void sign(SignableRequest<?> request2, AWSCredentials credentials) throws SdkClientException {
        byte[] bytesToSign;
        String stringToSign;
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        SigningAlgorithm algorithm = SigningAlgorithm.HmacSHA256;
        String nonce = UUID.randomUUID().toString();
        int timeOffset = request2.getTimeOffset();
        Date dateValue = this.getSignatureDate(timeOffset);
        String date = DateUtils.formatRFC822Date(dateValue);
        boolean isHttps = false;
        if (this.overriddenDate != null) {
            date = this.overriddenDate;
        }
        request2.addHeader("Date", date);
        request2.addHeader("X-Amz-Date", date);
        String hostHeader = request2.getEndpoint().getHost();
        if (SdkHttpUtils.isUsingNonDefaultPort(request2.getEndpoint())) {
            hostHeader = hostHeader + ":" + request2.getEndpoint().getPort();
        }
        request2.addHeader("Host", hostHeader);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request2, (AWSSessionCredentials)sanitizedCredentials);
        }
        if (isHttps) {
            request2.addHeader(NONCE_HEADER, nonce);
            stringToSign = date + nonce;
            bytesToSign = stringToSign.getBytes(StringUtils.UTF8);
        } else {
            String path = SdkHttpUtils.appendUri(request2.getEndpoint().getPath(), request2.getResourcePath());
            stringToSign = request2.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(path) + "\n" + this.getCanonicalizedQueryString(request2.getParameters()) + "\n" + this.getCanonicalizedHeadersForStringToSign(request2) + "\n" + this.getRequestPayloadWithoutQueryParams(request2);
            bytesToSign = this.hash(stringToSign);
        }
        if (log.isDebugEnabled()) {
            log.debug("Calculated StringToSign: " + stringToSign);
        }
        String signature = this.signAndBase64Encode(bytesToSign, sanitizedCredentials.getAWSSecretKey(), algorithm);
        StringBuilder builder = new StringBuilder();
        builder.append(isHttps ? HTTPS_SCHEME : HTTP_SCHEME).append(" ");
        builder.append("AWSAccessKeyId=" + sanitizedCredentials.getAWSAccessKeyId() + ",");
        builder.append("Algorithm=" + algorithm.toString() + ",");
        if (!isHttps) {
            builder.append(this.getSignedHeadersComponent(request2) + ",");
        }
        builder.append("Signature=" + signature);
        request2.addHeader(AUTHORIZATION_HEADER, builder.toString());
    }

    private String getSignedHeadersComponent(SignableRequest<?> request2) {
        StringBuilder builder = new StringBuilder();
        builder.append("SignedHeaders=");
        boolean first = true;
        for (String header : this.getHeadersForStringToSign(request2)) {
            if (!first) {
                builder.append(";");
            }
            builder.append(header);
            first = false;
        }
        return builder.toString();
    }

    protected List<String> getHeadersForStringToSign(SignableRequest<?> request2) {
        ArrayList<String> headersToSign = new ArrayList<String>();
        for (Map.Entry<String, String> entry : request2.getHeaders().entrySet()) {
            String key = entry.getKey();
            String lowerCaseKey = StringUtils.lowerCase(key);
            if (!lowerCaseKey.startsWith("x-amz") && !lowerCaseKey.equals("host")) continue;
            headersToSign.add(key);
        }
        Collections.sort(headersToSign);
        return headersToSign;
    }

    void overrideDate(String date) {
        this.overriddenDate = date;
    }

    protected String getCanonicalizedHeadersForStringToSign(SignableRequest<?> request2) {
        List<String> headersToSign = this.getHeadersForStringToSign(request2);
        for (int i2 = 0; i2 < headersToSign.size(); ++i2) {
            headersToSign.set(i2, StringUtils.lowerCase(headersToSign.get(i2)));
        }
        TreeMap<String, String> sortedHeaderMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : request2.getHeaders().entrySet()) {
            if (!headersToSign.contains(StringUtils.lowerCase(entry.getKey()))) continue;
            sortedHeaderMap.put(StringUtils.lowerCase(entry.getKey()), entry.getValue());
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : sortedHeaderMap.entrySet()) {
            builder.append(StringUtils.lowerCase((String)entry.getKey())).append(":").append((String)entry.getValue()).append("\n");
        }
        return builder.toString();
    }

    protected boolean shouldUseHttpsScheme(SignableRequest<?> request2) throws SdkClientException {
        try {
            String protocol = StringUtils.lowerCase(request2.getEndpoint().toURL().getProtocol());
            if (protocol.equals("http")) {
                return false;
            }
            if (protocol.equals("https")) {
                return true;
            }
            throw new SdkClientException("Unknown request endpoint protocol encountered while signing request: " + protocol);
        }
        catch (MalformedURLException e2) {
            throw new SdkClientException("Unable to parse request endpoint during signing", e2);
        }
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> request2, AWSSessionCredentials credentials) {
        request2.addHeader("x-amz-security-token", credentials.getSessionToken());
    }
}

