/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.auth;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.SignableRequest;
import ai.h2o.com.amazonaws.auth.AWSCredentials;
import ai.h2o.com.amazonaws.auth.AWSSessionCredentials;
import ai.h2o.com.amazonaws.auth.AbstractAWSSigner;
import ai.h2o.com.amazonaws.auth.AnonymousAWSCredentials;
import ai.h2o.com.amazonaws.auth.SignatureVersion;
import ai.h2o.com.amazonaws.auth.Signer;
import ai.h2o.com.amazonaws.auth.SigningAlgorithm;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class QueryStringSigner
extends AbstractAWSSigner
implements Signer {
    private Date overriddenDate;

    @Override
    public void sign(SignableRequest<?> request2, AWSCredentials credentials) throws SdkClientException {
        this.sign(request2, SignatureVersion.V2, SigningAlgorithm.HmacSHA256, credentials);
    }

    public void sign(SignableRequest<?> request2, SignatureVersion version, SigningAlgorithm algorithm, AWSCredentials credentials) throws SdkClientException {
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        request2.addParameter("AWSAccessKeyId", sanitizedCredentials.getAWSAccessKeyId());
        request2.addParameter("SignatureVersion", version.toString());
        int timeOffset = request2.getTimeOffset();
        request2.addParameter("Timestamp", this.getFormattedTimestamp(timeOffset));
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request2, (AWSSessionCredentials)sanitizedCredentials);
        }
        String stringToSign = null;
        if (version.equals((Object)SignatureVersion.V1)) {
            stringToSign = this.calculateStringToSignV1(request2.getParameters());
        } else if (version.equals((Object)SignatureVersion.V2)) {
            request2.addParameter("SignatureMethod", algorithm.toString());
            stringToSign = this.calculateStringToSignV2(request2);
        } else {
            throw new SdkClientException("Invalid Signature Version specified");
        }
        String signatureValue = this.signAndBase64Encode(stringToSign, sanitizedCredentials.getAWSSecretKey(), algorithm);
        request2.addParameter("Signature", signatureValue);
    }

    private String calculateStringToSignV1(Map<String, List<String>> parameters) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, List<String>> sorted = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (Map.Entry entry : sorted.entrySet()) {
            for (String value : (List)entry.getValue()) {
                data.append((String)entry.getKey()).append(value);
            }
        }
        return data.toString();
    }

    private String calculateStringToSignV2(SignableRequest<?> request2) throws SdkClientException {
        URI endpoint = request2.getEndpoint();
        StringBuilder data = new StringBuilder();
        data.append("POST").append("\n").append(this.getCanonicalizedEndpoint(endpoint)).append("\n").append(this.getCanonicalizedResourcePath(request2)).append("\n").append(this.getCanonicalizedQueryString(request2.getParameters()));
        return data.toString();
    }

    private String getCanonicalizedResourcePath(SignableRequest<?> request2) {
        String resourcePath = "";
        if (request2.getEndpoint().getPath() != null) {
            resourcePath = resourcePath + request2.getEndpoint().getPath();
        }
        if (request2.getResourcePath() != null) {
            if (resourcePath.length() > 0 && !resourcePath.endsWith("/") && !request2.getResourcePath().startsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            resourcePath = resourcePath + request2.getResourcePath();
        } else if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if (resourcePath.startsWith("//")) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    private String getFormattedTimestamp(int offset) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.overriddenDate != null) {
            return df.format(this.overriddenDate);
        }
        return df.format(this.getSignatureDate(offset));
    }

    void overrideDate(Date date) {
        this.overriddenDate = date;
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> request2, AWSSessionCredentials credentials) {
        request2.addParameter("SecurityToken", credentials.getSessionToken());
    }
}

