/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.auth;

import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.annotation.ThreadSafe;
import ai.h2o.com.amazonaws.auth.SessionCredentialsHolder;
import ai.h2o.com.amazonaws.internal.SdkPredicate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
@ThreadSafe
class ShouldDoAsyncSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final long ASYNC_REFRESH_EXPIRATION_IN_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    ShouldDoAsyncSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        Date expiryTime = sessionCredentialsHolder.getSessionCredentialsExpiration();
        if (expiryTime != null) {
            long timeRemaining = expiryTime.getTime() - System.currentTimeMillis();
            return timeRemaining < ASYNC_REFRESH_EXPIRATION_IN_MILLIS;
        }
        return false;
    }
}

