/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.auth.presign;

import ai.h2o.com.amazonaws.AmazonWebServiceRequest;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.annotation.Immutable;
import ai.h2o.com.amazonaws.annotation.SdkProtectedApi;
import ai.h2o.com.amazonaws.auth.AWSCredentialsProvider;
import ai.h2o.com.amazonaws.auth.Presigner;
import ai.h2o.com.amazonaws.auth.presign.PresignerParams;
import ai.h2o.com.amazonaws.internal.auth.SignerProvider;
import ai.h2o.com.amazonaws.internal.auth.SignerProviderContext;
import ai.h2o.com.amazonaws.util.CredentialUtils;
import ai.h2o.com.amazonaws.util.RuntimeHttpUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Immutable
@SdkProtectedApi
public final class PresignerFacade {
    private final AWSCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;

    public PresignerFacade(PresignerParams presignerParams) {
        this.credentialsProvider = presignerParams.credentialsProvider();
        this.signerProvider = presignerParams.signerProvider();
    }

    public URL presign(Request<?> request2, Date expirationDate) {
        Presigner presigner = (Presigner)((Object)this.signerProvider.getSigner(SignerProviderContext.builder().withIsRedirect(false).withRequest(request2).withUri(request2.getEndpoint()).build()));
        if (request2.getOriginalRequest() != null) {
            this.addCustomQueryParams(request2);
            this.addCustomHeaders(request2);
        }
        AWSCredentialsProvider credentialsProvider = this.resolveCredentials(request2);
        presigner.presignRequest(request2, credentialsProvider.getCredentials(), expirationDate);
        return RuntimeHttpUtils.convertRequestToUrl(request2, true, false);
    }

    private void addCustomQueryParams(Request<?> request2) {
        Map<String, List<String>> queryParameters = request2.getOriginalRequest().getCustomQueryParameters();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> param : queryParameters.entrySet()) {
            request2.addParameters(param.getKey(), param.getValue());
        }
    }

    private void addCustomHeaders(Request<?> request2) {
        Map<String, String> headers = request2.getOriginalRequest().getCustomRequestHeaders();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request2.addHeader(header.getKey(), header.getValue());
        }
    }

    private AWSCredentialsProvider resolveCredentials(Request<?> request2) {
        return CredentialUtils.getCredentialsProvider(request2.getOriginalRequest(), this.credentialsProvider);
    }

    public static class PresigningRequest
    extends AmazonWebServiceRequest {
        public PresigningRequest withRequestCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.setRequestCredentialsProvider(credentialsProvider);
            return this;
        }
    }
}

