/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.handlers;

import ai.h2o.com.amazonaws.AmazonWebServiceRequest;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.Response;
import ai.h2o.com.amazonaws.annotation.ThreadSafe;
import ai.h2o.com.amazonaws.handlers.HandlerAfterAttemptContext;
import ai.h2o.com.amazonaws.handlers.HandlerBeforeAttemptContext;
import ai.h2o.com.amazonaws.handlers.IRequestHandler2;
import ai.h2o.com.amazonaws.handlers.RequestHandler2;
import ai.h2o.com.amazonaws.http.HttpResponse;
import ai.h2o.com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ThreadSafe
public class StackedRequestHandler
implements IRequestHandler2 {
    private final List<RequestHandler2> inOrderRequestHandlers;
    private final List<RequestHandler2> reverseOrderRequestHandlers;

    public StackedRequestHandler(RequestHandler2 ... requestHandlers) {
        this(Arrays.asList((Object[])ValidationUtils.assertNotNull(requestHandlers, "requestHandlers")));
    }

    public StackedRequestHandler(List<RequestHandler2> requestHandlers) {
        this.inOrderRequestHandlers = ValidationUtils.assertNotNull(requestHandlers, "requestHandlers");
        this.reverseOrderRequestHandlers = new ArrayList<RequestHandler2>(requestHandlers);
        Collections.reverse(this.reverseOrderRequestHandlers);
    }

    @Override
    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest origRequest) {
        AmazonWebServiceRequest toReturn = origRequest;
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            toReturn = handler.beforeExecution(toReturn);
        }
        return toReturn;
    }

    @Override
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest origRequest) {
        AmazonWebServiceRequest toReturn = origRequest;
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            toReturn = handler.beforeMarshalling(toReturn);
        }
        return toReturn;
    }

    @Override
    public void beforeRequest(Request<?> request2) {
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            handler.beforeRequest(request2);
        }
    }

    @Override
    public void beforeAttempt(HandlerBeforeAttemptContext context) {
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            handler.beforeAttempt(context);
        }
    }

    @Override
    public HttpResponse beforeUnmarshalling(Request<?> request2, HttpResponse origHttpResponse) {
        HttpResponse toReturn = origHttpResponse;
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            toReturn = handler.beforeUnmarshalling(request2, toReturn);
        }
        return toReturn;
    }

    @Override
    public void afterAttempt(HandlerAfterAttemptContext context) {
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            handler.afterAttempt(context);
        }
    }

    @Override
    public void afterResponse(Request<?> request2, Response<?> response) {
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            handler.afterResponse(request2, response);
        }
    }

    @Override
    public void afterError(Request<?> request2, Response<?> response, Exception e2) {
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            handler.afterError(request2, response, e2);
        }
    }
}

