/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.http.apache;

import ai.h2o.com.amazonaws.Protocol;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.util.StringUtils;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpHost;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.impl.conn.DefaultRoutePlanner;
import ai.h2o.org.apache.http.impl.conn.DefaultSchemePortResolver;
import ai.h2o.org.apache.http.protocol.HttpContext;

@SdkInternalApi
public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private String[] hostPatterns;

    public SdkProxyRoutePlanner(String proxyHost, int proxyPort, Protocol proxyProtocol, String nonProxyHosts) {
        super(DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(proxyHost, proxyPort, proxyProtocol.toString());
        this.parseNonProxyHosts(nonProxyHosts);
    }

    private void parseNonProxyHosts(String nonProxyHosts) {
        if (!StringUtils.isNullOrEmpty(nonProxyHosts)) {
            String[] hosts = nonProxyHosts.split("\\|");
            this.hostPatterns = new String[hosts.length];
            for (int i2 = 0; i2 < hosts.length; ++i2) {
                this.hostPatterns[i2] = hosts[i2].toLowerCase().replace("*", ".*?");
            }
        }
    }

    boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (this.hostPatterns == null) {
            return false;
        }
        String targetHost = target.getHostName().toLowerCase();
        for (String pattern : this.hostPatterns) {
            if (!targetHost.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request2, HttpContext context) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(target) ? null : this.proxy;
    }
}

