/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.http.apache.request.impl;

import ai.h2o.com.amazonaws.ProxyAuthenticationMethod;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.handlers.HandlerContextKey;
import ai.h2o.com.amazonaws.http.HttpMethodName;
import ai.h2o.com.amazonaws.http.RepeatableInputStreamRequestEntity;
import ai.h2o.com.amazonaws.http.apache.request.impl.HttpGetWithBody;
import ai.h2o.com.amazonaws.http.apache.utils.ApacheUtils;
import ai.h2o.com.amazonaws.http.request.HttpRequestFactory;
import ai.h2o.com.amazonaws.http.settings.HttpClientSettings;
import ai.h2o.com.amazonaws.util.FakeIOException;
import ai.h2o.com.amazonaws.util.SdkHttpUtils;
import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.client.config.RequestConfig;
import ai.h2o.org.apache.http.client.methods.HttpDelete;
import ai.h2o.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import ai.h2o.org.apache.http.client.methods.HttpHead;
import ai.h2o.org.apache.http.client.methods.HttpOptions;
import ai.h2o.org.apache.http.client.methods.HttpPatch;
import ai.h2o.org.apache.http.client.methods.HttpPost;
import ai.h2o.org.apache.http.client.methods.HttpPut;
import ai.h2o.org.apache.http.client.methods.HttpRequestBase;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ApacheHttpRequestFactory
implements HttpRequestFactory<HttpRequestBase> {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String QUERY_PARAM_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=" + "UTF-8".toLowerCase();
    private static final List<String> ignoreHeaders = Arrays.asList("Content-Length", "Host");

    @Override
    public HttpRequestBase create(Request<?> request2, HttpClientSettings settings) throws FakeIOException {
        HttpRequestBase base;
        String endpointUri = this.getUriEndpoint(request2);
        String encodedParams = SdkHttpUtils.encodeParameters(request2);
        if (this.shouldMoveQueryParametersToBody(request2, encodedParams)) {
            base = this.createPostParamsInBodyRequest(endpointUri, encodedParams);
            this.addHeadersToRequest(base, request2);
            this.addContentTypeHeaderIfNeeded(base);
        } else {
            if (encodedParams != null) {
                endpointUri = endpointUri + "?" + encodedParams;
            }
            base = this.createStandardRequest(request2, endpointUri);
            this.addHeadersToRequest(base, request2);
        }
        this.addRequestConfig(base, request2, settings);
        return base;
    }

    private String getUriEndpoint(Request<?> request2) {
        URI endpoint = request2.getEndpoint();
        if (request2.getOriginalRequest().getRequestClientOptions().isSkipAppendUriPath()) {
            return endpoint.toString();
        }
        return SdkHttpUtils.appendUri(endpoint.toString(), request2.getResourcePath(), true);
    }

    private void addRequestConfig(HttpRequestBase base, Request<?> request2, HttpClientSettings settings) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(settings.getConnectionPoolRequestTimeout()).setConnectTimeout(settings.getConnectionTimeout()).setSocketTimeout(settings.getSocketTimeout()).setLocalAddress(settings.getLocalAddress());
        ApacheUtils.disableNormalizeUri(requestConfigBuilder);
        if (HttpMethodName.PUT == request2.getHttpMethod() && settings.isUseExpectContinue()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        this.addProxyConfig(requestConfigBuilder, settings);
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createStandardRequest(Request<?> request2, String uri) throws FakeIOException {
        switch (request2.getHttpMethod()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return this.wrapEntity(request2, new HttpGetWithBody(uri));
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request2, new HttpPatch(uri));
            }
            case POST: {
                return this.wrapEntity(request2, new HttpPost(uri));
            }
            case PUT: {
                return this.wrapEntity(request2, new HttpPut(uri));
            }
        }
        throw new SdkClientException("Unknown HTTP method name: " + (Object)((Object)request2.getHttpMethod()));
    }

    private HttpRequestBase wrapEntity(Request<?> request2, HttpEntityEnclosingRequestBase entityEnclosingRequest) throws FakeIOException {
        if (HttpMethodName.POST == request2.getHttpMethod()) {
            this.createHttpEntityForPostVerb(request2, entityEnclosingRequest);
        } else if (request2.getContent() != null) {
            this.createHttpEntityForNonPostVerbs(request2, entityEnclosingRequest);
        }
        return entityEnclosingRequest;
    }

    private void createHttpEntityForPostVerb(Request<?> request2, HttpEntityEnclosingRequestBase entityEnclosingRequest) throws FakeIOException {
        HttpEntity entity = new RepeatableInputStreamRequestEntity(request2);
        if (request2.getHeaders().get("Content-Length") == null && this.isRequiresLength(request2)) {
            entity = ApacheUtils.newBufferedHttpEntity(entity);
        }
        entityEnclosingRequest.setEntity(entity);
    }

    private void createHttpEntityForNonPostVerbs(Request<?> request2, HttpEntityEnclosingRequestBase entityEnclosingRequest) throws FakeIOException {
        HttpEntity entity = new RepeatableInputStreamRequestEntity(request2);
        if (request2.getHeaders().get("Content-Length") == null && (this.isRequiresLength(request2) || !this.hasStreamingInput(request2))) {
            entity = ApacheUtils.newBufferedHttpEntity(entity);
        }
        entityEnclosingRequest.setEntity(entity);
    }

    private boolean isRequiresLength(Request<?> request2) {
        return Boolean.TRUE.equals(request2.getHandlerContext(HandlerContextKey.REQUIRES_LENGTH));
    }

    private boolean hasStreamingInput(Request<?> request2) {
        return Boolean.TRUE.equals(request2.getHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT));
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, Request<?> request2) {
        httpRequest.addHeader("Host", this.getHostHeaderValue(request2.getEndpoint()));
        for (Map.Entry<String, String> entry : request2.getHeaders().entrySet()) {
            if (ignoreHeaders.contains(entry.getKey())) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private boolean shouldMoveQueryParametersToBody(Request<?> request2, String encodedParams) {
        boolean requestIsPost = request2.getHttpMethod() == HttpMethodName.POST;
        return requestIsPost && request2.getContent() == null && encodedParams != null;
    }

    private HttpRequestBase createPostParamsInBodyRequest(String endpointUri, String encodedParams) {
        HttpPost requestBase = new HttpPost(endpointUri);
        requestBase.setEntity(ApacheUtils.newStringEntity(encodedParams));
        return requestBase;
    }

    private void addContentTypeHeaderIfNeeded(HttpRequestBase base) {
        if (base.getHeaders("Content-Type") == null || base.getHeaders("Content-Type").length == 0) {
            base.addHeader("Content-Type", QUERY_PARAM_CONTENT_TYPE);
        }
    }

    private String getHostHeaderValue(URI endpoint) {
        return SdkHttpUtils.isUsingNonDefaultPort(endpoint) ? endpoint.getHost() + ":" + endpoint.getPort() : endpoint.getHost();
    }

    private void addProxyConfig(RequestConfig.Builder requestConfigBuilder, HttpClientSettings settings) {
        if (settings.isProxyEnabled() && settings.isAuthenticatedProxy() && settings.getProxyAuthenticationMethods() != null) {
            ArrayList<String> apacheAuthenticationSchemes = new ArrayList<String>();
            for (ProxyAuthenticationMethod authenticationMethod : settings.getProxyAuthenticationMethods()) {
                apacheAuthenticationSchemes.add(this.toApacheAuthenticationScheme(authenticationMethod));
            }
            requestConfigBuilder.setProxyPreferredAuthSchemes(apacheAuthenticationSchemes);
        }
    }

    private String toApacheAuthenticationScheme(ProxyAuthenticationMethod authenticationMethod) {
        if (authenticationMethod == null) {
            throw new IllegalStateException("The configured proxy authentication methods must not be null.");
        }
        switch (authenticationMethod) {
            case NTLM: {
                return "NTLM";
            }
            case BASIC: {
                return "Basic";
            }
            case DIGEST: {
                return "Digest";
            }
            case SPNEGO: {
                return "Negotiate";
            }
            case KERBEROS: {
                return "Kerberos";
            }
        }
        throw new IllegalStateException("Unknown authentication scheme: " + (Object)((Object)authenticationMethod));
    }
}

