/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.http.protocol;

import ai.h2o.com.amazonaws.internal.SdkMetricsSocket;
import ai.h2o.com.amazonaws.internal.SdkSSLMetricsSocket;
import ai.h2o.com.amazonaws.util.AWSRequestMetrics;
import ai.h2o.org.apache.http.HttpClientConnection;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpResponse;
import ai.h2o.org.apache.http.conn.ManagedHttpClientConnection;
import ai.h2o.org.apache.http.protocol.HttpContext;
import ai.h2o.org.apache.http.protocol.HttpRequestExecutor;
import java.io.IOException;
import java.net.Socket;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest request2, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.SIMPLE_NAME);
        if (awsRequestMetrics == null) {
            return super.doSendRequest(request2, conn, context);
        }
        if (conn instanceof ManagedHttpClientConnection) {
            ManagedHttpClientConnection managedConn = (ManagedHttpClientConnection)conn;
            Socket sock = managedConn.getSocket();
            if (sock instanceof SdkMetricsSocket) {
                SdkMetricsSocket sdkMetricsSocket = (SdkMetricsSocket)sock;
                sdkMetricsSocket.setMetrics(awsRequestMetrics);
            } else if (sock instanceof SdkSSLMetricsSocket) {
                SdkSSLMetricsSocket sdkSSLMetricsSocket = (SdkSSLMetricsSocket)sock;
                sdkSSLMetricsSocket.setMetrics(awsRequestMetrics);
            }
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            HttpResponse httpResponse = super.doSendRequest(request2, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest request2, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.SIMPLE_NAME);
        if (awsRequestMetrics == null) {
            return super.doReceiveResponse(request2, conn, context);
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(request2, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

