/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.internal;

import ai.h2o.com.amazonaws.internal.DelegateInputStream;
import ai.h2o.com.amazonaws.util.AWSRequestMetrics;
import java.io.IOException;
import java.io.InputStream;

public class MetricsInputStream
extends DelegateInputStream {
    private AWSRequestMetrics metrics;

    public MetricsInputStream(InputStream in) {
        super(in);
    }

    public void setMetrics(AWSRequestMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public int read() throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n2 = this.in.read();
            return n2;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }

    @Override
    public int read(byte[] b2) throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n2 = this.in.read(b2);
            return n2;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n2 = this.in.read(b2, off, len);
            return n2;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }
}

