/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.internal;

import ai.h2o.com.amazonaws.annotation.NotThreadSafe;
import ai.h2o.com.amazonaws.internal.Releasable;
import ai.h2o.com.amazonaws.internal.ResettableInputStream;
import ai.h2o.com.amazonaws.internal.SdkFilterInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class ReleasableInputStream
extends SdkFilterInputStream
implements Releasable {
    private static final Log log = LogFactory.getLog(ReleasableInputStream.class);
    private boolean closeDisabled;

    protected ReleasableInputStream(InputStream is) {
        super(is);
    }

    @Override
    public final void close() {
        if (!this.closeDisabled) {
            this.doRelease();
        }
    }

    @Override
    public final void release() {
        this.doRelease();
    }

    private void doRelease() {
        block3: {
            try {
                this.in.close();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"FYI", (Throwable)ex);
            }
        }
        if (this.in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)this.in);
            r2.release();
        }
        this.abortIfNeeded();
    }

    public final boolean isCloseDisabled() {
        return this.closeDisabled;
    }

    public final <T extends ReleasableInputStream> T disableClose() {
        this.closeDisabled = true;
        ReleasableInputStream t2 = this;
        return (T)t2;
    }

    public static ReleasableInputStream wrap(InputStream is) {
        if (is instanceof ReleasableInputStream) {
            return (ReleasableInputStream)is;
        }
        if (is instanceof FileInputStream) {
            return ResettableInputStream.newResettableInputStream((FileInputStream)is);
        }
        return new ReleasableInputStream(is);
    }
}

