/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.internal;

import ai.h2o.com.amazonaws.internal.MetricAware;
import ai.h2o.com.amazonaws.internal.Releasable;
import ai.h2o.com.amazonaws.internal.SdkIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SdkDigestInputStream
extends DigestInputStream
implements MetricAware,
Releasable {
    private static final int SKIP_BUF_SIZE = 2048;

    public SdkDigestInputStream(InputStream stream, MessageDigest digest) {
        super(stream, digest);
    }

    @Override
    public final boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    @Override
    public final long skip(long n2) throws IOException {
        long m4;
        int len;
        if (n2 <= 0L) {
            return n2;
        }
        byte[] b2 = new byte[(int)Math.min(2048L, n2)];
        for (m4 = n2; m4 > 0L; m4 -= (long)len) {
            len = this.read(b2, 0, (int)Math.min(m4, (long)b2.length));
            if (len != -1) continue;
            return n2 - m4;
        }
        assert (m4 == 0L);
        return n2;
    }

    @Override
    public final void release() {
        SdkIOUtils.closeQuietly(this);
        if (this.in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)this.in);
            r2.release();
        }
    }
}

