/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.monitoring;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.annotation.ThreadSafe;
import ai.h2o.com.amazonaws.monitoring.CsmConfiguration;
import ai.h2o.com.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class SystemPropertyCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() throws SdkClientException {
        String enabled = System.getProperty("ai.h2o.com.amazonaws.sdk.csm.enabled");
        if (enabled == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!");
        }
        String host = System.getProperty("ai.h2o.com.amazonaws.sdk.csm.host", "127.0.0.1");
        String port = System.getProperty("ai.h2o.com.amazonaws.sdk.csm.port");
        String clientId = System.getProperty("ai.h2o.com.amazonaws.sdk.csm.clientId", "");
        try {
            int portNumber = port == null ? 31000 : Integer.parseInt(port);
            return CsmConfiguration.builder().withEnabled(Boolean.parseBoolean(enabled)).withHost(host).withPort(portNumber).withClientId(clientId).build();
        }
        catch (Exception e2) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!", e2);
        }
    }
}

