/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.regions;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.auth.AWSCredentialsProviderChain;
import ai.h2o.com.amazonaws.regions.AwsRegionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsRegionProviderChain
extends AwsRegionProvider {
    private static final Log LOG = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private final List<AwsRegionProvider> providers;

    public AwsRegionProviderChain(AwsRegionProvider ... providers) {
        this.providers = new ArrayList<AwsRegionProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    @Override
    public String getRegion() throws SdkClientException {
        for (AwsRegionProvider provider : this.providers) {
            try {
                String region = provider.getRegion();
                if (region == null) continue;
                return region;
            }
            catch (Exception e2) {
                LOG.debug((Object)("Unable to load region from " + provider.toString() + ": " + e2.getMessage()));
            }
        }
        throw new SdkClientException("Unable to load region information from any provider in the chain");
    }
}

