/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.retry.v2;

import ai.h2o.com.amazonaws.retry.v2.RetryCondition;
import ai.h2o.com.amazonaws.retry.v2.RetryPolicyContext;
import ai.h2o.com.amazonaws.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(maxNumberOfRetries, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < this.maxNumberOfRetries;
    }
}

