/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal;

import ai.h2o.com.amazonaws.ReadLimitInfo;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.ResetException;
import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.SignableRequest;
import ai.h2o.com.amazonaws.auth.AWS4Signer;
import ai.h2o.com.amazonaws.auth.AwsChunkedEncodingInputStream;
import ai.h2o.com.amazonaws.auth.internal.AWS4SignerRequestParams;
import ai.h2o.com.amazonaws.services.s3.model.PutObjectRequest;
import ai.h2o.com.amazonaws.services.s3.model.UploadPartRequest;
import ai.h2o.com.amazonaws.services.s3.request.S3HandlerContextKeys;
import ai.h2o.com.amazonaws.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;

public class AWSS3V4Signer
extends AWS4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";

    public AWSS3V4Signer() {
        super(false);
    }

    @Override
    protected void processRequestPayload(SignableRequest<?> request2, byte[] signature, byte[] signingKey, AWS4SignerRequestParams signerRequestParams) {
        if (this.useChunkEncoding(request2)) {
            AwsChunkedEncodingInputStream chunkEncodededStream = new AwsChunkedEncodingInputStream(request2.getContent(), signingKey, signerRequestParams.getFormattedSigningDateTime(), signerRequestParams.getScope(), BinaryUtils.toHex(signature), this);
            request2.setContent(chunkEncodededStream);
        }
    }

    @Override
    protected String calculateContentHashPresign(SignableRequest<?> request2) {
        return UNSIGNED_PAYLOAD;
    }

    @Override
    protected String calculateContentHash(SignableRequest<?> request2) {
        request2.addHeader("x-amz-content-sha256", "required");
        if (this.isPayloadSigningEnabled(request2)) {
            if (this.useChunkEncoding(request2)) {
                long originalContentLength;
                String contentLength = request2.getHeaders().get("Content-Length");
                if (contentLength != null) {
                    originalContentLength = Long.parseLong(contentLength);
                } else {
                    try {
                        originalContentLength = AWSS3V4Signer.getContentLength(request2);
                    }
                    catch (IOException e2) {
                        throw new SdkClientException("Cannot get the content-length of the request content.", e2);
                    }
                }
                request2.addHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
                request2.addHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
                return CONTENT_SHA_256;
            }
            return super.calculateContentHash(request2);
        }
        return UNSIGNED_PAYLOAD;
    }

    private boolean useChunkEncoding(SignableRequest<?> request2) {
        if (!this.isPayloadSigningEnabled(request2) || this.isChunkedEncodingDisabled(request2)) {
            return false;
        }
        return request2.getOriginalRequestObject() instanceof PutObjectRequest || request2.getOriginalRequestObject() instanceof UploadPartRequest;
    }

    private boolean isChunkedEncodingDisabled(SignableRequest<?> signableRequest) {
        if (signableRequest instanceof Request) {
            Request request2 = (Request)signableRequest;
            Boolean isChunkedEncodingDisabled = request2.getHandlerContext(S3HandlerContextKeys.IS_CHUNKED_ENCODING_DISABLED);
            return isChunkedEncodingDisabled != null && isChunkedEncodingDisabled != false;
        }
        return false;
    }

    private boolean isPayloadSigningEnabled(SignableRequest<?> signableRequest) {
        if (!signableRequest.getEndpoint().getScheme().equals("https")) {
            return true;
        }
        if (signableRequest instanceof Request) {
            Request request2 = (Request)signableRequest;
            Boolean isPayloadSigningEnabled = request2.getHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED);
            return isPayloadSigningEnabled != null && isPayloadSigningEnabled != false;
        }
        return false;
    }

    static long getContentLength(SignableRequest<?> request2) throws IOException {
        int read;
        InputStream content = request2.getContent();
        if (!content.markSupported()) {
            throw new IllegalStateException("Bug: request input stream must have been made mark-and-resettable at this point");
        }
        ReadLimitInfo info = request2.getReadLimitInfo();
        int readLimit = info.getReadLimit();
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        content.mark(readLimit);
        while ((read = content.read(tmp)) != -1) {
            contentLength += (long)read;
        }
        try {
            content.reset();
        }
        catch (IOException ex) {
            throw new ResetException("Failed to reset the input stream", ex);
        }
        return contentLength;
    }
}

