/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.internal.SdkDigestInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigestValidationInputStream
extends SdkDigestInputStream {
    private byte[] expectedHash;
    private boolean digestValidated = false;

    public DigestValidationInputStream(InputStream in, MessageDigest digest, byte[] serverSideHash) {
        super(in, digest);
        this.expectedHash = serverSideHash;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch == -1) {
            this.validateMD5Digest();
        }
        return ch;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int result = super.read(b2, off, len);
        if (result == -1) {
            this.validateMD5Digest();
        }
        return result;
    }

    public byte[] getMD5Checksum() {
        return this.digest.digest();
    }

    private void validateMD5Digest() {
        if (this.expectedHash != null && !this.digestValidated) {
            this.digestValidated = true;
            if (!Arrays.equals(this.digest.digest(), this.expectedHash)) {
                throw new SdkClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data may be corrupt.");
            }
        }
    }
}

